/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import com.google.android.gms.internal.zza;
import com.google.android.gms.internal.zzaa;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzc;
import com.google.android.gms.internal.zzf;
import com.google.android.gms.internal.zzk;
import com.google.android.gms.internal.zzm;
import com.google.android.gms.internal.zzn;
import com.google.android.gms.internal.zzo;
import com.google.android.gms.internal.zzp;
import com.google.android.gms.internal.zzx;
import com.google.android.gms.internal.zzy;
import com.google.android.gms.internal.zzz;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.cookie.DateUtils;

public final class zzad
implements zzk {
    private static boolean DEBUG = zzab.DEBUG;
    private static int zzam = 3000;
    private static int zzan = 4096;
    private zzan zzao;
    private zzae zzap;

    public zzad(zzan zzan2) {
        this(zzan2, new zzae(zzan));
    }

    private zzad(zzan zzan2, zzae zzae2) {
        this.zzao = zzan2;
        this.zzap = zzae2;
    }

    @Override
    public final zzn zza(zzp<?> zzp2) throws zzaa {
        long l = SystemClock.elapsedRealtime();
        while (true) {
            HttpResponse httpResponse = null;
            byte[] byArray = null;
            Map<String, String> map = Collections.emptyMap();
            try {
                Object object;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                zzc zzc2 = zzp2.zze();
                HashMap<String, String> hashMap2 = hashMap;
                if (zzc2 != null) {
                    if (zzc2.zza != null) {
                        hashMap2.put("If-None-Match", zzc2.zza);
                    }
                    if (zzc2.zzc > 0L) {
                        object = new Date(zzc2.zzc);
                        hashMap2.put("If-Modified-Since", DateUtils.formatDate((Date)object));
                    }
                }
                httpResponse = this.zzao.zza(zzp2, hashMap);
                StatusLine statusLine = httpResponse.getStatusLine();
                int n = statusLine.getStatusCode();
                map = zzad.zza(httpResponse.getAllHeaders());
                if (n == 304) {
                    zzc zzc3 = zzp2.zze();
                    if (zzc3 == null) {
                        return new zzn(304, null, map, true, SystemClock.elapsedRealtime() - l);
                    }
                    zzc3.zzf.putAll(map);
                    return new zzn(304, zzc3.data, zzc3.zzf, true, SystemClock.elapsedRealtime() - l);
                }
                byArray = httpResponse.getEntity() != null ? this.zza(httpResponse.getEntity()) : new byte[]{};
                StatusLine statusLine2 = statusLine;
                object = byArray;
                zzp<?> zzp3 = zzp2;
                long l2 = SystemClock.elapsedRealtime() - l;
                if (DEBUG || l2 > (long)zzam) {
                    zzab.zzb("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", zzp3, l2, object != null ? Integer.valueOf(((Object)object).length) : "null", statusLine2.getStatusCode(), zzp3.zzj().zzb());
                }
                if (n < 200 || n > 299) {
                    throw new IOException();
                }
                return new zzn(n, byArray, map, false, SystemClock.elapsedRealtime() - l);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                zzad.zza("socket", zzp2, new zzz());
                continue;
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                zzad.zza("connection", zzp2, new zzz());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = String.valueOf(zzp2.getUrl());
                throw new RuntimeException(string2.length() != 0 ? "Bad URL ".concat(string2) : new String("Bad URL "), malformedURLException);
            }
            catch (IOException iOException) {
                if (httpResponse == null) {
                    throw new zzo(iOException);
                }
                int n = httpResponse.getStatusLine().getStatusCode();
                zzab.zzc("Unexpected response code %d for %s", n, zzp2.getUrl());
                if (byArray != null) {
                    zzn zzn2 = new zzn(n, byArray, map, false, SystemClock.elapsedRealtime() - l);
                    if (n == 401 || n == 403) {
                        zzad.zza("auth", zzp2, new zza(zzn2));
                        continue;
                    }
                    if (n >= 400 && n <= 499) {
                        throw new zzf(zzn2);
                    }
                    if (n >= 500 && n <= 599) {
                        throw new zzy(zzn2);
                    }
                    throw new zzy(zzn2);
                }
                zzad.zza("network", zzp2, new zzm());
                continue;
            }
            break;
        }
    }

    private static void zza(String string2, zzp<?> zzp2, zzaa zzaa2) throws zzaa {
        zzx zzx2 = zzp2.zzj();
        int n = zzp2.zzi();
        try {
            zzx2.zza(zzaa2);
        }
        catch (zzaa zzaa3) {
            zzp2.zzb(String.format("%s-timeout-giveup [timeout=%s]", string2, n));
            throw zzaa3;
        }
        zzp2.zzb(String.format("%s-retry [timeout=%s]", string2, n));
    }

    private final byte[] zza(HttpEntity httpEntity) throws IOException, zzy {
        byte[] byArray;
        zzaq zzaq2 = new zzaq(this.zzap, (int)httpEntity.getContentLength());
        byte[] byArray2 = null;
        try {
            int n;
            InputStream inputStream = httpEntity.getContent();
            if (inputStream == null) {
                throw new zzy();
            }
            byArray2 = this.zzap.zzb(1024);
            while ((n = inputStream.read(byArray2)) != -1) {
                zzaq2.write(byArray2, 0, n);
            }
            byArray = zzaq2.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                httpEntity.consumeContent();
            }
            catch (IOException iOException) {
                zzab.zza("Error occured when calling consumingContent", new Object[0]);
            }
            this.zzap.zza(byArray2);
            zzaq2.close();
            throw throwable;
        }
        try {
            httpEntity.consumeContent();
        }
        catch (IOException iOException) {
            zzab.zza("Error occured when calling consumingContent", new Object[0]);
        }
        this.zzap.zza(byArray2);
        zzaq2.close();
        return byArray;
    }

    private static Map<String, String> zza(Header[] headerArray) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < headerArray.length; ++i) {
            treeMap.put(headerArray[i].getName(), headerArray[i].getValue());
        }
        return treeMap;
    }
}

