/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.zzb;
import java.util.Arrays;

public final class ConnectionResult
extends zza {
    public static final int SUCCESS = 0;
    public static final int SERVICE_MISSING = 1;
    public static final int SERVICE_VERSION_UPDATE_REQUIRED = 2;
    public static final int SERVICE_DISABLED = 3;
    public static final int SIGN_IN_REQUIRED = 4;
    public static final int INVALID_ACCOUNT = 5;
    public static final int RESOLUTION_REQUIRED = 6;
    public static final int NETWORK_ERROR = 7;
    public static final int INTERNAL_ERROR = 8;
    public static final int SERVICE_INVALID = 9;
    public static final int DEVELOPER_ERROR = 10;
    public static final int LICENSE_CHECK_FAILED = 11;
    public static final int CANCELED = 13;
    public static final int TIMEOUT = 14;
    public static final int INTERRUPTED = 15;
    public static final int API_UNAVAILABLE = 16;
    public static final int SIGN_IN_FAILED = 17;
    public static final int SERVICE_UPDATING = 18;
    public static final int SERVICE_MISSING_PERMISSION = 19;
    public static final int RESTRICTED_PROFILE = 20;
    @Deprecated
    public static final int DRIVE_EXTERNAL_STORAGE_REQUIRED = 1500;
    public static final ConnectionResult zzazX = new ConnectionResult(0);
    public static final Parcelable.Creator<ConnectionResult> CREATOR = new zzb();
    private int zzaku;
    private final int zzaxu;
    private final PendingIntent mPendingIntent;
    private final String zzazY;

    ConnectionResult(int n, int n2, PendingIntent pendingIntent, String string) {
        this.zzaku = n;
        this.zzaxu = n2;
        this.mPendingIntent = pendingIntent;
        this.zzazY = string;
    }

    public ConnectionResult(int n) {
        this(n, null, null);
    }

    public ConnectionResult(int n, PendingIntent pendingIntent) {
        this(n, pendingIntent, null);
    }

    public ConnectionResult(int n, PendingIntent pendingIntent, String string) {
        this(1, n, pendingIntent, string);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    public final boolean hasResolution() {
        return this.zzaxu != 0 && this.mPendingIntent != null;
    }

    public final boolean isSuccess() {
        return this.zzaxu == 0;
    }

    public final int getErrorCode() {
        return this.zzaxu;
    }

    @Nullable
    public final PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    @Nullable
    public final String getErrorMessage() {
        return this.zzazY;
    }

    static String getStatusString(int n) {
        switch (n) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 4: {
                return "SIGN_IN_REQUIRED";
            }
            case 5: {
                return "INVALID_ACCOUNT";
            }
            case 6: {
                return "RESOLUTION_REQUIRED";
            }
            case 7: {
                return "NETWORK_ERROR";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
            case 10: {
                return "DEVELOPER_ERROR";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED";
            }
            case 13: {
                return "CANCELED";
            }
            case 14: {
                return "TIMEOUT";
            }
            case 15: {
                return "INTERRUPTED";
            }
            case 16: {
                return "API_UNAVAILABLE";
            }
            case 17: {
                return "SIGN_IN_FAILED";
            }
            case 18: {
                return "SERVICE_UPDATING";
            }
            case 19: {
                return "SERVICE_MISSING_PERMISSION";
            }
            case 20: {
                return "RESTRICTED_PROFILE";
            }
            case 21: {
                return "API_VERSION_UPDATE_REQUIRED";
            }
            case 1500: {
                return "DRIVE_EXTERNAL_STORAGE_REQUIRED";
            }
            case 99: {
                return "UNFINISHED";
            }
            case -1: {
                return "UNKNOWN";
            }
        }
        return new StringBuilder(31).append("UNKNOWN_ERROR_CODE(").append(n).append(")").toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConnectionResult)) {
            return false;
        }
        ConnectionResult connectionResult = (ConnectionResult)object;
        return this.zzaxu == connectionResult.zzaxu && zzbe.equal(this.mPendingIntent, connectionResult.mPendingIntent) && zzbe.equal(this.zzazY, connectionResult.zzazY);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaxu, this.mPendingIntent, this.zzazY});
    }

    public final String toString() {
        return zzbe.zzt(this).zzg("statusCode", ConnectionResult.getStatusString(this.zzaxu)).zzg("resolution", this.mPendingIntent).zzg("message", this.zzazY).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ConnectionResult connectionResult = this;
        int n2 = zzd.zze(parcel2);
        zzd.zzc(parcel2, 1, connectionResult.zzaku);
        zzd.zzc(parcel2, 2, connectionResult.getErrorCode());
        zzd.zza(parcel2, 3, (Parcelable)connectionResult.getResolution(), n, false);
        zzd.zza(parcel2, 4, connectionResult.getErrorMessage(), false);
        zzd.zzI(parcel2, n2);
    }
}

