/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.zze;
import com.google.android.gms.common.zzo;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzfe;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@KeepForSdkWithMembers
public class AdvertisingIdClient {
    @Nullable
    private com.google.android.gms.common.zza zzsz;
    @Nullable
    private zzfd zzsA;
    private boolean zzsB;
    private Object zzsC = new Object();
    @Nullable
    private zza zzsD;
    private final Context mContext;
    private long zzsE;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false);
    }

    public AdvertisingIdClient(Context context, long l, boolean bl) {
        Context context2;
        zzbo.zzu(context);
        this.mContext = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzsB = false;
        this.zzsE = l;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void start(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzbo.zzcG("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzsB) {
                this.finish();
            }
            this.zzsz = AdvertisingIdClient.zzd(this.mContext);
            this.zzsA = AdvertisingIdClient.zza(this.mContext, this.zzsz);
            this.zzsB = true;
            if (bl) {
                this.zzaj();
            }
            return;
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzaj() {
        Object object = this.zzsC;
        synchronized (object) {
            if (this.zzsD != null) {
                this.zzsD.zzsI.countDown();
                try {
                    this.zzsD.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzsE > 0L) {
                this.zzsD = new zza(this, this.zzsE);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        Info info;
        zzbo.zzcG("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzsB) {
                Object object = this.zzsC;
                synchronized (object) {
                    if (this.zzsD == null || !this.zzsD.zzsJ) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.start(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzsB) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbo.zzu(this.zzsz);
            zzbo.zzu(this.zzsA);
            try {
                info = new Info(this.zzsA.getId(), this.zzsA.zzb(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzaj();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzbo.zzcG("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzsz == null) {
                return;
            }
            try {
                if (this.zzsB) {
                    com.google.android.gms.common.stats.zza.zzrU();
                    com.google.android.gms.common.zza zza2 = this.zzsz;
                    Context context = this.mContext;
                    context.unbindService((ServiceConnection)zza2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzsB = false;
            this.zzsA = null;
            this.zzsz = null;
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static com.google.android.gms.common.zza zzd(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        switch (zze.zzoW().isGooglePlayServicesAvailable(context)) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zzrU().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    @Nullable
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        boolean bl = false;
        float f = 0.0f;
        try {
            object = zzo.getRemoteContext(context);
            if (object != null) {
                SharedPreferences sharedPreferences = object.getSharedPreferences("google_ads_flags", 0);
                bl = sharedPreferences.getBoolean("gads:ad_id_app_context:enabled", false);
                f = sharedPreferences.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
            }
        }
        catch (Exception exception) {
            Log.w((String)"AdvertisingIdClient", (String)"Error while reading from SharedPreferences ", (Throwable)exception);
        }
        object = new AdvertisingIdClient(context, -1L, bl);
        try {
            super.start(false);
            Info info = ((AdvertisingIdClient)object).getInfo();
            super.zza(info, bl, f, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            super.zza(null, bl, f, throwable);
            return null;
        }
        finally {
            ((AdvertisingIdClient)object).finish();
        }
    }

    private final void zza(Info info, boolean bl, float f, Throwable throwable) {
        if (Math.random() > (double)f) {
            return;
        }
        Throwable throwable2 = throwable;
        boolean bl2 = bl;
        Info info2 = info;
        Bundle bundle = new Bundle();
        bundle.putString("app_context", bl2 ? "1" : "0");
        if (info2 != null) {
            bundle.putString("limit_ad_tracking", info2.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info2 != null && info2.getId() != null) {
            bundle.putString("ad_id_size", Integer.toString(info2.getId().length()));
        }
        if (throwable2 != null) {
            bundle.putString("error", throwable2.getClass().getName());
        }
        Uri.Builder builder = Uri.parse((String)"https://pagead2.googlesyndication.com/pagead/gen_204?id=gmob-apps").buildUpon();
        for (String string2 : bundle.keySet()) {
            builder.appendQueryParameter(string2, bundle.getString(string2));
        }
        String string3 = builder.build().toString();
        new com.google.android.gms.ads.identifier.zza(this, string3).start();
    }

    private static zzfd zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzfe.zzc(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzsK;
        private final boolean zzsL;

        public Info(String string2, boolean bl) {
            this.zzsK = string2;
            this.zzsL = bl;
        }

        public final String getId() {
            return this.zzsK;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.zzsL;
        }

        public final String toString() {
            String string2 = this.zzsK;
            boolean bl = this.zzsL;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl).toString();
        }
    }

    static final class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzsG;
        private long zzsH;
        CountDownLatch zzsI;
        boolean zzsJ;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzsG = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzsH = l;
            this.zzsI = new CountDownLatch(1);
            this.zzsJ = false;
            this.start();
        }

        private final void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzsG.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzsJ = true;
            }
        }

        @Override
        public final void run() {
            try {
                if (!this.zzsI.await(this.zzsH, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
                return;
            }
        }
    }
}

