/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzai;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzb;
import com.google.android.gms.internal.zzc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class zzag
implements zzb {
    private final Map<String, zzai> zzav = new LinkedHashMap<String, zzai>(16, 0.75f, true);
    private long zzaw = 0L;
    private final File zzax;
    private final int zzay;

    private zzag(File file, int n) {
        this.zzax = file;
        this.zzay = 0x500000;
    }

    public zzag(File file) {
        this(file, 0x500000);
    }

    /*
     * Loose catch block
     */
    @Override
    public final synchronized zzc zza(String string2) {
        byte[] byArray;
        zzai zzai2 = this.zzav.get(string2);
        if (zzai2 == null) {
            return null;
        }
        File file = this.zze(string2);
        FilterInputStream filterInputStream = null;
        filterInputStream = new zzaj(new BufferedInputStream(new FileInputStream(file)), null);
        zzai.zzf(filterInputStream);
        byte[] byArray2 = byArray = zzag.zza(filterInputStream, (int)(file.length() - (long)zzaj.zza((zzaj)filterInputStream)));
        zzai zzai3 = zzai2;
        zzc zzc2 = new zzc();
        new zzc().data = byArray2;
        zzc2.zza = zzai3.zza;
        zzc2.zzb = zzai3.zzb;
        zzc2.zzc = zzai3.zzc;
        zzc2.zzd = zzai3.zzd;
        zzc2.zze = zzai3.zze;
        zzc2.zzf = zzai3.zzf;
        zzc zzc3 = zzc2;
        try {
            filterInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return zzc3;
        catch (IOException iOException) {
            block16: {
                zzab.zzb("%s: %s", file.getAbsolutePath(), iOException.toString());
                this.remove(string2);
                if (filterInputStream == null) break block16;
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException2) {
                    return null;
                }
            }
            return null;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            block17: {
                zzab.zzb("%s: %s", file.getAbsolutePath(), negativeArraySizeException.toString());
                this.remove(string2);
                if (filterInputStream == null) break block17;
                {
                    catch (Throwable throwable) {
                        if (filterInputStream != null) {
                            try {
                                filterInputStream.close();
                            }
                            catch (IOException iOException) {
                                return null;
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return null;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public final synchronized void initialize() {
        if (!this.zzax.exists()) {
            if (!this.zzax.mkdirs()) {
                zzab.zzc("Unable to create cache dir %s", this.zzax.getAbsolutePath());
            }
            return;
        }
        File[] fileArray = this.zzax.listFiles();
        if (fileArray == null) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file = fileArray2[i];
            BufferedInputStream bufferedInputStream = null;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            zzai zzai2 = zzai.zzf(bufferedInputStream);
            zzai.zzf(bufferedInputStream).zzaz = file.length();
            this.zza(zzai2.key, zzai2);
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
            continue;
            catch (IOException iOException) {
                block15: {
                    try {
                        if (file == null) break block15;
                        file.delete();
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bufferedInputStream != null) {
                                bufferedInputStream.close();
                            }
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
                try {
                    if (bufferedInputStream == null) continue;
                    bufferedInputStream.close();
                }
                catch (IOException iOException3) {}
                continue;
            }
        }
    }

    @Override
    public final synchronized void zza(String string2, zzc zzc2) {
        int n = zzc2.data.length;
        zzag zzag2 = this;
        if (zzag2.zzaw + (long)n >= (long)zzag2.zzay) {
            if (zzab.DEBUG) {
                zzab.zza("Pruning old cache entries.", new Object[0]);
            }
            long l = zzag2.zzaw;
            int n2 = 0;
            long l2 = SystemClock.elapsedRealtime();
            Iterator<Map.Entry<String, zzai>> iterator = zzag2.zzav.entrySet().iterator();
            while (iterator.hasNext()) {
                zzai zzai2 = iterator.next().getValue();
                if (zzag2.zze(zzai2.key).delete()) {
                    zzag2.zzaw -= zzai2.zzaz;
                } else {
                    zzab.zzb("Could not delete cache entry for key=%s, filename=%s", zzai2.key, zzag.zzd(zzai2.key));
                }
                iterator.remove();
                ++n2;
                if (!((float)(zzag2.zzaw + (long)n) < (float)zzag2.zzay * 0.9f)) continue;
            }
            if (zzab.DEBUG) {
                zzab.zza("pruned %d files, %d bytes, %d ms", n2, zzag2.zzaw - l, SystemClock.elapsedRealtime() - l2);
            }
        }
        File file = this.zze(string2);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            zzai zzai3 = new zzai(string2, zzc2);
            if (!zzai3.zza(bufferedOutputStream)) {
                bufferedOutputStream.close();
                zzab.zzb("Failed to write header for %s", file.getAbsolutePath());
                throw new IOException();
            }
            bufferedOutputStream.write(zzc2.data);
            bufferedOutputStream.close();
            this.zza(string2, zzai3);
            return;
        }
        catch (IOException iOException) {
            if (!file.delete()) {
                zzab.zzb("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    private final synchronized void remove(String string2) {
        boolean bl = this.zze(string2).delete();
        String string3 = string2;
        zzag zzag2 = this;
        zzai zzai2 = zzag2.zzav.get(string3);
        if (zzai2 != null) {
            zzag2.zzaw -= zzai2.zzaz;
            zzag2.zzav.remove(string3);
        }
        if (!bl) {
            zzab.zzb("Could not delete cache entry for key=%s, filename=%s", string2, zzag.zzd(string2));
        }
    }

    private static String zzd(String string2) {
        int n = string2.length() / 2;
        String string3 = String.valueOf(String.valueOf(string2.substring(0, n).hashCode()));
        String string4 = String.valueOf(String.valueOf(string2.substring(n).hashCode()));
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    private final File zze(String string2) {
        return new File(this.zzax, zzag.zzd(string2));
    }

    private final void zza(String string2, zzai zzai2) {
        if (!this.zzav.containsKey(string2)) {
            this.zzaw += zzai2.zzaz;
        } else {
            zzai zzai3 = this.zzav.get(string2);
            this.zzaw += zzai2.zzaz - zzai3.zzaz;
        }
        this.zzav.put(string2, zzai2);
    }

    private static byte[] zza(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n && (n3 = inputStream.read(byArray, n2, n - n2)) != -1; n2 += n3) {
        }
        if (n2 != n) {
            int n4 = n2;
            throw new IOException(new StringBuilder(50).append("Expected ").append(n).append(" bytes, read ").append(n4).append(" bytes").toString());
        }
        return byArray;
    }

    private static int zza(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    static void zza(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >>> 24);
    }

    static int zzb(InputStream inputStream) throws IOException {
        return 0 | zzag.zza(inputStream) | zzag.zza(inputStream) << 8 | zzag.zza(inputStream) << 16 | zzag.zza(inputStream) << 24;
    }

    static void zza(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)l);
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 56));
    }

    static long zzc(InputStream inputStream) throws IOException {
        return 0L | (long)zzag.zza(inputStream) & 0xFFL | ((long)zzag.zza(inputStream) & 0xFFL) << 8 | ((long)zzag.zza(inputStream) & 0xFFL) << 16 | ((long)zzag.zza(inputStream) & 0xFFL) << 24 | ((long)zzag.zza(inputStream) & 0xFFL) << 32 | ((long)zzag.zza(inputStream) & 0xFFL) << 40 | ((long)zzag.zza(inputStream) & 0xFFL) << 48 | ((long)zzag.zza(inputStream) & 0xFFL) << 56;
    }

    static void zza(OutputStream outputStream, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF-8");
        zzag.zza(outputStream, (long)byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    static String zzd(InputStream inputStream) throws IOException {
        int n = (int)zzag.zzc(inputStream);
        byte[] byArray = zzag.zza(inputStream, n);
        return new String(byArray, "UTF-8");
    }

    static Map<String, String> zze(InputStream inputStream) throws IOException {
        int n = zzag.zzb(inputStream);
        HashMap<String, String> hashMap = n == 0 ? Collections.emptyMap() : new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = zzag.zzd(inputStream).intern();
            String string3 = zzag.zzd(inputStream).intern();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }
}

