/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamite;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.zze;
import com.google.android.gms.dynamite.zzf;
import com.google.android.gms.dynamite.zzg;
import com.google.android.gms.dynamite.zzh;
import com.google.android.gms.dynamite.zzi;
import com.google.android.gms.dynamite.zzj;
import com.google.android.gms.dynamite.zzk;
import com.google.android.gms.dynamite.zzl;
import com.google.android.gms.dynamite.zzm;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public final class DynamiteModule {
    private static Boolean zzaSJ;
    private static zzj zzaSK;
    private static zzl zzaSL;
    private static String zzaSM;
    private static final ThreadLocal<zza> zzaSN;
    private static final zzh zzaSO;
    public static final zzd zzaSP;
    private static zzd zzaSQ;
    public static final zzd zzaSR;
    public static final zzd zzaSS;
    public static final zzd zzaST;
    private final Context zzaSU;

    /*
     * Loose catch block
     */
    public static DynamiteModule zza(Context context, zzd zzd2, String string2) throws zzc {
        zza zza2 = zzaSN.get();
        zza zza3 = new zza(null);
        zzaSN.set(zza3);
        try {
            zzi zzi2 = zzd2.zza(context, string2, zzaSO);
            int n = zzi2.zzaSY;
            int n2 = zzi2.zzaSZ;
            Log.i((String)"DynamiteModule", (String)new StringBuilder(68 + String.valueOf(string2).length() + String.valueOf(string2).length()).append("Considering local module ").append(string2).append(":").append(n).append(" and remote module ").append(string2).append(":").append(n2).toString());
            if (zzi2.zzaTa == 0 || zzi2.zzaTa == -1 && zzi2.zzaSY == 0 || zzi2.zzaTa == 1 && zzi2.zzaSZ == 0) {
                n = zzi2.zzaSY;
                n2 = zzi2.zzaSZ;
                throw new zzc(new StringBuilder(91).append("No acceptable module found. Local version is ").append(n).append(" and remote version is ").append(n2).append(".").toString(), null);
            }
            if (zzi2.zzaTa == -1) {
                DynamiteModule dynamiteModule = DynamiteModule.zzH(context, string2);
                return dynamiteModule;
            }
            if (zzi2.zzaTa == 1) {
                try {
                    DynamiteModule dynamiteModule = DynamiteModule.zza(context, string2, zzi2.zzaSZ);
                    return dynamiteModule;
                }
                catch (zzc zzc2) {
                    block12: {
                        DynamiteModule dynamiteModule;
                        block13: {
                            String string3 = String.valueOf(zzc2.getMessage());
                            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load remote module: ".concat(string3) : new String("Failed to load remote module: ")));
                            if (zzi2.zzaSY == 0 || zzd2.zza((Context)context, (String)string2, (zzh)new zzb((int)zzi2.zzaSY, (int)0)).zzaTa != -1) break block12;
                            dynamiteModule = DynamiteModule.zzH(context, string2);
                            if (zza3.zzaSV == null) break block13;
                            zza3.zzaSV.close();
                        }
                        zzaSN.set(zza2);
                        return dynamiteModule;
                    }
                    throw new zzc("Remote load failed. No local fallback found.", zzc2, null);
                }
            }
            n = zzi2.zzaTa;
            throw new zzc(new StringBuilder(47).append("VersionPolicy returned invalid code:").append(n).toString(), null);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (zza3.zzaSV != null) {
                zza3.zzaSV.close();
            }
            zzaSN.set(zza2);
        }
    }

    public static int zzF(Context context, String string2) {
        try {
            Object object = String.valueOf("com.google.android.gms.dynamite.descriptors.");
            Object object2 = String.valueOf("ModuleDescriptor");
            Class<?> clazz = context.getApplicationContext().getClassLoader().loadClass(new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string2).length() + String.valueOf(object2).length()).append((String)object).append(string2).append(".").append((String)object2).toString());
            object = clazz.getDeclaredField("MODULE_ID");
            object2 = clazz.getDeclaredField("MODULE_VERSION");
            if (!((Field)object).get(null).equals(string2)) {
                String string3 = String.valueOf(((Field)object).get(null));
                Log.e((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Module descriptor id '").append(string3).append("' didn't match expected id '").append(string2).append("'").toString());
                return 0;
            }
            return ((Field)object2).getInt(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)"DynamiteModule", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("Local module descriptor class for ").append(string2).append(" not found.").toString());
        }
        catch (Exception exception) {
            String string4 = String.valueOf(exception.getMessage());
            Log.e((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to load module descriptor class: ".concat(string4) : new String("Failed to load module descriptor class: ")));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int zzb(Context context, String string2, boolean bl) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            Boolean bl2 = zzaSJ;
            if (bl2 == null) {
                try {
                    Class<?> clazz2 = context.getApplicationContext().getClassLoader().loadClass(DynamiteLoaderClassLoader.class.getName());
                    Field field = clazz2.getDeclaredField("sClassLoader");
                    Class<?> clazz3 = clazz2;
                    synchronized (clazz3) {
                        Object object = (ClassLoader)field.get(null);
                        if (object != null) {
                            if (object == ClassLoader.getSystemClassLoader()) {
                                bl2 = Boolean.FALSE;
                            } else {
                                try {
                                    DynamiteModule.zza(object);
                                }
                                catch (zzc zzc2) {}
                                bl2 = Boolean.TRUE;
                            }
                        } else if ("com.google.android.gms".equals(context.getApplicationContext().getPackageName())) {
                            field.set(null, ClassLoader.getSystemClassLoader());
                            bl2 = Boolean.FALSE;
                        } else {
                            try {
                                int n = DynamiteModule.zzd(context, string2, bl);
                                if (zzaSM == null || zzaSM.isEmpty()) {
                                    // MONITOREXIT @DISABLED, blocks:[16, 0, 1, 2, 20, 4, 6, 22, 7, 15] lbl30 : MonitorExitStatement: MONITOREXIT : var8_9
                                    // ** MonitorExit[var4_3] (shouldn't be in output)
                                    return n;
                                }
                                object = new zzg(zzaSM, ClassLoader.getSystemClassLoader());
                                DynamiteModule.zza(object);
                                field.set(null, object);
                                zzaSJ = Boolean.TRUE;
                                // MONITOREXIT @DISABLED, blocks:[16, 0, 1, 2, 20, 4, 6, 22, 7] lbl37 : MonitorExitStatement: MONITOREXIT : var8_9
                                // ** MonitorExit[var4_3] (shouldn't be in output)
                                return n;
                            }
                            catch (zzc zzc3) {
                                field.set(null, ClassLoader.getSystemClassLoader());
                                bl2 = Boolean.FALSE;
                            }
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    String string3 = String.valueOf(reflectiveOperationException);
                    Log.w((String)"DynamiteModule", (String)new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to load module via V2: ").append(string3).toString());
                    bl2 = Boolean.FALSE;
                }
                zzaSJ = bl2;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (bl2.booleanValue()) {
                try {
                    return DynamiteModule.zzd(context, string2, bl);
                }
                catch (zzc zzc4) {
                    String string4 = String.valueOf(zzc4.getMessage());
                    Log.w((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to retrieve remote module version: ".concat(string4) : new String("Failed to retrieve remote module version: ")));
                    return 0;
                }
            }
            return DynamiteModule.zzc(context, string2, bl);
        }
    }

    private static int zzc(Context context, String string2, boolean bl) {
        zzj zzj2 = DynamiteModule.zzaT(context);
        if (zzj2 == null) {
            return 0;
        }
        try {
            return zzj2.zza(zzn.zzw(context), string2, bl);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(remoteException.getMessage());
            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to retrieve remote module version: ".concat(string3) : new String("Failed to retrieve remote module version: ")));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int zzd(Context context, String string2, boolean bl) throws zzc {
        try (Cursor cursor = null;){
            boolean bl2 = bl;
            String string3 = string2;
            Context context2 = context;
            String string4 = bl2 ? "api_force_staging" : "api";
            String string5 = String.valueOf("content://com.google.android.gms.chimera/");
            Uri uri = Uri.parse((String)new StringBuilder(1 + String.valueOf(string5).length() + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string5).append(string4).append("/").append(string3).toString());
            cursor = context2.getContentResolver().query(uri, null, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                Log.w((String)"DynamiteModule", (String)"Failed to retrieve remote module version.");
                throw new zzc("Failed to connect to dynamite module ContentResolver.", null);
            }
            int n = cursor.getInt(0);
            if (n <= 0) return n;
            Object object = DynamiteModule.class;
            synchronized (DynamiteModule.class) {
                zzaSM = cursor.getString(2);
                // ** MonitorExit[var5_12] (shouldn't be in output)
                object = zzaSN.get();
                if (object == null || ((zza)object).zzaSV != null) return n;
                ((zza)object).zzaSV = cursor;
                cursor = null;
                return n;
            }
        }
    }

    public static int zzG(Context context, String string2) {
        return DynamiteModule.zzb(context, string2, false);
    }

    private static DynamiteModule zzH(Context context, String string2) {
        String string3 = String.valueOf(string2);
        Log.i((String)"DynamiteModule", (String)(string3.length() != 0 ? "Selected local version of ".concat(string3) : new String("Selected local version of ")));
        return new DynamiteModule(context.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zza(Context context, String string2, int n) throws zzc {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            Boolean bl = zzaSJ;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (bl == null) {
                throw new zzc("Failed to determine which loading route to use.", null);
            }
            if (bl.booleanValue()) {
                return DynamiteModule.zzc(context, string2, n);
            }
            return DynamiteModule.zzb(context, string2, n);
        }
    }

    private static DynamiteModule zzb(Context context, String string2, int n) throws zzc {
        IObjectWrapper iObjectWrapper;
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        zzj zzj2 = DynamiteModule.zzaT(context);
        if (zzj2 == null) {
            throw new zzc("Failed to create IDynamiteLoader.", null);
        }
        try {
            iObjectWrapper = zzj2.zza(zzn.zzw(context), string2, n);
        }
        catch (RemoteException remoteException) {
            throw new zzc("Failed to load remote module.", remoteException, null);
        }
        if (zzn.zzE(iObjectWrapper) == null) {
            throw new zzc("Failed to load remote module.", null);
        }
        return new DynamiteModule((Context)zzn.zzE(iObjectWrapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zzj zzaT(Context context) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            if (zzaSK != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return zzaSK;
            }
            if (com.google.android.gms.common.zze.zzoU().isGooglePlayServicesAvailable(context) != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            try {
                IInterface iInterface;
                zzj zzj2;
                IBinder iBinder = (IBinder)context.createPackageContext("com.google.android.gms", 3).getClassLoader().loadClass("com.google.android.gms.chimera.container.DynamiteLoaderImpl").newInstance();
                if ((iBinder == null ? null : (zzj2 = (iInterface = iBinder.queryLocalInterface("com.google.android.gms.dynamite.IDynamiteLoader")) instanceof zzj ? (zzj)iInterface : new zzk(iBinder))) != null) {
                    zzaSK = zzj2;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return zzj2;
                }
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"DynamiteModule", (String)(string2.length() != 0 ? "Failed to load IDynamiteLoader from GmsCore: ".concat(string2) : new String("Failed to load IDynamiteLoader from GmsCore: ")));
            }
            return null;
        }
    }

    public final Context zztB() {
        return this.zzaSU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zzc(Context context, String string2, int n) throws zzc {
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        Object object = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            zzl zzl2 = zzaSL;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (zzl2 == null) {
                throw new zzc("DynamiteLoaderV2 was not cached.", null);
            }
            object = zzaSN.get();
            if (object == null || ((zza)object).zzaSV == null) {
                throw new zzc("No result cursor", null);
            }
            Context context2 = DynamiteModule.zza(context.getApplicationContext(), string2, n, ((zza)object).zzaSV, zzl2);
            if (context2 == null) {
                throw new zzc("Failed to get module context", null);
            }
            return new DynamiteModule(context2);
        }
    }

    private static Context zza(Context context, String string2, int n, Cursor cursor, zzl zzl2) {
        try {
            return (Context)zzn.zzE(zzl2.zza(zzn.zzw(context), string2, n, zzn.zzw(cursor)));
        }
        catch (Exception exception) {
            String string3 = String.valueOf(exception.toString());
            Log.e((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load DynamiteLoader: ".concat(string3) : new String("Failed to load DynamiteLoader: ")));
            return null;
        }
    }

    private static void zza(ClassLoader classLoader) throws zzc {
        try {
            IInterface iInterface;
            IBinder iBinder = (IBinder)classLoader.loadClass("com.google.android.gms.dynamiteloader.DynamiteLoaderV2").getConstructor(new Class[0]).newInstance(new Object[0]);
            zzaSL = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.android.gms.dynamite.IDynamiteLoaderV2")) instanceof zzl ? (zzl)iInterface : new zzm(iBinder));
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new zzc("Failed to instantiate dynamite loader", reflectiveOperationException, null);
        }
    }

    public final IBinder zzcW(String string2) throws zzc {
        try {
            return (IBinder)this.zzaSU.getClassLoader().loadClass(string2).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            String string3 = String.valueOf(string2);
            throw new zzc(string3.length() != 0 ? "Failed to instantiate module class: ".concat(string3) : new String("Failed to instantiate module class: "), reflectiveOperationException, null);
        }
    }

    private DynamiteModule(Context context) {
        this.zzaSU = zzbr.zzu(context);
    }

    static {
        zzaSN = new ThreadLocal();
        zzaSO = new com.google.android.gms.dynamite.zza();
        zzaSP = new com.google.android.gms.dynamite.zzb();
        zzaSQ = new com.google.android.gms.dynamite.zzc();
        zzaSR = new com.google.android.gms.dynamite.zzd();
        zzaSS = new zze();
        zzaST = new zzf();
    }

    @DynamiteApi
    public static class DynamiteLoaderClassLoader {
        public static ClassLoader sClassLoader;
    }

    static final class zza {
        public Cursor zzaSV;

        private zza() {
        }

        /* synthetic */ zza(com.google.android.gms.dynamite.zza zza2) {
            this();
        }
    }

    public static final class zzc
    extends Exception {
        private zzc(String string2) {
            super(string2);
        }

        private zzc(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        /* synthetic */ zzc(String string2, com.google.android.gms.dynamite.zza zza2) {
            this(string2);
        }

        /* synthetic */ zzc(String string2, Throwable throwable, com.google.android.gms.dynamite.zza zza2) {
            this(string2, throwable);
        }
    }

    static final class zzb
    implements zzh {
        private final int zzaSW;
        private final int zzaSX;

        public zzb(int n, int n2) {
            this.zzaSW = n;
            this.zzaSX = 0;
        }

        @Override
        public final int zzb(Context context, String string2, boolean bl) {
            return 0;
        }

        @Override
        public final int zzF(Context context, String string2) {
            return this.zzaSW;
        }
    }

    public static interface zzd {
        public zzi zza(Context var1, String var2, zzh var3) throws zzc;
    }
}

