/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzay;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzy;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int zzaGJ;
    private long zzaGK;
    private long zzaGL;
    private int zzaGM;
    private long zzaGN;
    private zzal zzaGO;
    private final Context mContext;
    private final Looper zzrP;
    private final zzaf zzaGP;
    private final zze zzaCH;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzaGQ = new Object();
    private zzay zzaGR;
    protected zzj zzaGS;
    private T zzaGT;
    private final ArrayList<zzi<?>> zzaGU = new ArrayList();
    private zzl zzaGV;
    private int zzaGW = 1;
    private final zzf zzaGX;
    private final zzg zzaGY;
    private final int zzaGZ;
    private final String zzaHa;
    private ConnectionResult zzaHb = null;
    private boolean zzaHc = false;
    protected AtomicInteger zzaHd = new AtomicInteger(0);
    private static String[] zzaHe = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, zzf zzf2, zzg zzg2, String string2) {
        this(context, looper, zzaf.zzaC(context), zze.zzoU(), n, zzbr.zzu(zzf2), zzbr.zzu(zzg2), null);
    }

    protected zzd(Context context, Looper looper, zzaf zzaf2, zze zze2, int n, zzf zzf2, zzg zzg2, String string2) {
        this.mContext = zzbr.zzb(context, (Object)"Context must not be null");
        this.zzrP = zzbr.zzb(looper, (Object)"Looper must not be null");
        this.zzaGP = zzbr.zzb(zzaf2, (Object)"Supervisor must not be null");
        this.zzaCH = zzbr.zzb(zze2, (Object)"API availability must not be null");
        this.mHandler = new zzh(this, looper);
        this.zzaGZ = n;
        this.zzaGX = zzf2;
        this.zzaGY = zzg2;
        this.zzaHa = string2;
    }

    @NonNull
    protected abstract String zzda();

    protected String zzqX() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzdb();

    @Nullable
    private final String zzqY() {
        if (this.zzaHa == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzaHa;
    }

    @Nullable
    protected abstract T zzd(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzaGL = System.currentTimeMillis();
    }

    @CallSuper
    protected final void onConnectionSuspended(int n) {
        this.zzaGJ = n;
        this.zzaGK = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzaGM = connectionResult.getErrorCode();
        this.zzaGN = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        zzbr.zzaf(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzaGW = n;
            this.zzaGT = t;
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    zzd zzd2 = this;
                    if (zzd2.zzaGV != null && zzd2.zzaGO != null) {
                        String string3 = String.valueOf(zzd2.zzaGO.zzrD());
                        string2 = String.valueOf(zzd2.zzaGO.getPackageName());
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        zzd2.zzaGP.zza(zzd2.zzaGO.zzrD(), zzd2.zzaGO.getPackageName(), zzd2.zzaGV, zzd2.zzqY());
                        zzd2.zzaHd.incrementAndGet();
                    }
                    zzd2.zzaGV = new zzl(zzd2, zzd2.zzaHd.get());
                    zzd zzd3 = zzd2;
                    zzd2.zzaGO = new zzal(zzd3.zzqX(), zzd3.zzda(), false);
                    String string4 = zzd2.zzqY();
                    zzl zzl2 = zzd2.zzaGV;
                    String string5 = zzd2.zzaGO.getPackageName();
                    String string6 = zzd2.zzaGO.zzrD();
                    if (zzd2.zzaGP.zza(new zzag(string6, string5), (ServiceConnection)zzl2, string4)) break;
                    string2 = String.valueOf(zzd2.zzaGO.zzrD());
                    String string7 = String.valueOf(zzd2.zzaGO.getPackageName());
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    zzd2.zza(16, null, zzd2.zzaHd.get());
                    break;
                }
                case 4: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    zzd zzd4 = this;
                    if (zzd4.zzaGV == null) break;
                    zzd4.zzaGP.zza(zzd4.zzda(), zzd4.zzqX(), zzd4.zzaGV, zzd4.zzqY());
                    zzd4.zzaGV = null;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzaGW != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public final void zzqZ() {
        int n = this.zzaCH.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zza(new zzm(this), n, null);
            return;
        }
        this.zza(new zzm(this));
    }

    public void zza(@NonNull zzj zzj2) {
        this.zzaGS = zzbr.zzb(zzj2, (Object)"Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaGW == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaGW == 2 || this.zzaGW == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzra() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaGW == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzaHd.incrementAndGet();
        Object object = this.zzaGU;
        synchronized (object) {
            int n = this.zzaGU.size();
            for (int i = 0; i < n; ++i) {
                this.zzaGU.get(i).removeListener();
            }
            this.zzaGU.clear();
        }
        object = this.zzaGQ;
        synchronized (object) {
            this.zzaGR = null;
        }
        this.zza(1, null);
    }

    public final void zzay(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzaHd.get(), n));
    }

    private final void zzaz(int n) {
        int n2;
        if (this.zzra()) {
            n2 = 5;
            this.zzaHc = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzaHd.get(), 16));
    }

    protected final void zza(@NonNull zzj zzj2, int n, @Nullable PendingIntent pendingIntent) {
        this.zzaGS = zzbr.zzb(zzj2, (Object)"Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzaHd.get(), n, (Object)pendingIntent));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzrP;
    }

    public Account getAccount() {
        return null;
    }

    public zzc[] zzrb() {
        return new zzc[0];
    }

    protected Bundle zzmm() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzn(this, n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzo(this, n, null)));
    }

    protected final void zzrc() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzoA() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzrd() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzaGW == 5) {
                throw new DeadObjectException();
            }
            this.zzrc();
            zzbr.zza(this.zzaGT != null, (Object)"Client is connected but service is null");
            return this.zzaGT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(zzam zzam2, Set<Scope> set) {
        Bundle bundle = this.zzmm();
        Object object = this.mContext.getPackageName();
        Object object2 = new zzy(this.zzaGZ);
        new zzy(this.zzaGZ).zzaHy = object;
        object = bundle;
        v0.zzaHB = object;
        zzy zzy2 = object2;
        if (set != null) {
            object = set;
            zzy2.zzaHA = object.toArray(new Scope[object.size()]);
        }
        if (this.zzmt()) {
            object2 = this;
            object = ((zzd)object2).getAccount() != null ? ((zzd)object2).getAccount() : new Account("<<default account>>", "com.google");
            object2 = zzy2;
            zzy2.zzaHC = object;
            object = zzam2;
            if (object != null) {
                ((zzy)object2).zzaHz = object.asBinder();
            }
        } else if (this.zzre()) {
            zzy2.zzaHC = object = this.getAccount();
        }
        object = this.zzrb();
        zzy2.zzaHD = object;
        try {
            Object object3 = this.zzaGQ;
            synchronized (object3) {
                if (this.zzaGR != null) {
                    this.zzaGR.zza(new zzk(this, this.zzaHd.get()), zzy2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.zzay(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.zza(8, null, null, this.zzaHd.get());
            return;
        }
    }

    public boolean zzmt() {
        return false;
    }

    public boolean zzre() {
        return false;
    }

    public boolean zzpc() {
        return true;
    }

    public boolean zzmE() {
        return false;
    }

    public Intent zzmF() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzrf() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        zzay zzay2;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzaGW;
            t = this.zzaGT;
        }
        object = this.zzaGQ;
        synchronized (object) {
            zzay2 = this.zzaGR;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.zzdb()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (zzay2 == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(zzay2.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzaGL > 0L) {
            l = this.zzaGL;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaGL)));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzaGK > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzaGJ) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzaGJ));
                }
            }
            l = this.zzaGK;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaGK)));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzaGN > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzaGM));
            l = this.zzaGN;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaGN)));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    private final boolean zzrg() {
        if (this.zzaHc) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzdb())) {
            return false;
        }
        if (TextUtils.isEmpty(null)) {
            return false;
        }
        try {
            Class.forName(this.zzdb());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ void zza(zzd zzd2, int n) {
        zzd2.zzaz(16);
    }

    static /* synthetic */ Object zza(zzd zzd2) {
        return zzd2.zzaGQ;
    }

    static /* synthetic */ zzay zza(zzd zzd2, zzay zzay2) {
        zzd2.zzaGR = zzay2;
        return zzd2.zzaGR;
    }

    static /* synthetic */ ConnectionResult zza(zzd zzd2, ConnectionResult connectionResult) {
        zzd2.zzaHb = connectionResult;
        return zzd2.zzaHb;
    }

    static /* synthetic */ boolean zzb(zzd zzd2) {
        return zzd2.zzrg();
    }

    static /* synthetic */ boolean zzc(zzd zzd2) {
        return zzd2.zzaHc;
    }

    static /* synthetic */ void zza(zzd zzd2, int n, IInterface iInterface) {
        zzd2.zza(n, null);
    }

    static /* synthetic */ ConnectionResult zzd(zzd zzd2) {
        return zzd2.zzaHb;
    }

    static /* synthetic */ zzf zze(zzd zzd2) {
        return zzd2.zzaGX;
    }

    static /* synthetic */ boolean zza(zzd zzd2, int n, int n2, IInterface iInterface) {
        return zzd2.zza(n, n2, iInterface);
    }

    static /* synthetic */ ArrayList zzf(zzd zzd2) {
        return zzd2.zzaGU;
    }

    static /* synthetic */ zzg zzg(zzd zzd2) {
        return zzd2.zzaGY;
    }
}

