/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.WorkSource;
import android.util.Log;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.common.util.zzw;
import com.google.android.gms.internal.zzadg;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class zzz {
    private static final Method zzaIq = zzz.zzzs();
    private static final Method zzaIr = zzz.zzzt();
    private static final Method zzaIs = zzz.zzzu();
    private static final Method zzaIt = zzz.zzzv();
    private static final Method zzaIu = zzz.zzzw();

    public static WorkSource zzf(int n, String string2) {
        WorkSource workSource = new WorkSource();
        zzz.zza(workSource, n, string2);
        return workSource;
    }

    public static WorkSource zzF(Context context, String string2) {
        ApplicationInfo applicationInfo;
        if (context == null || context.getPackageManager() == null) {
            return null;
        }
        try {
            applicationInfo = zzadg.zzbi(context).getApplicationInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            Log.e((String)"WorkSourceUtil", (String)(string3.length() != 0 ? "Could not find package: ".concat(string3) : new String("Could not find package: ")));
            return null;
        }
        if (applicationInfo == null) {
            String string4 = String.valueOf(string2);
            Log.e((String)"WorkSourceUtil", (String)(string4.length() != 0 ? "Could not get applicationInfo from package: ".concat(string4) : new String("Could not get applicationInfo from package: ")));
            return null;
        }
        return zzz.zzf(applicationInfo.uid, string2);
    }

    public static void zza(WorkSource workSource, int n, String string2) {
        if (zzaIr != null) {
            if (string2 == null) {
                string2 = "";
            }
            try {
                zzaIr.invoke((Object)workSource, n, string2);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
            return;
        }
        if (zzaIq != null) {
            try {
                zzaIq.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
    }

    public static int zza(WorkSource workSource) {
        if (zzaIs != null) {
            try {
                return (Integer)zzaIs.invoke((Object)workSource, new Object[0]);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }

    public static String zza(WorkSource workSource, int n) {
        if (zzaIu != null) {
            try {
                return (String)zzaIu.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return null;
    }

    public static List<String> zzb(WorkSource workSource) {
        int n;
        int n2 = n = workSource == null ? 0 : zzz.zza(workSource);
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string2 = zzz.zza(workSource, i);
            if (zzw.zzdz(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean zzbf(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        int n = zzadg.zzbi(context).checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName());
        return n == 0;
    }

    private static Method zzzs() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("add", Integer.TYPE);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzzt() {
        Method method = null;
        if (zzt.zzzk()) {
            try {
                method = WorkSource.class.getMethod("add", Integer.TYPE, String.class);
            }
            catch (Exception exception) {}
        }
        return method;
    }

    private static Method zzzu() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("size", new Class[0]);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzzv() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("get", Integer.TYPE);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzzw() {
        Method method = null;
        if (zzt.zzzk()) {
            try {
                method = WorkSource.class.getMethod("getName", Integer.TYPE);
            }
            catch (Exception exception) {}
        }
        return method;
    }
}

