/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.internal.zzqk;
import com.google.android.gms.internal.zzql;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzrh;
import com.google.android.gms.internal.zzri;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.internal.zzrs;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.internal.zzsh;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public abstract class zzc<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> vS;
    private final O xw;
    private final zzql<O> xx;
    private final Looper zzajy;
    private final int mId;
    private final zzrh xy;
    private final GoogleApiClient xz;
    private final zzsb xA;
    private final Api.zze xB;
    private final zzqr xC;

    protected zzc(@NonNull Context context, Api<O> api, Looper looper, Api.zze zze2, zzqr zzqr2) {
        zzaa.zzb((Object)context, (Object)"Null context is not permitted.");
        zzaa.zzb(api, (Object)"Api must not be null.");
        zzaa.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.vS = api;
        this.xw = null;
        this.zzajy = looper;
        this.xx = zzql.zzb(api);
        this.xz = new zzri(this);
        this.xy = zzrh.zzbx(this.mContext);
        this.mId = this.xy.zzath();
        this.xA = new zzqk();
        this.xB = zze2;
        this.xC = zzqr2;
        this.xy.zza(this);
    }

    @MainThread
    public zzc(@NonNull Activity activity, Api<O> api, O o, Looper looper, zzsb zzsb2) {
        zzaa.zzb((Object)activity, (Object)"Null activity is not permitted.");
        zzaa.zzb(api, (Object)"Api must not be null.");
        zzaa.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = activity.getApplicationContext();
        this.vS = api;
        this.xw = o;
        this.zzajy = looper;
        this.xx = zzql.zza(this.vS, this.xw);
        this.xz = new zzri(this);
        this.xy = zzrh.zzbx(this.mContext);
        this.mId = this.xy.zzath();
        this.xA = zzsb2;
        this.xB = null;
        this.xC = null;
        zzqw.zza(activity, this.xy, this.xx);
        this.xy.zza(this);
    }

    public zzc(@NonNull Context context, Api<O> api, O o, Looper looper, zzsb zzsb2) {
        zzaa.zzb((Object)context, (Object)"Null context is not permitted.");
        zzaa.zzb(api, (Object)"Api must not be null.");
        zzaa.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.vS = api;
        this.xw = o;
        this.zzajy = looper;
        this.xx = zzql.zza(this.vS, this.xw);
        this.xz = new zzri(this);
        this.xy = zzrh.zzbx(this.mContext);
        this.mId = this.xy.zzath();
        this.xA = zzsb2;
        this.xB = null;
        this.xC = null;
        this.xy.zza(this);
    }

    public zzc(@NonNull Activity activity, Api<O> api, O o, zzsb zzsb2) {
        this(activity, api, o, activity.getMainLooper(), zzsb2);
    }

    public zzc(@NonNull Context context, Api<O> api, O o, zzsb zzsb2) {
        this(context, api, o, Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper(), zzsb2);
    }

    private <A extends Api.zzb, T extends zzqo.zza<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzarv();
        this.xy.zza(this, n, t);
        return t;
    }

    private <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzse<A, TResult> zzse2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.xy.zza(this, n, zzse2, taskCompletionSource, this.xA);
        return taskCompletionSource.getTask();
    }

    public <A extends Api.zzb, T extends zzqo.zza<? extends Result, A>> T doRead(@NonNull T t) {
        return this.zza(0, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> doRead(zzse<A, TResult> zzse2) {
        return this.zza(0, zzse2);
    }

    public <A extends Api.zzb, T extends zzqo.zza<? extends Result, A>> T doWrite(@NonNull T t) {
        return this.zza(1, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> doWrite(zzse<A, TResult> zzse2) {
        return this.zza(1, zzse2);
    }

    public <A extends Api.zzb, T extends zzqo.zza<? extends Result, A>> T doBestEffortWrite(@NonNull T t) {
        return this.zza(2, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> doBestEffortWrite(zzse<A, TResult> zzse2) {
        return this.zza(2, zzse2);
    }

    public <A extends Api.zzb, T extends zzrw<A>, U extends zzsh<A>> Task<Void> doRegisterEventListener(@NonNull T t, U u) {
        zzaa.zzy(t);
        zzaa.zzy(u);
        zzaa.zzb(t.zzatz(), (Object)"Listener has already been released.");
        zzaa.zzb(u.zzatz(), (Object)"Listener has already been released.");
        zzaa.zzb((boolean)t.zzatz().equals(u.zzatz()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.xy.zza(this, t, u);
    }

    public Task<Void> doUnregisterEventListener(@NonNull zzrr.zzb<?> zzb2) {
        zzaa.zzb(zzb2, (Object)"Listener key cannot be null.");
        return this.xy.zza(this, zzb2);
    }

    public <L> zzrr<L> registerListener(@NonNull L l, String string) {
        return zzrs.zzb(l, this.zzajy, string);
    }

    @WorkerThread
    public Api.zze buildApiClient(Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzaa.zza((this.xB == null ? 1 : 0) != 0, (Object)"Client is already built, use getClient(). getClientCallbacks() should also be provided with a helper.");
        if (this.vS.zzaqw()) {
            Api.zzh<?, O> zzh2 = this.vS.zzaqu();
            return new zzag(this.mContext, looper, zzh2.zzaqz(), connectionCallbacks, onConnectionFailedListener, zzf.zzca(this.mContext), zzh2.zzr(this.xw));
        }
        return this.vS.zzaqt().zza(this.mContext, looper, zzf.zzca(this.mContext), this.xw, connectionCallbacks, onConnectionFailedListener);
    }

    public boolean isConnectionlessGoogleApiClient() {
        return this.xB != null && this.xC != null;
    }

    public Api.zze getClient() {
        return (Api.zze)zzaa.zzb((Object)this.xB, (Object)"Client is null, buildApiClient() should be used.");
    }

    public zzqr getClientCallbacks() {
        return (zzqr)zzaa.zzb((Object)this.xC, (Object)"ClientCallbacks is null.");
    }

    public Api<O> getApi() {
        return this.vS;
    }

    public O getApiOptions() {
        return this.xw;
    }

    public zzql<O> getApiKey() {
        return this.xx;
    }

    public int getInstanceId() {
        return this.mId;
    }

    public GoogleApiClient asGoogleApiClient() {
        return this.xz;
    }

    public Looper getLooper() {
        return this.zzajy;
    }

    public Context getApplicationContext() {
        return this.mContext;
    }
}

