/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.internal.zzpp;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzpu;
import com.google.android.gms.internal.zzpv;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzqs;
import com.google.android.gms.internal.zzqt;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.internal.zzqz;
import com.google.android.gms.internal.zzrc;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzrj;
import com.google.android.gms.internal.zzvx;
import com.google.android.gms.internal.zzvy;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzqd
extends GoogleApiClient
implements zzqm.zza {
    private final Lock th;
    private final zzl tQ;
    private zzqm tR = null;
    private final int rV;
    private final Context mContext;
    private final Looper zzahv;
    final Queue<zzpr.zza<?, ?>> tS = new LinkedList();
    private volatile boolean tT;
    private long tU = 120000L;
    private long tV = 5000L;
    private final zza tW;
    private final GoogleApiAvailability rX;
    zzqj tX;
    final Map<Api.zzc<?>, Api.zze> tY;
    Set<Scope> tZ = new HashSet<Scope>();
    final zzg tD;
    final Map<Api<?>, Integer> tE;
    final Api.zza<? extends zzvx, zzvy> rY;
    private final zzqt ua = new zzqt();
    private final ArrayList<zzpu> ub;
    private Integer uc = null;
    Set<zzrc> ud = null;
    final zzrd ue;
    private final zzl.zza uf = new zzl.zza(){

        @Override
        public boolean isConnected() {
            return zzqd.this.isConnected();
        }

        @Override
        public Bundle zzamc() {
            return null;
        }
    };

    public zzqd(Context context, Lock lock, Looper looper, zzg zzg2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzvx, zzvy> zza2, Map<Api<?>, Integer> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzpu> arrayList) {
        this.mContext = context;
        this.th = lock;
        this.tQ = new zzl(looper, this.uf);
        this.zzahv = looper;
        this.tW = new zza(looper);
        this.rX = googleApiAvailability;
        this.rV = n;
        if (this.rV >= 0) {
            this.uc = n2;
        }
        this.tE = map;
        this.tY = map2;
        this.ub = arrayList;
        this.ue = new zzrd(this.tY);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.tQ.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.tQ.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.tD = zzg2;
        this.rY = zza2;
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzpr.zza<R, A>> T zzc(@NonNull T t) {
        zzab.zzb((t.zzanp() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzanw() != null ? t.zzanw().getName() : "the API";
        zzab.zzb((boolean)this.tY.containsKey(t.zzanp()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.th.lock();
        try {
            if (this.tR == null) {
                this.tS.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.tR.zzc(t);
            return (T)string2;
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    public <A extends Api.zzb, T extends zzpr.zza<? extends Result, A>> T zzd(@NonNull T t) {
        zzab.zzb((t.zzanp() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzanw() != null ? t.zzanw().getName() : "the API";
        zzab.zzb((boolean)this.tY.containsKey(t.zzanp()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.th.lock();
        try {
            if (this.tR == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.isResuming()) {
                this.tS.add(t);
                while (!this.tS.isEmpty()) {
                    object = this.tS.remove();
                    this.ue.zzg(object);
                    ((zzpr.zza)object).zzz(Status.si);
                }
                object = t;
                return (T)object;
            }
            object = this.tR.zzd(t);
            return (T)object;
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    public <L> zzqs<L> zzt(@NonNull L l) {
        this.th.lock();
        try {
            zzqs<L> zzqs2 = this.ua.zzb(l, this.zzahv);
            return zzqs2;
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.tY.get(zzc2);
        zzab.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    <C extends Api.zze> C zzb(Api.zzc<?> zzc2) {
        Api.zze zze2 = this.tY.get(zzc2);
        zzab.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public boolean zza(@NonNull Api<?> api) {
        return this.tY.containsKey(api.zzanp());
    }

    @Override
    public boolean hasConnectedApi(@NonNull Api<?> api) {
        Api.zze zze2 = this.tY.get(api.zzanp());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        this.th.lock();
        try {
            if (!this.isConnected() && !this.isResuming()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.tY.containsKey(api.zzanp())) {
                ConnectionResult connectionResult = this.tR.getConnectionResult(api);
                if (connectionResult == null) {
                    if (this.isResuming()) {
                        ConnectionResult connectionResult2 = ConnectionResult.qR;
                        return connectionResult2;
                    }
                    Log.i((String)"GoogleApiClientImpl", (String)this.zzapv());
                    Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                    ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                    return connectionResult3;
                }
                ConnectionResult connectionResult4 = connectionResult;
                return connectionResult4;
            }
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    public void connect() {
        this.th.lock();
        try {
            if (this.rV >= 0) {
                zzab.zza((this.uc != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.uc == null) {
                this.uc = zzqd.zza(this.tY.values(), false);
            } else if (this.uc == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.uc);
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    public void connect(int n) {
        this.th.lock();
        try {
            zzab.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzfi(n);
            this.zzapq();
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    public ConnectionResult blockingConnect() {
        zzab.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.th.lock();
        try {
            if (this.rV >= 0) {
                zzab.zza((this.uc != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.uc == null) {
                this.uc = zzqd.zza(this.tY.values(), false);
            } else if (this.uc == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzfi(this.uc);
            this.tQ.zzast();
            ConnectionResult connectionResult = this.tR.blockingConnect();
            return connectionResult;
        }
        finally {
            this.th.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzab.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzab.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.th.lock();
        try {
            if (this.uc == null) {
                this.uc = zzqd.zza(this.tY.values(), false);
            } else if (this.uc == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzfi(this.uc);
            this.tQ.zzast();
            ConnectionResult connectionResult = this.tR.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.th.lock();
        try {
            this.ue.release();
            if (this.tR != null) {
                this.tR.disconnect();
            }
            this.ua.release();
            for (zzpr.zza zza2 : this.tS) {
                zza2.zza((zzrd.zzb)null);
                zza2.cancel();
            }
            this.tS.clear();
            if (this.tR == null) {
                return;
            }
            this.zzapt();
            this.tQ.zzass();
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzab.zza((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzab.zza((this.uc != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        final zzqz zzqz2 = new zzqz(this);
        if (this.tY.containsKey(zzrj.bN)) {
            this.zza(this, zzqz2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle bundle) {
                    zzqd.this.zza((GoogleApiClient)atomicReference.get(), zzqz2, true);
                }

                @Override
                public void onConnectionSuspended(int n) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
                    zzqz2.zzc(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzrj.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.tW).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzqz2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzqz zzqz2, final boolean bl) {
        zzrj.zh.zzg(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzp(@NonNull Status status) {
                zzk.zzbc(zzqd.this.mContext).zzagl();
                if (status.isSuccess() && zzqd.this.isConnected()) {
                    zzqd.this.reconnect();
                }
                zzqz2.zzc(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        this.zzb(new zzqn((Activity)fragmentActivity));
    }

    private void zzb(@NonNull zzqn zzqn2) {
        if (this.rV < 0) {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
        zzpp.zza(zzqn2).zzff(this.rV);
    }

    @Override
    public boolean isConnected() {
        return this.tR != null && this.tR.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.tR != null && this.tR.isConnecting();
    }

    boolean isResuming() {
        return this.tT;
    }

    private void zzfi(int n) {
        if (this.uc == null) {
            this.uc = n;
        } else if (this.uc != n) {
            String string2 = String.valueOf(zzqd.zzfj(n));
            String string3 = String.valueOf(zzqd.zzfj(this.uc));
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.tR != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.tY.values()) {
            if (zze2.zzafk()) {
                bl = true;
            }
            if (!zze2.zzafz()) continue;
            bl2 = true;
        }
        switch (this.uc) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                this.tR = zzpv.zza(this.mContext, this, this.th, this.zzahv, this.rX, this.tY, this.tD, this.tE, this.rY, this.ub);
                return;
            }
        }
        this.tR = new zzqf(this.mContext, this, this.th, this.zzahv, this.rX, this.tY, this.tD, this.tE, this.rY, this.ub, this);
    }

    private void zzapq() {
        this.tQ.zzast();
        this.tR.connect();
    }

    private void resume() {
        this.th.lock();
        try {
            if (this.isResuming()) {
                this.zzapq();
            }
        }
        finally {
            this.th.unlock();
        }
    }

    private void zzapr() {
        this.th.lock();
        try {
            boolean bl = this.zzapt();
            if (bl) {
                this.zzapq();
            }
        }
        finally {
            this.th.unlock();
        }
    }

    void zzaps() {
        if (this.isResuming()) {
            return;
        }
        this.tT = true;
        if (this.tX == null) {
            this.tX = this.rX.zza(this.mContext.getApplicationContext(), new zzb(this));
        }
        this.tW.sendMessageDelayed(this.tW.obtainMessage(1), this.tU);
        this.tW.sendMessageDelayed(this.tW.obtainMessage(2), this.tV);
    }

    boolean zzapt() {
        if (!this.isResuming()) {
            return false;
        }
        this.tT = false;
        this.tW.removeMessages(2);
        this.tW.removeMessages(1);
        if (this.tX != null) {
            this.tX.unregister();
            this.tX = null;
        }
        return true;
    }

    @Override
    public void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.tQ.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.tQ.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.tQ.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.tQ.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.tQ.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.tQ.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public void zzm(Bundle bundle) {
        while (!this.tS.isEmpty()) {
            this.zzd(this.tS.remove());
        }
        this.tQ.zzo(bundle);
    }

    @Override
    public void zzd(ConnectionResult connectionResult) {
        if (!this.rX.zzc(this.mContext, connectionResult.getErrorCode())) {
            this.zzapt();
        }
        if (!this.isResuming()) {
            this.tQ.zzm(connectionResult);
            this.tQ.zzass();
        }
    }

    @Override
    public void zzc(int n, boolean bl) {
        if (n == 1 && !bl) {
            this.zzaps();
        }
        this.ue.zzaqv();
        this.tQ.zzgb(n);
        this.tQ.zzass();
        if (n == 2) {
            this.zzapq();
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzahv;
    }

    @Override
    public boolean zza(zzqy zzqy2) {
        return this.tR != null && this.tR.zza(zzqy2);
    }

    @Override
    public void zzaoc() {
        if (this.tR != null) {
            this.tR.zzaoc();
        }
    }

    @Override
    public void zza(zzrc zzrc2) {
        this.th.lock();
        try {
            if (this.ud == null) {
                this.ud = new HashSet<zzrc>();
            }
            this.ud.add(zzrc2);
        }
        finally {
            this.th.unlock();
        }
    }

    @Override
    public void zzb(zzrc zzrc2) {
        this.th.lock();
        try {
            if (this.ud == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.ud.remove(zzrc2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzapu()) {
                this.tR.zzaoy();
            }
        }
        finally {
            this.th.unlock();
        }
    }

    boolean zzapu() {
        this.th.lock();
        try {
            if (this.ud == null) {
                boolean bl = false;
                return false;
            }
            boolean bl = !this.ud.isEmpty();
            return bl;
        }
        finally {
            this.th.unlock();
        }
    }

    String zzapv() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.tT);
        printWriter.append(" mWorkQueue.size()=").print(this.tS.size());
        this.ue.dump(printWriter);
        if (this.tR != null) {
            this.tR.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public int getSessionId() {
        return System.identityHashCode(this);
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzafk()) {
                bl2 = true;
            }
            if (!zze2.zzafz()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zzfj(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zzqd.this.zzapr();
                    break;
                }
                case 2: {
                    zzqd.this.resume();
                    break;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiClientImpl", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }

    static class zzb
    extends zzqj.zza {
        private WeakReference<zzqd> uk;

        zzb(zzqd zzqd2) {
            this.uk = new WeakReference<zzqd>(zzqd2);
        }

        @Override
        public void zzaor() {
            zzqd zzqd2 = (zzqd)this.uk.get();
            if (zzqd2 == null) {
                return;
            }
            zzqd2.resume();
        }
    }
}

