/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzab;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzl
implements Handler.Callback {
    private final zza ys;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> yt = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> yu = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> yv = new ArrayList();
    private volatile boolean yw = false;
    private final AtomicInteger yx = new AtomicInteger(0);
    private boolean yy = false;
    private final Handler mHandler;
    private final Object zzail = new Object();

    public zzl(Looper looper, zza zza2) {
        this.ys = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zzass() {
        this.yw = false;
        this.yx.incrementAndGet();
    }

    public void zzast() {
        this.yw = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzo(Bundle bundle) {
        zzab.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zzail;
        synchronized (object) {
            zzab.zzbm((!this.yy ? 1 : 0) != 0);
            this.mHandler.removeMessages(1);
            this.yy = true;
            zzab.zzbm((this.yu.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.yt);
            int n = this.yx.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.yw || !this.ys.isConnected() || this.yx.get() != n) break;
                if (this.yu.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.yu.clear();
            this.yy = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzgb(int n) {
        zzab.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzail;
        synchronized (object) {
            this.yy = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.yt);
            int n2 = this.yx.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.yw || this.yx.get() != n2) break;
                if (!this.yt.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.yu.clear();
            this.yy = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzm(ConnectionResult connectionResult) {
        zzab.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzail;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.yv);
            int n = this.yx.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.yw || this.yx.get() != n) {
                    return;
                }
                if (!this.yv.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzab.zzaa((Object)connectionCallbacks);
        Object object = this.zzail;
        synchronized (object) {
            if (this.yt.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.yt.add(connectionCallbacks);
            }
        }
        if (this.ys.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzab.zzaa((Object)connectionCallbacks);
        Object object = this.zzail;
        synchronized (object) {
            return this.yt.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzab.zzaa((Object)connectionCallbacks);
        Object object = this.zzail;
        synchronized (object) {
            boolean bl = this.yt.remove(connectionCallbacks);
            if (!bl) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.yy) {
                this.yu.add(connectionCallbacks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzab.zzaa((Object)onConnectionFailedListener);
        Object object = this.zzail;
        synchronized (object) {
            if (this.yv.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.yv.add(onConnectionFailedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzab.zzaa((Object)onConnectionFailedListener);
        Object object = this.zzail;
        synchronized (object) {
            return this.yv.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzab.zzaa((Object)onConnectionFailedListener);
        Object object = this.zzail;
        synchronized (object) {
            boolean bl = this.yv.remove(onConnectionFailedListener);
            if (!bl) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.zzail;
            synchronized (object) {
                if (this.yw && this.ys.isConnected() && this.yt.contains(connectionCallbacks)) {
                    Bundle bundle = this.ys.zzamc();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzamc();
    }
}

