/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.zze;

public final class GooglePlayServicesUtil
extends zze {
    public static final String GMS_ERROR_DIALOG = "GooglePlayServicesErrorDialog";
    @Deprecated
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zze.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @Deprecated
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";

    private GooglePlayServicesUtil() {
    }

    @Deprecated
    public static Dialog getErrorDialog(int n, Activity activity, int n2) {
        return GooglePlayServicesUtil.getErrorDialog(n, activity, n2, null);
    }

    @Deprecated
    public static Dialog getErrorDialog(int n, Activity activity, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = GoogleApiAvailability.getInstance().zza((Context)activity, n, "d");
        return GooglePlayServicesUtil.zza(n, activity, com.google.android.gms.common.internal.zzi.zza(activity, intent, n2), onCancelListener);
    }

    @TargetApi(value=14)
    public static Dialog zza(int n, Activity activity, com.google.android.gms.common.internal.zzi zzi2, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        String string3;
        Object object;
        if (n == 0) {
            return null;
        }
        if (zzi.zzaB((Context)activity) && n == 2) {
            n = 42;
        }
        if (GooglePlayServicesUtil.zzc((Context)activity, n)) {
            n = 18;
        }
        AlertDialog.Builder builder = null;
        if (zzs.zzva()) {
            object = new TypedValue();
            activity.getTheme().resolveAttribute(16843529, object, true);
            string3 = activity.getResources().getResourceEntryName(object.resourceId);
            if ("Theme.Dialog.Alert".equals(string3)) {
                builder = new AlertDialog.Builder((Context)activity, 5);
            }
        }
        if (builder == null) {
            builder = new AlertDialog.Builder((Context)activity);
        }
        object = GooglePlayServicesUtil.zzam((Context)activity);
        builder.setMessage((CharSequence)zzh.zzb((Context)activity, n, (String)object));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        if ((string3 = zzh.zzh((Context)activity, n)) != null) {
            builder.setPositiveButton((CharSequence)string3, (DialogInterface.OnClickListener)zzi2);
        }
        if ((string2 = zzh.zzf((Context)activity, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    @Deprecated
    public static boolean showErrorDialogFragment(int n, Activity activity, int n2, DialogInterface.OnCancelListener onCancelListener) {
        return GooglePlayServicesUtil.showErrorDialogFragment(n, activity, null, n2, onCancelListener);
    }

    public static boolean showErrorDialogFragment(int n, Activity activity, Fragment fragment, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = GoogleApiAvailability.getInstance().zza((Context)activity, n, "d");
        com.google.android.gms.common.internal.zzi zzi2 = fragment == null ? com.google.android.gms.common.internal.zzi.zza(activity, intent, n2) : com.google.android.gms.common.internal.zzi.zza(fragment, intent, n2);
        Dialog dialog = GooglePlayServicesUtil.zza(n, activity, zzi2, onCancelListener);
        if (dialog == null) {
            return false;
        }
        GooglePlayServicesUtil.zza(activity, onCancelListener, GMS_ERROR_DIALOG, dialog);
        return true;
    }

    @TargetApi(value=11)
    public static void zza(Activity activity, DialogInterface.OnCancelListener onCancelListener, String string2, @NonNull Dialog dialog) {
        boolean bl;
        try {
            bl = activity instanceof FragmentActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
        }
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment supportErrorDialogFragment = SupportErrorDialogFragment.newInstance(dialog, onCancelListener);
            supportErrorDialogFragment.show(fragmentManager, string2);
        } else if (zzs.zzuX()) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            ErrorDialogFragment errorDialogFragment = ErrorDialogFragment.newInstance(dialog, onCancelListener);
            errorDialogFragment.show(fragmentManager, string2);
        } else {
            throw new RuntimeException("This Activity does not support Fragments.");
        }
    }

    @Deprecated
    public static void showErrorNotification(int n, Context context) {
        if (zzi.zzaB((Context)context) && n == 2) {
            n = 42;
        }
        if (GooglePlayServicesUtil.zzc(context, n) || GooglePlayServicesUtil.zzd(context, n)) {
            GooglePlayServicesUtil.zzai(context);
        } else {
            GooglePlayServicesUtil.zza(n, context);
        }
    }

    static void zza(int n, Context context, PendingIntent pendingIntent) {
        GooglePlayServicesUtil.zza(n, context, null, pendingIntent);
    }

    private static void zzai(Context context) {
        zza zza2 = new zza(context);
        zza2.sendMessageDelayed(zza2.obtainMessage(1), 120000L);
    }

    private static void zza(int n, Context context) {
        GooglePlayServicesUtil.zza(n, context, null);
    }

    private static void zza(int n, Context context, String string2) {
        PendingIntent pendingIntent = GoogleApiAvailability.getInstance().zza(context, n, 0, "n");
        GooglePlayServicesUtil.zza(n, context, string2, pendingIntent);
    }

    @TargetApi(value=20)
    private static void zza(int n, Context context, String string2, PendingIntent pendingIntent) {
        int n2;
        Notification notification;
        String string3;
        String string4;
        Resources resources = context.getResources();
        String string5 = GooglePlayServicesUtil.zzam((Context)context);
        String string6 = zzh.zzg(context, n);
        if (string6 == null) {
            string6 = resources.getString(R.string.common_google_play_services_notification_ticker);
        }
        String string7 = zzh.zzc(context, n, string5);
        if (zzi.zzaB((Context)context)) {
            zzaa.zzai((boolean)zzs.zzvb());
            string4 = string6;
            string3 = new Notification.Builder(context).setSmallIcon(R.drawable.common_ic_googleplayservices).setPriority(2).setAutoCancel(true).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string7).length()).append(string4).append(" ").append(string7).toString())).addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            notification = string3.build();
        } else {
            string3 = resources.getString(R.string.common_google_play_services_notification_ticker);
            if (zzs.zzuX()) {
                string4 = new Notification.Builder(context).setSmallIcon(17301642).setContentTitle((CharSequence)string6).setContentText((CharSequence)string7).setContentIntent(pendingIntent).setTicker((CharSequence)string3).setAutoCancel(true);
                if (zzs.zzvf()) {
                    string4.setLocalOnly(true);
                }
                if (zzs.zzvb()) {
                    string4.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)string7));
                    notification = string4.build();
                } else {
                    notification = string4.getNotification();
                }
                if (Build.VERSION.SDK_INT == 19) {
                    notification.extras.putBoolean("android.support.localOnly", true);
                }
            } else {
                string4 = new NotificationCompat.Builder(context).setSmallIcon(17301642).setTicker((CharSequence)string3).setWhen(System.currentTimeMillis()).setAutoCancel(true).setContentIntent(pendingIntent).setContentTitle((CharSequence)string6).setContentText((CharSequence)string7);
                notification = string4.build();
            }
        }
        if (GooglePlayServicesUtil.zzbD((int)n)) {
            n2 = 10436;
            zzakA.set(false);
        } else {
            n2 = 39789;
        }
        string4 = (NotificationManager)context.getSystemService("notification");
        if (string2 != null) {
            string4.notify(string2, n2, notification);
        } else {
            string4.notify(n2, notification);
        }
    }

    @Deprecated
    public static boolean showErrorDialogFragment(int n, Activity activity, int n2) {
        return GooglePlayServicesUtil.showErrorDialogFragment(n, activity, n2, null);
    }

    @Deprecated
    public static String getErrorString(int n) {
        return zze.getErrorString((int)n);
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context) {
        return zze.isGooglePlayServicesAvailable((Context)context);
    }

    @Deprecated
    public static Intent zzbC(int n) {
        return zze.zzbC((int)n);
    }

    @Deprecated
    public static PendingIntent getErrorPendingIntent(int n, Context context, int n2) {
        return zze.getErrorPendingIntent((int)n, (Context)context, (int)n2);
    }

    @Deprecated
    public static boolean isUserRecoverableError(int n) {
        return zze.isUserRecoverableError((int)n);
    }

    @Deprecated
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        return zze.getOpenSourceSoftwareLicenseInfo((Context)context);
    }

    public static Resources getRemoteResource(Context context) {
        return zze.getRemoteResource((Context)context);
    }

    public static Context getRemoteContext(Context context) {
        return zze.getRemoteContext((Context)context);
    }

    @Deprecated
    public static boolean zzc(Context context, int n) {
        return zze.zzc((Context)context, (int)n);
    }

    @Deprecated
    public static boolean zzd(Context context, int n) {
        return zze.zzd((Context)context, (int)n);
    }

    private static class zza
    extends Handler {
        private final Context zztm;

        zza(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.zztm = context.getApplicationContext();
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.zztm);
                    if (!GooglePlayServicesUtil.isUserRecoverableError(n)) break;
                    GooglePlayServicesUtil.zza(n, this.zztm);
                    break;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GooglePlayServicesUtil", (String)new StringBuilder(50).append("Don't know how to handle this message: ").append(n).toString());
                }
            }
        }
    }
}

