/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzoc;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzoe;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzpa;
import com.google.android.gms.internal.zztv;
import com.google.android.gms.internal.zztw;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzoh
implements zzoo {
    private final Lock zzamw;
    private final Condition zzanA;
    private final Context mContext;
    private final zzc zzamE;
    private final zzb zzanB;
    final Map<Api.zzc<?>, Api.zze> zzann;
    final Map<Api.zzc<?>, ConnectionResult> zzanC = new HashMap();
    final zzg zzamS;
    final Map<Api<?>, Integer> zzamT;
    final Api.zza<? extends zztv, zztw> zzalo;
    private volatile zzog zzanD;
    private ConnectionResult zzanE = null;
    int zzanF;
    final zzof zzamm;
    final zzoo.zza zzanG;

    public zzoh(Context context, zzof zzof2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Integer> map2, Api.zza<? extends zztv, zztw> zza2, ArrayList<zznw> arrayList, zzoo.zza zza3) {
        this.mContext = context;
        this.zzamw = lock;
        this.zzamE = zzc2;
        this.zzann = map;
        this.zzamS = zzg2;
        this.zzamT = map2;
        this.zzalo = zza2;
        this.zzamm = zzof2;
        this.zzanG = zza3;
        for (zznw zznw2 : arrayList) {
            zznw2.zza(this);
        }
        this.zzanB = new zzb(looper);
        this.zzanA = lock.newCondition();
        this.zzanD = new zzoe(this);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zznt.zza<R, A>> T zzc(@NonNull T t) {
        t.zzrI();
        return this.zzanD.zzc(t);
    }

    @Override
    public <A extends Api.zzb, T extends zznt.zza<? extends Result, A>> T zzd(@NonNull T t) {
        t.zzrI();
        return this.zzanD.zzd(t);
    }

    @Override
    public void connect() {
        this.zzanD.connect();
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzanA.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzakj;
        }
        if (this.zzanE != null) {
            return this.zzanE;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzanA.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzakj;
        }
        if (this.zzanE != null) {
            return this.zzanE;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        boolean bl = this.zzanD.disconnect();
        if (bl) {
            this.zzanC.clear();
        }
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzre();
        if (this.zzann.containsKey(zzc2)) {
            if (this.zzann.get(zzc2).isConnected()) {
                return ConnectionResult.zzakj;
            }
            if (this.zzanC.containsKey(zzc2)) {
                return this.zzanC.get(zzc2);
            }
        }
        return null;
    }

    void zzsm() {
        this.zzamw.lock();
        try {
            this.zzanD = new zzod(this, this.zzamS, this.zzamT, this.zzamE, this.zzalo, this.zzamw, this.mContext);
            this.zzanD.begin();
            this.zzanA.signalAll();
        }
        finally {
            this.zzamw.unlock();
        }
    }

    void zzsn() {
        this.zzamw.lock();
        try {
            this.zzamm.zzsj();
            this.zzanD = new zzoc(this);
            this.zzanD.begin();
            this.zzanA.signalAll();
        }
        finally {
            this.zzamw.unlock();
        }
    }

    void zzi(ConnectionResult connectionResult) {
        this.zzamw.lock();
        try {
            this.zzanE = connectionResult;
            this.zzanD = new zzoe(this);
            this.zzanD.begin();
            this.zzanA.signalAll();
        }
        finally {
            this.zzamw.unlock();
        }
    }

    void zzso() {
        for (Api.zze zze2 : this.zzann.values()) {
            zze2.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzanD instanceof zzoc;
    }

    @Override
    public boolean isConnecting() {
        return this.zzanD instanceof zzod;
    }

    @Override
    public boolean zza(zzpa zzpa2) {
        return false;
    }

    @Override
    public void zzrr() {
    }

    @Override
    public void zzrN() {
        if (this.isConnected()) {
            ((zzoc)this.zzanD).zzrW();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, int n) {
        this.zzamw.lock();
        try {
            this.zzanD.zza(connectionResult, api, n);
        }
        finally {
            this.zzamw.unlock();
        }
    }

    public void onConnected(@Nullable Bundle bundle) {
        this.zzamw.lock();
        try {
            this.zzanD.onConnected(bundle);
        }
        finally {
            this.zzamw.unlock();
        }
    }

    public void onConnectionSuspended(int n) {
        this.zzamw.lock();
        try {
            this.zzanD.onConnectionSuspended(n);
        }
        finally {
            this.zzamw.unlock();
        }
    }

    void zza(zza zza2) {
        Message message = this.zzanB.obtainMessage(1, zza2);
        this.zzanB.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.zzanB.obtainMessage(2, runtimeException);
        this.zzanB.sendMessage(message);
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        for (Api<?> api : this.zzamT.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            Api.zze zze2 = this.zzann.get(api.zzre());
            zze2.dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static abstract class zza {
        private final zzog zzanH;

        protected zza(zzog zzog2) {
            this.zzanH = zzog2;
        }

        public final void zzd(zzoh zzoh2) {
            zzoh2.zzamw.lock();
            try {
                if (zzoh2.zzanD != this.zzanH) {
                    return;
                }
                this.zzrX();
            }
            finally {
                zzoh2.zzamw.unlock();
            }
        }

        protected abstract void zzrX();
    }

    final class zzb
    extends Handler {
        zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zza zza2 = (zza)message.obj;
                    zza2.zzd(zzoh.this);
                    break;
                }
                case 2: {
                    throw (RuntimeException)message.obj;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GACStateManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }
}

