/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzq
extends Fragment
implements DialogInterface.OnCancelListener,
LoaderManager.LoaderCallbacks<ConnectionResult> {
    private boolean zzaaJ;
    private int zzaaK = -1;
    private ConnectionResult zzaaL;
    private final Handler zzaaM = new Handler(Looper.getMainLooper());
    private final SparseArray<zzb> zzaaN = new SparseArray();

    public static zzq zzc(FragmentActivity fragmentActivity) {
        zzq zzq2;
        zzx.zzch("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            zzq2 = (zzq)fragmentManager.findFragmentByTag("GmsSupportLoaderLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLoaderLifecycleFragment is not a SupportLoaderLifecycleFragment", classCastException);
        }
        if (zzq2 == null || zzq2.isRemoving()) {
            zzq2 = new zzq();
            fragmentManager.beginTransaction().add((Fragment)zzq2, "GmsSupportLoaderLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return zzq2;
    }

    public GoogleApiClient zzbj(int n) {
        zza zza2;
        if (this.getActivity() != null && (zza2 = this.zzbk(n)) != null) {
            return zza2.zzaaP;
        }
        return null;
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzx.zzb(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzx.zza(this.zzaaN.indexOfKey(n) < 0, (Object)("Already managing a GoogleApiClient with id " + n));
        zzb zzb2 = new zzb(googleApiClient, onConnectionFailedListener);
        this.zzaaN.put(n, (Object)zzb2);
        if (this.getActivity() != null) {
            LoaderManager.enableDebugLogging((boolean)false);
            this.getLoaderManager().initLoader(n, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void zzbi(int n) {
        this.zzaaN.remove(n);
        this.getLoaderManager().destroyLoader(n);
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(this.zzaaK, new ConnectionResult(13, null));
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        for (int i = 0; i < this.zzaaN.size(); ++i) {
            int n = this.zzaaN.keyAt(i);
            zza zza2 = this.zzbk(n);
            if (zza2 != null) {
                zzb zzb2 = (zzb)this.zzaaN.valueAt(i);
                if (zzb2.zzaaP != zza2.zzaaP) {
                    this.getLoaderManager().restartLoader(n, null, (LoaderManager.LoaderCallbacks)this);
                    continue;
                }
            }
            this.getLoaderManager().initLoader(n, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.zzaaJ = savedInstanceState.getBoolean("resolving_error", false);
            this.zzaaK = savedInstanceState.getInt("failed_client_id", -1);
            if (this.zzaaK >= 0) {
                this.zzaaL = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.zzaaJ);
        if (this.zzaaK >= 0) {
            outState.putInt("failed_client_id", this.zzaaK);
            outState.putInt("failed_status", this.zzaaL.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.zzaaL.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.zzaaJ) {
            for (int i = 0; i < this.zzaaN.size(); ++i) {
                this.getLoaderManager().initLoader(this.zzaaN.keyAt(i), null, (LoaderManager.LoaderCallbacks)this);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl = true;
            }
        }
        if (bl) {
            this.zznJ();
        } else {
            this.zza(this.zzaaK, this.zzaaL);
        }
    }

    public Loader<ConnectionResult> onCreateLoader(int id, Bundle args) {
        return new zza((Context)this.getActivity(), ((zzb)this.zzaaN.get((int)id)).zzaaP);
    }

    public void zza(Loader<ConnectionResult> loader, ConnectionResult connectionResult) {
        if (!connectionResult.isSuccess()) {
            this.zzb(loader.getId(), connectionResult);
        }
    }

    public void onLoaderReset(Loader<ConnectionResult> loader) {
    }

    zza zzbk(int n) {
        try {
            return (zza)this.getLoaderManager().getLoader(n);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Unknown loader in SupportLoaderLifecycleFragment", classCastException);
        }
    }

    private void zzb(int n, ConnectionResult connectionResult) {
        if (!this.zzaaJ) {
            this.zzaaJ = true;
            this.zzaaK = n;
            this.zzaaL = connectionResult;
            this.zzaaM.post((Runnable)new zzc(n, connectionResult));
        }
    }

    private void zza(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLoaderLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        zzb zzb2 = (zzb)this.zzaaN.get(n);
        if (zzb2 != null) {
            this.zzbi(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zzb2.zzaaQ;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.zznJ();
    }

    private void zznJ() {
        this.zzaaJ = false;
        this.zzaaK = -1;
        this.zzaaL = null;
        LoaderManager loaderManager = this.getLoaderManager();
        for (int i = 0; i < this.zzaaN.size(); ++i) {
            int n = this.zzaaN.keyAt(i);
            zza zza2 = this.zzbk(n);
            if (zza2 == null || !zza2.zznL()) continue;
            loaderManager.destroyLoader(n);
            loaderManager.initLoader(n, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public /* synthetic */ void onLoadFinished(Loader x0, Object x1) {
        this.zza((Loader<ConnectionResult>)x0, (ConnectionResult)x1);
    }

    static class zza
    extends Loader<ConnectionResult>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        public final GoogleApiClient zzaaP;
        private boolean zzaaU;
        private ConnectionResult zzaaV;

        public zza(Context context, GoogleApiClient googleApiClient) {
            super(context);
            this.zzaaP = googleApiClient;
        }

        public boolean zznL() {
            return this.zzaaU;
        }

        protected void onStartLoading() {
            super.onStartLoading();
            this.zzaaP.registerConnectionCallbacks(this);
            this.zzaaP.registerConnectionFailedListener(this);
            if (this.zzaaV != null) {
                this.deliverResult(this.zzaaV);
            }
            if (!(this.zzaaP.isConnected() || this.zzaaP.isConnecting() || this.zzaaU)) {
                this.zzaaP.connect();
            }
        }

        protected void onStopLoading() {
            this.zzaaP.disconnect();
        }

        protected void onReset() {
            this.zzaaV = null;
            this.zzaaU = false;
            this.zzaaP.unregisterConnectionCallbacks(this);
            this.zzaaP.unregisterConnectionFailedListener(this);
            this.zzaaP.disconnect();
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.zzaaU = false;
            this.zzh(ConnectionResult.zzYi);
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.zzaaU = true;
            this.zzh(result);
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            this.zzaaP.dump(prefix, fd, writer, args);
        }

        private void zzh(ConnectionResult connectionResult) {
            this.zzaaV = connectionResult;
            if (this.isStarted() && !this.isAbandoned()) {
                this.deliverResult(connectionResult);
            }
        }
    }

    private static class zzb {
        public final GoogleApiClient zzaaP;
        public final GoogleApiClient.OnConnectionFailedListener zzaaQ;

        private zzb(GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzaaP = googleApiClient;
            this.zzaaQ = onConnectionFailedListener;
        }
    }

    private class zzc
    implements Runnable {
        private final int zzaaS;
        private final ConnectionResult zzaaT;

        public zzc(int n, ConnectionResult connectionResult) {
            this.zzaaS = n;
            this.zzaaT = connectionResult;
        }

        @Override
        public void run() {
            if (this.zzaaT.hasResolution()) {
                try {
                    int n = zzq.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)zzq.this);
                    int n2 = 1 + (1 + n << 16);
                    this.zzaaT.startResolutionForResult((Activity)zzq.this.getActivity(), n2);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    zzq.this.zznJ();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.zzaaT.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.zzaaT.getErrorCode(), (Activity)zzq.this.getActivity(), zzq.this, 2, zzq.this);
            } else {
                zzq.this.zza(this.zzaaS, this.zzaaT);
            }
        }
    }
}

