/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzf;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.api.zzj;
import com.google.android.gms.common.api.zzl;
import com.google.android.gms.common.api.zzo;
import com.google.android.gms.common.api.zzp;
import com.google.android.gms.common.api.zzq;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzkw;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class zzi
implements GoogleApiClient {
    private final Lock zzZs = new ReentrantLock();
    private final Condition zzZX;
    final zzk zzZY;
    private final int zzZf;
    private final int zzZg;
    private final Context mContext;
    private final Looper zzYV;
    final Queue<zze<?>> zzZZ = new LinkedList();
    private volatile boolean zzaaa;
    private long zzaab = 120000L;
    private long zzaac = 5000L;
    private final zza zzaad;
    private final GoogleApiAvailability zzZi;
    BroadcastReceiver zzaae;
    final Map<Api.zzc<?>, Api.zzb> zzaaf = new HashMap();
    final Map<Api.zzc<?>, ConnectionResult> zzaag = new HashMap();
    Set<Scope> zzaah = new HashSet<Scope>();
    final com.google.android.gms.common.internal.zzf zzZH;
    final Map<Api<?>, Integer> zzZI;
    final Api.zza<? extends com.google.android.gms.signin.zzd, com.google.android.gms.signin.zze> zzZj;
    private volatile zzj zzaai;
    private ConnectionResult zzaaj = null;
    private final Set<zzl<?>> zzaak = Collections.newSetFromMap(new WeakHashMap());
    final Set<zze<?>> zzaal = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 2));
    private final zzd zzaam = new zzd(){

        @Override
        public void zzc(zze<?> zze2) {
            zzi.this.zzaal.remove(zze2);
        }
    };
    private final GoogleApiClient.ConnectionCallbacks zzaan = new GoogleApiClient.ConnectionCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected(Bundle connectionHint) {
            zzi.this.zzZs.lock();
            try {
                zzi.this.zzaai.onConnected(connectionHint);
            }
            finally {
                zzi.this.zzZs.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionSuspended(int cause) {
            zzi.this.zzZs.lock();
            try {
                zzi.this.zzaai.onConnectionSuspended(cause);
            }
            finally {
                zzi.this.zzZs.unlock();
            }
        }
    };
    private final zzk.zza zzaao = new zzk.zza(){

        @Override
        public boolean isConnected() {
            return zzi.this.isConnected();
        }

        @Override
        public Bundle zzmw() {
            return null;
        }
    };

    private final GoogleApiClient.OnConnectionFailedListener zza(final Api<?> api, final int n) {
        return new GoogleApiClient.OnConnectionFailedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionFailed(ConnectionResult result) {
                zzi.this.zzZs.lock();
                try {
                    zzi.this.zzaai.zza(result, api, n);
                }
                finally {
                    zzi.this.zzZs.unlock();
                }
            }
        };
    }

    public zzi(Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends com.google.android.gms.signin.zzd, com.google.android.gms.signin.zze> zza2, Map<Api<?>, Api.ApiOptions> map, ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList, ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList2, int n, int n2) {
        this.mContext = context;
        this.zzZY = new zzk(looper, this.zzaao);
        this.zzYV = looper;
        this.zzaad = new zza(looper);
        this.zzZi = googleApiAvailability;
        this.zzZf = n;
        this.zzZg = n2;
        this.zzZI = new HashMap();
        this.zzZX = this.zzZs.newCondition();
        this.zzaai = new zzh(this);
        for (GoogleApiClient.ConnectionCallbacks iterator : arrayList) {
            this.zzZY.registerConnectionCallbacks(iterator);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList2) {
            this.zzZY.registerConnectionFailedListener(onConnectionFailedListener);
        }
        Map<Api<?>, zzf.zza> map2 = zzf2.zzok();
        for (Api<?> api : map.keySet()) {
            Api.ApiOptions apiOptions = map.get(api);
            int n3 = 0;
            if (map2.get(api) != null) {
                n3 = ((zzf.zza)map2.get(api)).zzadg ? 1 : 2;
            }
            this.zzZI.put(api, n3);
            zzac<Object> zzac2 = api.zzne() ? zzi.zza(api.zznc(), (Object)apiOptions, context, looper, zzf2, this.zzaan, this.zza(api, n3)) : zzi.zza(api.zznb(), (Object)apiOptions, context, looper, zzf2, this.zzaan, this.zza(api, n3));
            this.zzaaf.put(api.zznd(), zzac2);
        }
        this.zzZH = zzf2;
        this.zzZj = zza2;
    }

    private static <C extends Api.zzb, O> C zza(Api.zza<C, O> zza2, Object object, Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return zza2.zza(context, looper, zzf2, object, connectionCallbacks, onConnectionFailedListener);
    }

    private static <C extends Api.zzd, O> zzac zza(Api.zze<C, O> zze2, Object object, Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return new zzac(context, looper, zze2.zznf(), connectionCallbacks, onConnectionFailedListener, zzf2, (Api.zzd)zze2.zzm(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zzb, R extends Result, T extends zzc.zza<R, A>> T zza(T t) {
        zzx.zzb(t.zznd() != null, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        zzx.zzb(this.zzaaf.containsKey(t.zznd()), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        this.zzZs.lock();
        try {
            T t2 = this.zzaai.zza(t);
            return t2;
        }
        finally {
            this.zzZs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zzb, T extends zzc.zza<? extends Result, A>> T zzb(T t) {
        zzx.zzb(t.zznd() != null, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        this.zzZs.lock();
        try {
            if (this.zznB()) {
                Object object;
                this.zzZZ.add(t);
                while (!this.zzZZ.isEmpty()) {
                    object = this.zzZZ.remove();
                    this.zzb((zze<A>)object);
                    object.zzx(Status.zzaaF);
                }
                object = t;
                return (T)object;
            }
            T t2 = this.zzaai.zzb(t);
            return t2;
        }
        finally {
            this.zzZs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> zzl<L> zzp(L l) {
        zzx.zzb(l, (Object)"Listener must not be null");
        this.zzZs.lock();
        try {
            zzl<L> zzl2 = new zzl<L>(this.zzYV, l);
            this.zzaak.add(zzl2);
            zzl<L> zzl3 = zzl2;
            return zzl3;
        }
        finally {
            this.zzZs.unlock();
        }
    }

    @Override
    public <C extends Api.zzb> C zza(Api.zzc<C> zzc2) {
        Api.zzb zzb2 = this.zzaaf.get(zzc2);
        zzx.zzb(zzb2, (Object)"Appropriate Api was not requested.");
        return (C)zzb2;
    }

    @Override
    public boolean zza(Api<?> api) {
        return this.zzaaf.containsKey(api.zznd());
    }

    @Override
    public boolean hasConnectedApi(Api<?> api) {
        Api.zzb zzb2 = this.zzaaf.get(api.zznd());
        return zzb2 == null ? false : zzb2.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult getConnectionResult(Api<?> api) {
        Api.zzc<?> zzc2 = api.zznd();
        this.zzZs.lock();
        try {
            if (!this.isConnected() && !this.zznB()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.zzaaf.containsKey(zzc2)) {
                if (this.zzaaf.get(zzc2).isConnected()) {
                    ConnectionResult connectionResult = ConnectionResult.zzYi;
                    return connectionResult;
                }
                if (this.zzaag.containsKey(zzc2)) {
                    ConnectionResult connectionResult = this.zzaag.get(zzc2);
                    return connectionResult;
                }
                Log.wtf((String)"GoogleApiClientImpl", (String)(api.getName() + " requested in getConnectionResult" + " is not connected but is not present in the failed connections map"));
                ConnectionResult connectionResult = new ConnectionResult(8, null);
                return connectionResult;
            }
        }
        finally {
            this.zzZs.unlock();
        }
        throw new IllegalArgumentException(api.getName() + " was never registered with GoogleApiClient");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zza(Scope scope) {
        this.zzZs.lock();
        try {
            boolean bl = this.isConnected() && this.zzaah.contains(scope);
            return bl;
        }
        finally {
            this.zzZs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.zzZs.lock();
        try {
            this.zzaai.connect();
        }
        finally {
            this.zzZs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzZs.lock();
        try {
            this.connect();
            while (this.isConnecting()) {
                try {
                    this.zzZX.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    this.zzZs.unlock();
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzYi;
                return connectionResult;
            }
            if (this.zzaaj != null) {
                ConnectionResult connectionResult = this.zzaaj;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zzZs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzZs.lock();
        try {
            this.connect();
            long l = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l = this.zzZX.awaitNanos(l);
                    if (l > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzYi;
                return connectionResult;
            }
            if (this.zzaaj != null) {
                ConnectionResult connectionResult = this.zzaaj;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zzZs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzZs.lock();
        try {
            this.zznE();
            this.zzaai.disconnect();
        }
        finally {
            this.zzZs.unlock();
        }
    }

    void zznx() {
        for (zze<?> object : this.zzaal) {
            object.zza(null);
            object.cancel();
        }
        this.zzaal.clear();
        for (zzl zzl2 : this.zzaak) {
            zzl2.clear();
        }
        this.zzaak.clear();
    }

    void zzny() {
        for (Api.zzb zzb2 : this.zzaaf.values()) {
            zzb2.disconnect();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zznz() {
        this.zzZs.lock();
        try {
            this.zzaai = new zzg(this, this.zzZH, this.zzZI, this.zzZi, this.zzZj, this.zzZs, this.mContext);
            this.zzaai.begin();
            this.zzZX.signalAll();
        }
        finally {
            this.zzZs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zznA() {
        this.zzZs.lock();
        try {
            this.zznE();
            this.zzaai = new zzf(this);
            this.zzaai.begin();
            this.zzZX.signalAll();
        }
        finally {
            this.zzZs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzg(ConnectionResult connectionResult) {
        this.zzZs.lock();
        try {
            this.zzaaj = connectionResult;
            this.zzaai = new zzh(this);
            this.zzaai.begin();
            this.zzZX.signalAll();
        }
        finally {
            this.zzZs.unlock();
        }
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzx.zza(this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        final zzo zzo2 = new zzo(this.zzYV);
        if (this.zzaaf.containsKey(zzkw.zzQf)) {
            this.zza(this, zzo2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle connectionHint) {
                    zzi.this.zza((GoogleApiClient)atomicReference.get(), zzo2, true);
                }

                @Override
                public void onConnectionSuspended(int cause) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    zzo2.zza(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzkw.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.zzaad).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzo2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzo zzo2, final boolean bl) {
        zzkw.zzaet.zzc(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzr(Status status) {
                if (status.isSuccess() && zzi.this.isConnected()) {
                    zzi.this.reconnect();
                }
                zzo2.zza(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.zzr((Status)x0);
            }
        });
    }

    @Override
    public void stopAutoManage(final FragmentActivity lifecycleActivity) {
        if (this.zzZf >= 0) {
            zzp zzp2 = zzp.zza(lifecycleActivity);
            if (zzp2 == null) {
                Handler handler = new Handler(this.mContext.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (lifecycleActivity.isFinishing() || lifecycleActivity.getSupportFragmentManager().isDestroyed()) {
                            return;
                        }
                        zzp.zzb(lifecycleActivity).zzbi(zzi.this.zzZf);
                    }
                });
            } else {
                zzp2.zzbi(this.zzZf);
            }
        } else if (this.zzZg >= 0) {
            zzq.zzc(lifecycleActivity).zzbi(this.zzZg);
        } else {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzaai instanceof zzf;
    }

    @Override
    public boolean isConnecting() {
        return this.zzaai instanceof zzg;
    }

    boolean zznB() {
        return this.zzaaa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        this.zzZs.lock();
        try {
            if (this.zznB()) {
                this.connect();
            }
        }
        finally {
            this.zzZs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zznC() {
        this.zzZs.lock();
        try {
            boolean bl = this.zznE();
            if (bl) {
                this.connect();
            }
        }
        finally {
            this.zzZs.unlock();
        }
    }

    void zznD() {
        if (this.zznB()) {
            return;
        }
        this.zzaaa = true;
        if (this.zzaae == null) {
            this.zzaae = new zzc(this);
            IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
            intentFilter.addDataScheme("package");
            this.mContext.getApplicationContext().registerReceiver(this.zzaae, intentFilter);
        }
        this.zzaad.sendMessageDelayed(this.zzaad.obtainMessage(1), this.zzaab);
        this.zzaad.sendMessageDelayed(this.zzaad.obtainMessage(2), this.zzaac);
    }

    boolean zznE() {
        if (!this.zznB()) {
            return false;
        }
        this.zzaaa = false;
        this.zzaad.removeMessages(2);
        this.zzaad.removeMessages(1);
        if (this.zzaae != null) {
            this.mContext.getApplicationContext().unregisterReceiver(this.zzaae);
            this.zzaae = null;
        }
        return true;
    }

    void zza(zzb zzb2) {
        Message message = this.zzaad.obtainMessage(3, zzb2);
        this.zzaad.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.zzaad.obtainMessage(4, runtimeException);
        this.zzaad.sendMessage(message);
    }

    <A extends Api.zzb> void zzb(zze<A> zze2) {
        this.zzaal.add(zze2);
        zze2.zza(this.zzaam);
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzZY.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.zzZY.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzZY.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzZY.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.zzZY.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzZY.unregisterConnectionFailedListener(listener);
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzYV;
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.append(prefix).append("mState=").append(this.zzaai.getName());
        writer.append(" mResuming=").print(this.zzaaa);
        writer.append(" mWorkQueue.size()=").print(this.zzZZ.size());
        writer.append(" mUnconsumedRunners.size()=").println(this.zzaal.size());
        String string2 = prefix + "  ";
        for (Api<?> api : this.zzZI.keySet()) {
            writer.append(prefix).append(api.getName()).println(":");
            Api.zzb zzb2 = this.zzaaf.get(api.zznd());
            zzb2.dump(string2, fd, writer, args);
        }
    }

    @Override
    public int getSessionId() {
        return System.identityHashCode(this);
    }

    static abstract class zzb {
        private final zzj zzaaw;

        protected zzb(zzj zzj2) {
            this.zzaaw = zzj2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzf(zzi zzi2) {
            zzi2.zzZs.lock();
            try {
                if (zzi2.zzaai != this.zzaaw) {
                    return;
                }
                this.zznn();
            }
            finally {
                zzi2.zzZs.unlock();
            }
        }

        protected abstract void zznn();
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    zzi.this.zznC();
                    break;
                }
                case 2: {
                    zzi.this.resume();
                    break;
                }
                case 3: {
                    zzb zzb2 = (zzb)msg.obj;
                    zzb2.zzf(zzi.this);
                    break;
                }
                case 4: {
                    RuntimeException runtimeException = (RuntimeException)msg.obj;
                    throw runtimeException;
                }
                default: {
                    Log.w((String)"GoogleApiClientImpl", (String)("Unknown message id: " + msg.what));
                }
            }
        }
    }

    private static class zzc
    extends BroadcastReceiver {
        private WeakReference<zzi> zzaax;

        zzc(zzi zzi2) {
            this.zzaax = new WeakReference<zzi>(zzi2);
        }

        public void onReceive(Context context, Intent intent) {
            Uri uri = intent.getData();
            String string2 = null;
            if (uri != null) {
                string2 = uri.getSchemeSpecificPart();
            }
            if (string2 == null || !string2.equals("com.google.android.gms")) {
                return;
            }
            zzi zzi2 = (zzi)this.zzaax.get();
            if (zzi2 == null) {
                return;
            }
            zzi2.resume();
        }
    }

    static interface zze<A extends Api.zzb> {
        public void cancel();

        public Api.zzc<A> zznd();

        public void zzb(A var1) throws DeadObjectException;

        public void zzw(Status var1);

        public void zzx(Status var1);

        public void zza(zzd var1);

        public int zzng();
    }

    static interface zzd {
        public void zzc(zze<?> var1);
    }
}

