/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.playlog.internal;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.playlog.internal.zzc;

public class LogEvent
implements SafeParcelable {
    public static final zzc CREATOR = new zzc();
    public final int versionCode;
    public final long zzaGF;
    public final String tag;
    public final byte[] zzaGG;
    public final Bundle zzaGH;

    LogEvent(int versionCode, long eventTime, String tag, byte[] sourceExtensionBytes, Bundle keyValuePairs) {
        this.versionCode = versionCode;
        this.zzaGF = eventTime;
        this.tag = tag;
        this.zzaGG = sourceExtensionBytes;
        this.zzaGH = keyValuePairs;
    }

    public LogEvent(long eventTime, String tag, byte[] sourceExtensionBytes, String ... extras) {
        this.versionCode = 1;
        this.zzaGF = eventTime;
        this.tag = tag;
        this.zzaGG = sourceExtensionBytes;
        this.zzaGH = LogEvent.zzd(extras);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    private static Bundle zzd(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("extras must have an even number of elements");
        }
        int n = stringArray.length / 2;
        if (n == 0) {
            return null;
        }
        Bundle bundle = new Bundle(n);
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i * 2];
            String string3 = stringArray[i * 2 + 1];
            bundle.putString(string2, string3);
        }
        return bundle;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tag=").append(this.tag).append(",");
        stringBuilder.append("eventTime=").append(this.zzaGF).append(",");
        if (this.zzaGH != null && !this.zzaGH.isEmpty()) {
            stringBuilder.append("keyValues=");
            for (String string2 : this.zzaGH.keySet()) {
                stringBuilder.append("(").append(string2).append(",");
                stringBuilder.append(this.zzaGH.getString(string2)).append(")");
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }
}

