/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.AbstractPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzk;
import com.google.android.gms.common.internal.zzv;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status result) {
        zzv.zzb(result, (Object)"Result must not be null");
        zzk zzk2 = new zzk(Looper.getMainLooper());
        zzk2.setResult(result);
        return zzk2;
    }

    public static <R extends Result> PendingResult<R> immediatePendingResult(R result) {
        zzv.zzb(result, (Object)"Result must not be null");
        zzb<R> zzb2 = new zzb<R>();
        zzb2.setResult(result);
        return zzb2;
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzk zzk2 = new zzk(Looper.getMainLooper());
        zzk2.cancel();
        return zzk2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R result) {
        zzv.zzb(result, (Object)"Result must not be null");
        zzv.zzb(result.getStatus().getStatusCode() == 16, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(result);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends AbstractPendingResult<R> {
        private final R zzQS;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zzQS = r;
        }

        @Override
        protected R createFailedResult(Status status) {
            if (status.getStatusCode() != this.zzQS.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zzQS;
        }
    }

    private static final class zzb<R extends Result>
    extends AbstractPendingResult<R> {
        public zzb() {
            super(Looper.getMainLooper());
        }

        @Override
        protected R createFailedResult(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

