/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzmh;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class zzk<T extends IInterface>
implements Api.zza,
zzl.zza {
    private final Context mContext;
    private final com.google.android.gms.common.internal.zzf zzPG;
    private final Looper zzMc;
    private final zzm zzPH;
    final Handler mHandler;
    private final Object zznh = new Object();
    private zzs zzPI;
    private boolean zzPJ = false;
    private GoogleApiClient.zza zzPK;
    private T zzPL;
    private final ArrayList<zzc<?>> zzPM = new ArrayList();
    private zze zzPN;
    private int zzPO = 1;
    private final List<String> zzMM;
    private final Account zzFN;
    boolean zzPP = false;
    private final zzl zzMu;
    private final int zzPQ;
    public static final String[] zzPR = new String[]{"service_esmobile", "service_googleme"};

    @Deprecated
    protected zzk(Context context, Looper looper, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.mContext = zzx.zzl(context);
        this.zzMc = zzx.zzb(looper, (Object)"Looper must not be null");
        this.zzPH = zzm.zzP(context);
        this.zzMu = new zzl(looper, this);
        this.mHandler = new zzb(looper);
        this.zzPQ = n;
        this.zzFN = null;
        this.zzMM = null;
        this.zzPG = new GoogleApiClient.Builder(context).zzhY();
        this.registerConnectionCallbacks(zzx.zzl(connectionCallbacks));
        this.registerConnectionFailedListener(zzx.zzl(onConnectionFailedListener));
    }

    protected zzk(Context context, Looper looper, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, com.google.android.gms.common.internal.zzf zzf2) {
        this(context, looper, zzm.zzP(context), n, zzf2, connectionCallbacks, onConnectionFailedListener);
    }

    protected zzk(Context context, Looper looper, zzm zzm2, int n, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, zzm2, n, zzf2);
        this.registerConnectionCallbacks(zzx.zzl(connectionCallbacks));
        this.registerConnectionFailedListener(zzx.zzl(onConnectionFailedListener));
    }

    protected zzk(Context context, Looper looper, zzm zzm2, int n, com.google.android.gms.common.internal.zzf zzf2) {
        this.mContext = zzx.zzb(context, (Object)"Context must not be null");
        this.zzMc = zzx.zzb(looper, (Object)"Looper must not be null");
        this.zzPH = zzx.zzb(zzm2, (Object)"Supervisor must not be null");
        this.zzMu = new zzl(looper, this);
        this.mHandler = new zzb(looper);
        this.zzPQ = n;
        this.zzPG = zzx.zzl(zzf2);
        this.zzFN = zzf2.getAccount();
        this.zzMM = this.zzh(zzf2.zziP());
    }

    private List<String> zzh(List<String> list) {
        List<String> list2 = this.zzf(list);
        if (list2 == null || list2 == list) {
            return list2;
        }
        for (String string2 : list2) {
            if (list.contains(string2)) continue;
            throw new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
        }
        return list2;
    }

    protected List<String> zzf(List<String> list) {
        return list;
    }

    protected abstract String zzcF();

    protected abstract String zzcG();

    protected String zziZ() {
        return this.zzPG.zziS();
    }

    protected abstract T zzp(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(int n, T t) {
        zzx.zzO(n == 3 == (t != null));
        Object object = this.zznh;
        synchronized (object) {
            this.zzPO = n;
            this.zzPL = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zznh;
        synchronized (object) {
            if (this.zzPO != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    @Override
    public void connect() {
        this.zzPP = true;
        this.zza(2, null);
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n));
            return;
        }
        if (this.zzPN != null) {
            Log.e((String)"GmsClient", (String)("Calling connect() while still connected, missing disconnect() for " + this.zzcF()));
            this.zzPH.zzb(this.zzcF(), (ServiceConnection)this.zzPN, this.zziZ());
        }
        this.zzPN = new zze();
        boolean bl = this.zzPH.zza(this.zzcF(), (ServiceConnection)this.zzPN, this.zziZ());
        if (!bl) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.zzcF()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzPO == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzPO == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzPP = false;
        ArrayList<zzc<?>> arrayList = this.zzPM;
        synchronized (arrayList) {
            int n = this.zzPM.size();
            for (int i = 0; i < n; ++i) {
                this.zzPM.get(i).zzjh();
            }
            this.zzPM.clear();
        }
        this.zza(1, null);
        if (this.zzPN != null) {
            this.zzPH.zzb(this.zzcF(), (ServiceConnection)this.zzPN, this.zziZ());
            this.zzPN = null;
        }
    }

    public void zzaI(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)n));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzMc;
    }

    public final List<String> zziP() {
        return this.zzMM;
    }

    public final Account zziN() {
        return this.zzFN != null ? this.zzFN : new Account("<<default account>>", "com.google");
    }

    protected final com.google.android.gms.common.internal.zzf zzja() {
        return this.zzPG;
    }

    protected Bundle zzhq() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new zzf(n, iBinder, bundle)));
    }

    protected void zzb(int n, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, (Object)new zzh(n, bundle)));
    }

    protected final void zzfc() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle zzhp() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzjb() throws DeadObjectException {
        Object object = this.zznh;
        synchronized (object) {
            if (this.zzPO == 4) {
                throw new DeadObjectException();
            }
            this.zzfc();
            zzx.zza(this.zzPL != null, (Object)"Client is connected but service is null");
            return this.zzPL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void zza(zzc<?> zzc2) {
        ArrayList<zzc<?>> arrayList = this.zzPM;
        synchronized (arrayList) {
            this.zzPM.add(zzc2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, zzc2));
    }

    @Override
    public boolean zzin() {
        return this.zzPP;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzMu.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzMu.registerConnectionFailedListener(listener);
    }

    @Override
    public void zza(GoogleApiClient.zza zza2) {
        this.zzPK = zzx.zzb(zza2, (Object)"Must provide a non-null ConnectionStatusReportCallbacks");
        this.zzPJ = true;
    }

    @Override
    public void zza(zzq zzq2) {
        Bundle bundle = this.zzjc();
        zzae zzae2 = new zzae(zzq2, this.zzMM == null ? null : zzmh.zzi(this.zzMM), this.mContext.getPackageName(), bundle);
        try {
            this.zzPI.zza((zzr)new zzd(this), zzae2);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzaI(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    protected Bundle zzjc() {
        return null;
    }

    @Override
    public void zzb(zzq zzq2) {
        try {
            Bundle bundle = this.zzhq();
            zzi zzi2 = new zzi(this.zzPQ).zzbg(this.mContext.getPackageName()).zzi(bundle);
            if (this.zzMM != null) {
                zzi2.zza(zzmh.zzi(this.zzMM));
            }
            if (this.zzhc()) {
                zzi2.zzb(this.zziN()).zzd(zzq2);
            } else if (this.zzjd()) {
                zzi2.zzb(this.zzFN);
            }
            this.zzPI.zza((zzr)new zzd(this), zzi2);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzaI(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    @Override
    public boolean zzhc() {
        return false;
    }

    public boolean zzjd() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        T t;
        int n;
        writer.append(prefix).println("GmsClient:");
        String string2 = prefix + "  ";
        writer.append(string2).append("mStartServiceAction=").println(this.zzcF());
        Object object = this.zznh;
        synchronized (object) {
            n = this.zzPO;
            t = this.zzPL;
        }
        writer.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                writer.print("CONNECTING");
                break;
            }
            case 3: {
                writer.print("CONNECTED");
                break;
            }
            case 4: {
                writer.print("DISCONNECTING");
                break;
            }
            case 1: {
                writer.print("DISCONNECTED");
                break;
            }
            default: {
                writer.print("UNKNOWN");
            }
        }
        writer.append(" mService=");
        if (t == null) {
            writer.println("null");
        } else {
            writer.append(this.zzcG()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
    }

    public static final class zzd
    extends zzr.zza {
        private zzk zzPV;

        public zzd(zzk zzk2) {
            this.zzPV = zzk2;
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            zzx.zzb(this.zzPV, (Object)"onAccountValidationComplete can be called only once per call to validateAccount");
            this.zzPV.zzb(n, bundle);
            this.zzji();
        }

        @Override
        public void zzb(int n, IBinder iBinder, Bundle bundle) {
            zzx.zzb(this.zzPV, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.zzPV.zza(n, iBinder, bundle);
            this.zzji();
        }

        private void zzji() {
            this.zzPV = null;
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        public final int statusCode;
        public final Bundle zzPS;

        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzPS = bundle;
        }

        protected abstract boolean zzje();

        protected void zzf(ConnectionResult connectionResult) {
            zzk.this.zzMu.zzg(connectionResult);
        }

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzk.this.zza(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzje()) break;
                    if (zzk.this.zzPN != null) {
                        zzk.this.zzPH.zzb(zzk.this.zzcF(), (ServiceConnection)zzk.this.zzPN, zzk.this.zziZ());
                        zzk.this.zzPN = null;
                    }
                    zzk.this.zza(1, null);
                    this.zzf(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzk.this.zza(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.zzPS != null) {
                        pendingIntent = (PendingIntent)this.zzPS.getParcelable("pendingIntent");
                    }
                    if (zzk.this.zzPN != null) {
                        zzk.this.zzPH.zzb(zzk.this.zzcF(), (ServiceConnection)zzk.this.zzPN, zzk.this.zziZ());
                        zzk.this.zzPN = null;
                    }
                    zzk.this.zza(1, null);
                    this.zzf(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zzjf() {
        }

        @Override
        protected /* synthetic */ void zzi(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzf
    extends zza {
        public final IBinder zzPW;

        public zzf(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzPW = iBinder;
        }

        @Override
        protected boolean zzje() {
            String string2;
            try {
                string2 = this.zzPW.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzk.this.zzcG().equals(string2)) {
                return false;
            }
            Object t = zzk.this.zzp(this.zzPW);
            if (t != null && zzk.this.zza(2, 3, t)) {
                zzk.this.zzMu.zzfe();
                GooglePlayServicesUtil.zzL(zzk.this.mContext);
                return true;
            }
            return false;
        }
    }

    protected final class zzh
    extends zza {
        public zzh(int n, Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected boolean zzje() {
            zzx.zza(zzk.this.zzPJ && zzk.this.zzPK != null, (Object)"PostValidationCallback should not happen when mReportProgress is false ormConnectionProgressReportCallbacks is null");
            zzk.this.zzPK.zzib();
            return true;
        }
    }

    protected final class zzg
    extends zza {
        public zzg() {
            super(0, null);
        }

        @Override
        protected boolean zzje() {
            if (zzk.this.zzPJ) {
                zzx.zza(zzk.this.zzPK != null, (Object)"mConnectionProgressReportCallbacks should not be null if mReportProgress");
                zzk.this.zzPK.zzia();
            } else {
                zzk.this.zzb(null);
            }
            return true;
        }
    }

    protected abstract class zzc<TListener> {
        private TListener mListener;
        private boolean zzPU;

        public zzc(TListener TListener) {
            this.mListener = TListener;
            this.zzPU = false;
        }

        protected abstract void zzi(TListener var1);

        protected abstract void zzjf();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzjg() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.mListener;
                if (this.zzPU) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.zzi(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzjf();
                    throw runtimeException;
                }
            } else {
                this.zzjf();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzPU = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzjh();
            ArrayList arrayList = zzk.this.zzPM;
            synchronized (arrayList) {
                zzk.this.zzPM.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzjh() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.mListener = null;
            }
        }
    }

    final class zzb
    extends Handler {
        public zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (!(msg.what != 1 && msg.what != 5 && msg.what != 6 || zzk.this.isConnecting())) {
                zzc zzc2 = (zzc)msg.obj;
                zzc2.zzjf();
                zzc2.unregister();
                return;
            }
            if (msg.what == 3) {
                zzk.this.zzMu.zzg(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                zzk.this.zza(4, null);
                zzk.this.zzMu.zzaJ((Integer)msg.obj);
                zzk.this.zza(4, 1, null);
                return;
            }
            if (msg.what == 2 && !zzk.this.isConnected()) {
                zzc zzc3 = (zzc)msg.obj;
                zzc3.zzjf();
                zzc3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1 || msg.what == 5 || msg.what == 6) {
                zzc zzc4 = (zzc)msg.obj;
                zzc4.zzjg();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    public final class zze
    implements ServiceConnection {
        public void onServiceConnected(ComponentName component, IBinder binder) {
            zzx.zzb(binder, (Object)"Expecting a valid IBinder");
            zzk.this.zzPI = zzs.zza.zzU(binder);
            zzk.this.mHandler.sendMessage(zzk.this.mHandler.obtainMessage(6, (Object)new zzg()));
        }

        public void onServiceDisconnected(ComponentName component) {
            zzk.this.mHandler.sendMessage(zzk.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

