/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.zza;
import com.google.android.gms.internal.zzkm;
import com.google.android.gms.internal.zzkv;
import com.google.android.gms.internal.zzme;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zzOl = new Object();
    private static HashSet<Uri> zzOm = new HashSet();
    private static ImageManager zzOn;
    private static ImageManager zzOo;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zzOp;
    private final zzb zzOq;
    private final zzkm zzOr;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> zzOs;
    private final Map<Uri, ImageReceiver> zzOt;
    private final Map<Uri, Long> zzOu;

    public static ImageManager create(Context context) {
        return ImageManager.zzb(context, false);
    }

    public static ImageManager zzb(Context context, boolean bl) {
        if (bl) {
            if (zzOo == null) {
                zzOo = new ImageManager(context, true);
            }
            return zzOo;
        }
        if (zzOn == null) {
            zzOn = new ImageManager(context, false);
        }
        return zzOn;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzOp = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.zzOq = new zzb(this.mContext);
            if (zzme.zzkg()) {
                this.zziE();
            }
        } else {
            this.zzOq = null;
        }
        this.zzOr = new zzkm();
        this.zzOs = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.zzOt = new HashMap<Uri, ImageReceiver>();
        this.zzOu = new HashMap<Uri, Long>();
    }

    private void zziE() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new zze(this.zzOq));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, int resId) {
        zza.zzb zzb2 = new zza.zzb(imageView, resId);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        zzb2.zzaC(defaultResId);
        this.zza(zzb2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        zza.zzc zzc2 = new zza.zzc(listener, uri);
        this.zza(zzc2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        zza.zzc zzc2 = new zza.zzc(listener, uri);
        zzc2.zzaC(defaultResId);
        this.zza(zzc2);
    }

    public void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzb.zzbd("ImageManager.loadImage() must be called in the main thread");
        zzd zzd2 = new zzd(zza2);
        zzd2.run();
    }

    private Bitmap zza(zza.zza zza2) {
        if (this.zzOq == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.zzOq.get(zza2);
        return bitmap;
    }

    private static final class zza {
        static int zza(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class zzb
    extends zzkv<zza.zza, Bitmap> {
        public zzb(Context context) {
            super(zzb.zzO(context));
        }

        protected void zza(boolean bl, zza.zza zza2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl, zza2, bitmap, bitmap2);
        }

        private static int zzO(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n = bl && zzme.zzkd() ? zza.zza(activityManager) : activityManager.getMemoryClass();
            int n2 = 0x100000 * n;
            return (int)(0.33f * (float)n2);
        }

        protected int zza(zza.zza zza2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.zza((zza.zza)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.zza(x0, (zza.zza)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class zze
    implements ComponentCallbacks2 {
        private final zzb zzOq;

        public zze(zzb zzb2) {
            this.zzOq = zzb2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.zzOq.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.zzOq.evictAll();
            } else if (level >= 20) {
                this.zzOq.trimToSize(this.zzOq.size() / 2);
            }
        }
    }

    private final class zzf
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zzmx;
        private boolean zzOz;

        public zzf(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.zzOz = bl;
            this.zzmx = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzb.zzbd("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.zzOq != null) {
                if (this.zzOz) {
                    ImageManager.this.zzOq.evictAll();
                    System.gc();
                    this.zzOz = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.zzOq.put(new zza.zza(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzOt.remove(this.mUri))) != null) {
                this.zza(imageReceiver, bl);
            }
            this.zzmx.countDown();
            Object object = zzOl;
            synchronized (object) {
                zzOm.remove(this.mUri);
            }
        }

        private void zza(ImageReceiver imageReceiver, boolean bl) {
            ArrayList arrayList = imageReceiver.zzOv;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                if (bl) {
                    zza2.zza(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.zzOu.put(this.mUri, SystemClock.elapsedRealtime());
                    zza2.zza(ImageManager.this.mContext, ImageManager.this.zzOr, false);
                }
                if (zza2 instanceof zza.zzc) continue;
                ImageManager.this.zzOs.remove(zza2);
            }
        }
    }

    private final class zzc
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor zzOx;

        public zzc(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.zzOx = parcelFileDescriptor;
        }

        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzbe("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zzOx != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zzOx.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zzOx.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zzf(this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zza> zzOv;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.zzOv = new ArrayList();
        }

        public void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzbd("ImageReceiver.addImageRequest() must be called in the main thread");
            this.zzOv.add(zza2);
        }

        public void zzc(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzbd("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zzOv.remove(zza2);
        }

        public void zziH() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zzOp.execute(new zzc(this.mUri, parcelFileDescriptor));
        }
    }

    private final class zzd
    implements Runnable {
        private final com.google.android.gms.common.images.zza zzOy;

        public zzd(com.google.android.gms.common.images.zza zza2) {
            this.zzOy = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzbd("LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzOs.get(this.zzOy));
            if (imageReceiver != null) {
                ImageManager.this.zzOs.remove(this.zzOy);
                imageReceiver.zzc(this.zzOy);
            }
            zza.zza zza2 = this.zzOy.zzOA;
            if (zza2.uri == null) {
                this.zzOy.zza(ImageManager.this.mContext, ImageManager.this.zzOr, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zza(zza2);
            if (bitmap != null) {
                this.zzOy.zza(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zzOu.get(zza2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zzOy.zza(ImageManager.this.mContext, ImageManager.this.zzOr, true);
                    return;
                }
                ImageManager.this.zzOu.remove(zza2.uri);
            }
            this.zzOy.zza(ImageManager.this.mContext, ImageManager.this.zzOr);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzOt.get(zza2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zza2.uri);
                ImageManager.this.zzOt.put(zza2.uri, imageReceiver);
            }
            imageReceiver.zzb(this.zzOy);
            if (!(this.zzOy instanceof zza.zzc)) {
                ImageManager.this.zzOs.put(this.zzOy, imageReceiver);
            }
            Object object = zzOl;
            synchronized (object) {
                boolean bl = zzOm.contains(zza2.uri);
                if (!bl) {
                    zzOm.add(zza2.uri);
                    imageReceiver.zziH();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

