/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.c;
import com.google.android.gms.common.api.d;
import com.google.android.gms.common.api.g;
import com.google.android.gms.internal.jg;
import com.google.android.gms.internal.jx;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.a, R extends Result, T extends BaseImplementation.a<R, A>> T a(T var1);

    public <A extends Api.a, T extends BaseImplementation.a<? extends Result, A>> T b(T var1);

    public <L> d<L> d(L var1);

    public <C extends Api.a> C a(Api.c<C> var1);

    public boolean a(Scope var1);

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public PendingResult<Status> clearDefaultAccountAndReconnect();

    public void stopAutoManage(FragmentActivity var1);

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public static final class Builder {
        private String DZ;
        private final Set<String> JH = new HashSet<String>();
        private int JI;
        private View JJ;
        private String JK;
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> JL = new HashMap();
        private FragmentActivity JM;
        private int JN = -1;
        private OnConnectionFailedListener JO;
        private Looper JF;
        private final Set<ConnectionCallbacks> JP = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> JQ = new HashSet<OnConnectionFailedListener>();

        public Builder(Context context) {
            this.mContext = context;
            this.JF = context.getMainLooper();
            this.JK = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            jx.b(connectedListener, (Object)"Must provide a connected listener");
            this.JP.add(connectedListener);
            jx.b(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.JQ.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            jx.b(handler, (Object)"Handler must not be null");
            this.JF = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.JP.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.JQ.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.JJ = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.JH.add(scope.gO());
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.JL.put(api, null);
            List<Scope> list = api.gy();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.JH.add(list.get(i2).gO());
            }
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            jx.b(options, (Object)"Null options are not permitted for this Api");
            this.JL.put(api, options);
            List<Scope> list = api.gy();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.JH.add(list.get(i2).gO());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.DZ = accountName;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.JI = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, int clientId, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            jx.b(clientId >= 0, (Object)"clientId must be non-negative");
            this.JN = clientId;
            this.JM = jx.b(fragmentActivity, (Object)"Null activity is not permitted.");
            this.JO = unresolvedConnectionFailedListener;
            return this;
        }

        public jg gH() {
            return new jg(this.DZ, this.JH, this.JI, this.JJ, this.JK);
        }

        public GoogleApiClient build() {
            jx.b(!this.JL.isEmpty(), (Object)"must call addApi() to add at least one API");
            if (this.JN >= 0) {
                return this.gI();
            }
            return new c(this.mContext, this.JF, this.gH(), this.JL, this.JP, this.JQ, -1);
        }

        private GoogleApiClient gI() {
            g g2 = g.a(this.JM);
            GoogleApiClient googleApiClient = g2.an(this.JN);
            if (googleApiClient == null) {
                googleApiClient = new c(this.mContext.getApplicationContext(), this.JF, this.gH(), this.JL, this.JP, this.JQ, this.JN);
            }
            g2.a(this.JN, googleApiClient, this.JO);
            return googleApiClient;
        }
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
        @Override
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

