/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zaa;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ClientIdentityCreator")
@KeepForSdk
public class ClientIdentity
extends AbstractSafeParcelable {
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<ClientIdentity> CREATOR = new zaa();
    @SafeParcelable.Field(id=1, defaultValueUnchecked="0")
    @KeepForSdk
    public final int uid;
    @SafeParcelable.Field(id=2, defaultValueUnchecked="null")
    @KeepForSdk
    @Nullable
    public final String packageName;

    public final int hashCode() {
        return this.uid;
    }

    @NonNull
    public final String toString() {
        int n = this.uid;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append(":");
        stringBuilder.append(this.packageName);
        return stringBuilder.toString();
    }

    @SafeParcelable.Constructor
    public ClientIdentity(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) @Nullable String string2) {
        this.uid = n;
        this.packageName = string2;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.uid);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)this.packageName, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ClientIdentity)) {
            return false;
        }
        object = (ClientIdentity)((Object)object);
        return ((ClientIdentity)((Object)object)).uid == this.uid && Objects.equal((Object)((ClientIdentity)((Object)object)).packageName, (Object)this.packageName);
    }
}

