/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public abstract class DataBufferRef {
    @KeepForSdk
    @NonNull
    protected final DataHolder mDataHolder;
    @KeepForSdk
    protected int mDataRow;
    private int zaa;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected double getDouble(@NonNull String column) {
        void var1_1;
        return this.mDataHolder.zaa((String)var1_1, this.mDataRow, this.zaa);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected float getFloat(@NonNull String column) {
        void var1_1;
        return this.mDataHolder.zab((String)var1_1, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    protected int getDataRow() {
        return this.mDataRow;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected int getInteger(@NonNull String column) {
        void var1_1;
        return this.mDataHolder.getInteger((String)var1_1, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mDataRow, this.zaa, this.mDataHolder});
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected long getLong(@NonNull String column) {
        void var1_1;
        return this.mDataHolder.getLong((String)var1_1, this.mDataRow, this.zaa);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @Nullable
    protected Uri parseUri(@NonNull String column) {
        void var1_1;
        String this_ = ((DataBufferRef)((Object)this_)).mDataHolder.getString((String)var1_1, ((DataBufferRef)((Object)this_)).mDataRow, ((DataBufferRef)((Object)this_)).zaa);
        if (this_ == null) {
            return null;
        }
        return Uri.parse((String)this_);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    protected String getString(@NonNull String column) {
        void var1_1;
        return this.mDataHolder.getString((String)var1_1, this.mDataRow, this.zaa);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public DataBufferRef(@NonNull DataHolder holder, int dataRow) {
        void var2_2;
        void var1_1;
        this.mDataHolder = (DataHolder)Preconditions.checkNotNull((Object)var1_1);
        this.zaa((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected void copyToBuffer(@NonNull String column, @NonNull CharArrayBuffer dataOut) {
        void var2_2;
        void var1_1;
        this.mDataHolder.zac((String)var1_1, this.mDataRow, this.zaa, (CharArrayBuffer)var2_2);
    }

    @KeepForSdk
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof DataBufferRef) {
            DataBufferRef dataBufferRef;
            dataBufferRef = dataBufferRef;
            return Objects.equal((Object)dataBufferRef.mDataRow, (Object)this.mDataRow) && Objects.equal((Object)dataBufferRef.zaa, (Object)this.zaa) && dataBufferRef.mDataHolder == this.mDataHolder;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected boolean getBoolean(@NonNull String column) {
        void var1_1;
        return this.mDataHolder.getBoolean((String)var1_1, this.mDataRow, this.zaa);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean hasColumn(@NonNull String column) {
        void var1_1;
        return this.mDataHolder.hasColumn((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected boolean hasNull(@NonNull String column) {
        void var1_1;
        return this.mDataHolder.hasNull((String)var1_1, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    public boolean isDataValid() {
        return !this.mDataHolder.isClosed();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    protected byte[] getByteArray(@NonNull String column) {
        void var1_1;
        return this.mDataHolder.getByteArray((String)var1_1, this.mDataRow, this.zaa);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void zaa(int n) {
        boolean bl = n >= 0 ? n < this.mDataHolder.getCount() : false;
        Preconditions.checkState((boolean)bl);
        this.mDataRow = n;
        this.zaa = this.mDataHolder.getWindowIndex(n);
    }
}

