/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaaj;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabf;
import com.google.android.gms.common.api.internal.zabg;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.api.internal.zabz;
import com.google.android.gms.common.api.internal.zaca;
import com.google.android.gms.common.api.internal.zat;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class zabi
implements zaca,
zau {
    private final Lock zai;
    private final Condition zaj;
    private final Context zak;
    private final GoogleApiAvailabilityLight zal;
    private final zabh zam;
    final Map zaa;
    final Map zab = new HashMap();
    @Nullable
    final ClientSettings zac;
    final Map zad;
    @Nullable
    final Api.AbstractClientBuilder zae;
    @NotOnlyInitialized
    private volatile zabf zan;
    @Nullable
    private ConnectionResult zao = null;
    int zaf;
    final zabe zag;
    final zabz zah;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult zab() {
        zabi zabi2;
        zabi2.zaq();
        while (zabi2.zan instanceof zaaw) {
            try {
                zabi2.zaj.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (zabi2.zan instanceof zaaj) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        zabi2 = zabi2.zao;
        if (zabi2 != null) {
            return zabi2;
        }
        return new ConnectionResult(13, null);
    }

    /*
     * Loose catch block
     */
    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult zac(long l, TimeUnit timeUnit) {
        zabi zabi2;
        zabi2.zaq();
        long l2 = timeUnit.toNanos(l);
        while (zabi2.zan instanceof zaaw) {
            long l3;
            if (l2 <= 0L) {
                zabi2.zar();
                zabi2 = new ConnectionResult(14, null);
                return zabi2;
            }
            l2 = l3 = zabi2.zaj.awaitNanos(l2);
        }
        if (zabi2.zan instanceof zaaj) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        zabi2 = zabi2.zao;
        if (zabi2 != null) {
            return zabi2;
        }
        return new ConnectionResult(13, null);
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return new ConnectionResult(15, null);
        }
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult zad(@NonNull Api object) {
        if (this.zaa.containsKey(object = ((Api)object).zab())) {
            if (((Api.Client)this.zaa.get(object)).isConnected()) {
                return ConnectionResult.RESULT_SUCCESS;
            }
            if (this.zab.containsKey(object)) {
                return (ConnectionResult)this.zab.get(object);
            }
        }
        return null;
    }

    @Override
    @GuardedBy(value="mLock")
    public final BaseImplementation.ApiMethodImpl zae(@NonNull BaseImplementation.ApiMethodImpl apiMethodImpl) {
        apiMethodImpl.zak();
        this.zan.zaa(apiMethodImpl);
        return apiMethodImpl;
    }

    @Override
    @GuardedBy(value="mLock")
    public final BaseImplementation.ApiMethodImpl zaf(@NonNull BaseImplementation.ApiMethodImpl apiMethodImpl) {
        apiMethodImpl.zak();
        return this.zan.zab(apiMethodImpl);
    }

    static /* bridge */ /* synthetic */ zabf zag(zabi zabi2) {
        return zabi2.zan;
    }

    static /* bridge */ /* synthetic */ Lock zah(zabi zabi2) {
        return zabi2.zai;
    }

    public zabi(Context context, zabe zabe2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map map, @Nullable ClientSettings clientSettings, Map map2, @Nullable Api.AbstractClientBuilder abstractClientBuilder, ArrayList arrayList, zabz zabz2) {
        this.zak = context;
        this.zai = lock;
        this.zal = googleApiAvailabilityLight;
        this.zaa = map;
        this.zac = clientSettings;
        this.zad = map2;
        this.zae = abstractClientBuilder;
        this.zag = zabe2;
        this.zah = zabz2;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((zat)arrayList.get(i)).zaa(this);
        }
        this.zam = new zabh(this, looper);
        this.zaj = lock.newCondition();
        this.zan = new zaax(this);
    }

    final void zai() {
        this.zai.lock();
        try {
            this.zag.zak();
            this.zan = new zaaj(this);
            this.zan.zad();
            this.zaj.signalAll();
        }
        catch (Throwable throwable) {
            this.zai.unlock();
            throw throwable;
        }
        this.zai.unlock();
    }

    final void zaj() {
        this.zai.lock();
        try {
            zabi zabi2 = this;
            this.zan = new zaaw(zabi2, this.zac, this.zad, zabi2.zal, this.zae, this.zai, this.zak);
            this.zan.zad();
            this.zaj.signalAll();
        }
        catch (Throwable throwable) {
            this.zai.unlock();
            throw throwable;
        }
        this.zai.unlock();
    }

    final void zak(@Nullable ConnectionResult connectionResult) {
        this.zai.lock();
        try {
            this.zao = connectionResult;
            this.zan = new zaax(this);
            this.zan.zad();
            this.zaj.signalAll();
        }
        catch (Throwable throwable) {
            this.zai.unlock();
            throw throwable;
        }
        this.zai.unlock();
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaq() {
        this.zan.zae();
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zar() {
        if (this.zan.zaj()) {
            this.zab.clear();
            return;
        }
    }

    @Override
    public final void zas(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        printWriter.append(string2).append("mState=").println(this.zan);
        Iterator iterator = this.zad.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = String.valueOf(string2);
            Api api = (Api)iterator.next();
            printWriter.append(string2).append(api.zad()).println(":");
            ((Api.Client)Preconditions.checkNotNull((Object)((Api.Client)this.zaa.get(api.zab())))).dump(string3.concat("  "), fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zat() {
        if (this.zan instanceof zaaj) {
            ((zaaj)this.zan).zaf();
            return;
        }
    }

    @Override
    public final void zau() {
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zai.lock();
        try {
            this.zan.zag(bundle);
        }
        catch (Throwable throwable) {
            this.zai.unlock();
            throw throwable;
        }
        this.zai.unlock();
    }

    @Override
    public final void zaa(@NonNull ConnectionResult connectionResult, @NonNull Api api, boolean bl) {
        this.zai.lock();
        try {
            this.zan.zah(connectionResult, api, bl);
        }
        catch (Throwable throwable) {
            this.zai.unlock();
            throw throwable;
        }
        this.zai.unlock();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zai.lock();
        try {
            this.zan.zai(n);
        }
        catch (Throwable throwable) {
            this.zai.unlock();
            throw throwable;
        }
        this.zai.unlock();
    }

    final void zal(zabg zabg2) {
        zabg2 = this.zam.obtainMessage(1, zabg2);
        this.zam.sendMessage((Message)zabg2);
    }

    final void zam(RuntimeException runtimeException) {
        runtimeException = this.zam.obtainMessage(2, runtimeException);
        this.zam.sendMessage((Message)runtimeException);
    }

    @Override
    public final boolean zaw() {
        return this.zan instanceof zaaj;
    }

    @Override
    public final boolean zax() {
        return this.zan instanceof zaaw;
    }

    @Override
    public final boolean zay(SignInConnectionListener signInConnectionListener) {
        return false;
    }
}

