/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.OptionalPendingResultImpl;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.zaf;
import com.google.android.gms.common.api.zag;
import com.google.android.gms.common.api.zah;
import com.google.android.gms.common.internal.Preconditions;

public final class PendingResults {
    @NonNull
    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(@NonNull R result) {
        R r;
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
        zah<R> zah2 = new zah<R>(null);
        zah2.setResult(r);
        return new OptionalPendingResultImpl(zah2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(@NonNull R result, @NonNull GoogleApiClient apiClient) {
        R r;
        void var1_1;
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
        zah<R> zah2 = new zah<R>((GoogleApiClient)var1_1);
        zah2.setResult(r);
        return new OptionalPendingResultImpl(zah2);
    }

    @NonNull
    public static PendingResult<Status> canceledPendingResult() {
        StatusPendingResult statusPendingResult = new StatusPendingResult(Looper.getMainLooper());
        statusPendingResult.cancel();
        return statusPendingResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static <R extends Result> PendingResult<R> canceledPendingResult(@NonNull R result) {
        R r;
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
        boolean bl = r.getStatus().getStatusCode() == 16;
        Preconditions.checkArgument((boolean)bl, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zaf zaf2 = new zaf(r);
        zaf2.cancel();
        return zaf2;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <R extends Result> PendingResult<R> immediateFailedResult(@NonNull R result, @NonNull GoogleApiClient apiClient) {
        void var1_1;
        R r;
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
        Preconditions.checkArgument((boolean)(r.getStatus().isSuccess() ^ true), (Object)"Status code must not be SUCCESS");
        zag<R> zag2 = new zag<R>((GoogleApiClient)var1_1, r);
        zag2.setResult(r);
        return zag2;
    }

    @NonNull
    public static PendingResult<Status> immediatePendingResult(@NonNull Status result) {
        Status status;
        Preconditions.checkNotNull((Object)result, (Object)"Result must not be null");
        StatusPendingResult statusPendingResult = new StatusPendingResult(Looper.getMainLooper());
        statusPendingResult.setResult(status);
        return statusPendingResult;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static PendingResult<Status> immediatePendingResult(@NonNull Status result, @NonNull GoogleApiClient apiClient) {
        Status status;
        void var1_1;
        Preconditions.checkNotNull((Object)result, (Object)"Result must not be null");
        StatusPendingResult statusPendingResult = new StatusPendingResult((GoogleApiClient)var1_1);
        statusPendingResult.setResult(status);
        return statusPendingResult;
    }

    private PendingResults() {
    }
}

