/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.moduleinstall.internal;

import android.app.Activity;
import android.content.Context;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.OptionalModuleApi;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.moduleinstall.InstallStatusListener;
import com.google.android.gms.common.moduleinstall.ModuleAvailabilityResponse;
import com.google.android.gms.common.moduleinstall.ModuleInstallClient;
import com.google.android.gms.common.moduleinstall.ModuleInstallIntentResponse;
import com.google.android.gms.common.moduleinstall.ModuleInstallRequest;
import com.google.android.gms.common.moduleinstall.ModuleInstallResponse;
import com.google.android.gms.common.moduleinstall.internal.ApiFeatureRequest;
import com.google.android.gms.common.moduleinstall.internal.zaab;
import com.google.android.gms.common.moduleinstall.internal.zai;
import com.google.android.gms.common.moduleinstall.internal.zaj;
import com.google.android.gms.common.moduleinstall.internal.zak;
import com.google.android.gms.common.moduleinstall.internal.zal;
import com.google.android.gms.common.moduleinstall.internal.zam;
import com.google.android.gms.common.moduleinstall.internal.zan;
import com.google.android.gms.common.moduleinstall.internal.zao;
import com.google.android.gms.common.moduleinstall.internal.zap;
import com.google.android.gms.internal.base.zav;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zay
extends GoogleApi
implements ModuleInstallClient {
    private static final Api.ClientKey zac;
    private static final Api.AbstractClientBuilder zad;
    private static final Api zae;
    public static final /* synthetic */ int zab;

    @Override
    public final Task<ModuleAvailabilityResponse> areModulesAvailable(OptionalModuleApi ... object) {
        if (((ApiFeatureRequest)((Object)(object = zay.zad(false, (OptionalModuleApi[])object)))).getApiFeatures().isEmpty()) {
            Object object2 = new ModuleAvailabilityResponse(true, 0);
            return Tasks.forResult((Object)object2);
        }
        TaskApiCall.Builder builder = TaskApiCall.builder();
        Object object3 = new Feature[]{zav.zaa};
        builder.setFeatures((Feature)object3);
        builder.setMethodKey(27301);
        builder.setAutoResolveMissingFeatures(false);
        object3 = new zap((zay)object2, (ApiFeatureRequest)((Object)object));
        builder.run(object3);
        return ((GoogleApi)object2).doRead(builder.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Task<Void> deferredInstall(OptionalModuleApi ... object) {
        if (((ApiFeatureRequest)((Object)(object = zay.zad(false, (OptionalModuleApi[])object)))).getApiFeatures().isEmpty()) {
            return Tasks.forResult(null);
        }
        TaskApiCall.Builder builder = TaskApiCall.builder();
        Feature[] featureArray = new Feature[]{zav.zaa};
        builder.setFeatures(featureArray);
        builder.setMethodKey(27302);
        builder.setAutoResolveMissingFeatures(false);
        zan zan2 = new zan((zay)this, (ApiFeatureRequest)((Object)object));
        builder.run(zan2);
        return this.doRead(builder.build());
    }

    @Override
    public final Task<ModuleInstallIntentResponse> getInstallModulesIntent(OptionalModuleApi ... object) {
        if (((ApiFeatureRequest)((Object)(object = zay.zad(true, (OptionalModuleApi[])object)))).getApiFeatures().isEmpty()) {
            Object object2 = new ModuleInstallIntentResponse(null);
            return Tasks.forResult((Object)object2);
        }
        TaskApiCall.Builder builder = TaskApiCall.builder();
        Object object3 = new Feature[]{zav.zaa};
        builder.setFeatures((Feature)object3);
        builder.setMethodKey(27307);
        object3 = new zam((zay)object2, (ApiFeatureRequest)((Object)object));
        builder.run(object3);
        return ((GoogleApi)object2).doRead(builder.build());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<ModuleInstallResponse> installModules(ModuleInstallRequest object) {
        void var1_4;
        Object object2;
        ApiFeatureRequest apiFeatureRequest = ApiFeatureRequest.fromModuleInstallRequest((ModuleInstallRequest)object);
        Object object3 = ((ModuleInstallRequest)object).getListener();
        Object object4 = ((ModuleInstallRequest)object).getListenerExecutor();
        boolean bl = ((ModuleInstallRequest)object).zaa();
        if (apiFeatureRequest.getApiFeatures().isEmpty()) {
            object2 = new ModuleInstallResponse(0);
            return Tasks.forResult((Object)object2);
        }
        if (object3 == null) {
            TaskApiCall.Builder builder = TaskApiCall.builder();
            object3 = new Feature[]{zav.zaa};
            builder.setFeatures((Feature[])object3);
            builder.setAutoResolveMissingFeatures(bl);
            builder.setMethodKey(27304);
            object3 = new zao((zay)object2, apiFeatureRequest);
            builder.run(object3);
            return ((GoogleApi)object2).doRead(builder.build());
        }
        Preconditions.checkNotNull((Object)object3);
        if (object4 == null) {
            ListenerHolder<Feature[]> listenerHolder = ((GoogleApi)object2).registerListener(object3, InstallStatusListener.class.getSimpleName());
        } else {
            ListenerHolder<Feature[]> listenerHolder = ListenerHolders.createListenerHolder(object3, (Executor)object4, InstallStatusListener.class.getSimpleName());
        }
        object4 = new zaab((ListenerHolder)var1_4);
        AtomicReference atomicReference = new AtomicReference();
        zai zai2 = new zai((zay)object2, atomicReference, (InstallStatusListener)object3, apiFeatureRequest, (zaab)object4);
        zaj zaj2 = new zaj((zay)object2, (zaab)object4);
        object3 = RegistrationMethods.builder();
        ((RegistrationMethods.Builder)object3).withHolder(var1_4);
        Feature[] featureArray = new Feature[]{zav.zaa};
        ((RegistrationMethods.Builder)object3).setFeatures(featureArray);
        ((RegistrationMethods.Builder)object3).setAutoResolveMissingFeatures(bl);
        ((RegistrationMethods.Builder)object3).register(zai2);
        ((RegistrationMethods.Builder)object3).unregister(zaj2);
        ((RegistrationMethods.Builder)object3).setMethodKey(27305);
        RegistrationMethods registrationMethods = ((RegistrationMethods.Builder)object3).build();
        object2 = ((GoogleApi)object2).doRegisterEventListener(registrationMethods);
        zak zak2 = new zak(atomicReference);
        return object2.onSuccessTask((SuccessContinuation)zak2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Task<Void> releaseModules(OptionalModuleApi ... object) {
        if (((ApiFeatureRequest)((Object)(object = zay.zad(false, (OptionalModuleApi[])object)))).getApiFeatures().isEmpty()) {
            return Tasks.forResult(null);
        }
        TaskApiCall.Builder builder = TaskApiCall.builder();
        Feature[] featureArray = new Feature[]{zav.zaa};
        builder.setFeatures(featureArray);
        builder.setMethodKey(27303);
        builder.setAutoResolveMissingFeatures(false);
        zal zal2 = new zal((zay)this, (ApiFeatureRequest)((Object)object));
        builder.run(zal2);
        return this.doRead(builder.build());
    }

    @Override
    public final Task<Boolean> unregisterListener(InstallStatusListener installStatusListener) {
        return this.doUnregisterEventListener(ListenerHolders.createListenerKey(installStatusListener, InstallStatusListener.class.getSimpleName()), 27306);
    }

    static {
        Api api = new Api();
        zac = api;
        api = new Api();
        zad = api;
        zae = api = new Api("ModuleInstall.API", zad, zac);
    }

    public zay(Activity activity) {
        super(activity, zae, Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zay(Context context) {
        super(context, zae, Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    /*
     * Enabled aggressive block sorting
     */
    static final ApiFeatureRequest zad(boolean bl, OptionalModuleApi ... optionalModuleApiArray) {
        Preconditions.checkNotNull((Object)optionalModuleApiArray, (Object)"Requested APIs must not be null.");
        int n = optionalModuleApiArray.length;
        int n2 = n > 0 ? 1 : 0;
        Preconditions.checkArgument(n2 != 0, (Object)"Please provide at least one OptionalModuleApi.");
        n2 = 0;
        while (n2 < n) {
            Preconditions.checkNotNull((Object)optionalModuleApiArray[n2], (Object)"Requested API must not be null.");
            ++n2;
        }
        return ApiFeatureRequest.zaa(Arrays.asList(optionalModuleApiArray), bl);
    }
}

