/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Handler;
import android.os.IInterface;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zah;
import com.google.android.gms.common.internal.zai;
import com.google.android.gms.common.internal.zaj;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

@KeepForSdk
public abstract class GmsClient<T extends IInterface>
extends BaseGmsClient<T>
implements Api.Client,
zaj {
    private final ClientSettings zaa;
    private final Set<Scope> zab;
    @Nullable
    private final Account zac;

    @VisibleForTesting
    @KeepForSdk
    protected GmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Handler handler, int n, @RecentlyNonNull ClientSettings clientSettings) {
        super(context, handler, GmsClientSupervisor.getInstance((Context)context), (GoogleApiAvailabilityLight)GoogleApiAvailability.getInstance(), n, null, null);
        this.zaa = (ClientSettings)Preconditions.checkNotNull((Object)clientSettings);
        this.zac = clientSettings.getAccount();
        this.zab = this.zaa(clientSettings.getAllRequestedScopes());
    }

    @KeepForSdk
    protected GmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, int n, @RecentlyNonNull ClientSettings clientSettings, @RecentlyNonNull ConnectionCallbacks connectionCallbacks, @RecentlyNonNull OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, (ConnectionCallbacks)Preconditions.checkNotNull((Object)connectionCallbacks), (OnConnectionFailedListener)Preconditions.checkNotNull((Object)onConnectionFailedListener));
    }

    @Deprecated
    @KeepForSdk
    protected GmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, int n, @RecentlyNonNull ClientSettings clientSettings, @RecentlyNonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks, @RecentlyNonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, n, clientSettings, (ConnectionCallbacks)connectionCallbacks, (OnConnectionFailedListener)onConnectionFailedListener);
    }

    @KeepForSdk
    protected GmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, int n, @RecentlyNonNull ClientSettings clientSettings) {
        this(context, looper, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    protected GmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, @RecentlyNonNull GmsClientSupervisor gmsClientSupervisor, @RecentlyNonNull GoogleApiAvailability googleApiAvailability, int n, @RecentlyNonNull ClientSettings clientSettings, @Nullable ConnectionCallbacks object, @Nullable OnConnectionFailedListener object2) {
        Object object3;
        object = object == null ? null : (object3 = new zah((ConnectionCallbacks)object));
        object2 = object2 == null ? null : (object3 = new zai((OnConnectionFailedListener)object2));
        super(context, looper, gmsClientSupervisor, (GoogleApiAvailabilityLight)googleApiAvailability, n, (BaseGmsClient.BaseConnectionCallbacks)object, (BaseGmsClient.BaseOnConnectionFailedListener)object2, clientSettings.zab());
        this.zaa = clientSettings;
        this.zac = clientSettings.getAccount();
        this.zab = this.zaa(clientSettings.getAllRequestedScopes());
    }

    @NonNull
    @KeepForSdk
    protected Set<Scope> validateScopes(@RecentlyNonNull Set<Scope> set) {
        return set;
    }

    @RecentlyNullable
    public final Account getAccount() {
        return this.zac;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected final ClientSettings getClientSettings() {
        return this.zaa;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected final Set<Scope> getScopes() {
        return this.zab;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @KeepForSdk
    @NonNull
    public Set<Scope> getScopesForConnectionlessNonSignIn() {
        if (!this.requiresSignIn()) return Collections.emptySet();
        return ((GmsClient)((Object)this)).zab;
    }

    @Override
    @KeepForSdk
    @RecentlyNonNull
    public Feature[] getRequiredFeatures() {
        return new Feature[0];
    }

    private final Set<Scope> zaa(@NonNull Set<Scope> set) {
        Object object = ((GmsClient)object).validateScopes(set);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            if (set.contains((Scope)iterator.next())) continue;
            object = new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
            throw object;
        }
        return object;
    }
}

