/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.view.View;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.collection.ArraySet;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zab;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@VisibleForTesting
@KeepForSdk
public final class ClientSettings {
    @Nullable
    private final Account zaa;
    private final Set<Scope> zab;
    private final Set<Scope> zac;
    private final Map<Api<?>, zab> zad;
    private final int zae;
    @Nullable
    private final View zaf;
    private final String zag;
    private final String zah;
    private final SignInOptions zai;
    private Integer zaj;

    @KeepForSdk
    @RecentlyNonNull
    public static ClientSettings createDefault(@RecentlyNonNull Context context) {
        GoogleApiClient.Builder builder = new GoogleApiClient.Builder(context);
        return builder.buildClientSettings();
    }

    @KeepForSdk
    public ClientSettings(@RecentlyNonNull Account account, @RecentlyNonNull Set<Scope> set, @RecentlyNonNull Map<Api<?>, zab> map, int n, @Nullable View view, @RecentlyNonNull String string2, @RecentlyNonNull String string3, @Nullable SignInOptions signInOptions) {
        this(account, set, map, n, view, string2, string3, signInOptions, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ClientSettings(@Nullable Account object, @RecentlyNonNull Set<Scope> iterator, @RecentlyNonNull Map<Api<?>, zab> map, int n, @Nullable View view, @RecentlyNonNull String string2, @RecentlyNonNull String string3, @Nullable SignInOptions signInOptions, boolean bl) {
        this.zaa = object;
        object = iterator == null ? Collections.emptySet() : Collections.unmodifiableSet(iterator);
        this.zab = object;
        object = map == null ? Collections.emptyMap() : map;
        this.zad = object;
        this.zaf = view;
        this.zae = n;
        this.zag = string2;
        this.zah = string3;
        object = signInOptions == null ? SignInOptions.zaa : signInOptions;
        this.zai = object;
        object = new HashSet(this.zab);
        iterator = this.zad.values().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.zac = Collections.unmodifiableSet(object);
                return;
            }
            object.addAll(iterator.next().zaa);
        }
    }

    @Deprecated
    @RecentlyNullable
    @KeepForSdk
    public String getAccountName() {
        ClientSettings clientSettings = clientSettings.zaa;
        if (clientSettings != null) {
            return ((Account)clientSettings).name;
        }
        return null;
    }

    @RecentlyNullable
    @KeepForSdk
    public Account getAccount() {
        return this.zaa;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Account getAccountOrDefault() {
        ClientSettings clientSettings = clientSettings.zaa;
        if (clientSettings != null) {
            return clientSettings;
        }
        clientSettings = new Account("<<default account>>", "com.google");
        return clientSettings;
    }

    @KeepForSdk
    public int getGravityForPopups() {
        return this.zae;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Set<Scope> getRequiredScopes() {
        return this.zab;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Set<Scope> getAllRequestedScopes() {
        return this.zac;
    }

    @KeepForSdk
    @RecentlyNonNull
    public String getRealClientPackageName() {
        return this.zag;
    }

    @RecentlyNullable
    @KeepForSdk
    public View getViewForPopups() {
        return this.zaf;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Set<Scope> getApplicableScopes(@RecentlyNonNull Api<?> object) {
        if ((object = this.zad.get(object)) == null || ((zab)object).zaa.isEmpty()) {
            return this.zab;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zab);
        hashSet.addAll(((zab)object).zaa);
        return hashSet;
    }

    @RecentlyNonNull
    public final Map<Api<?>, zab> zaa() {
        return this.zad;
    }

    @RecentlyNullable
    public final String zab() {
        return this.zah;
    }

    @RecentlyNonNull
    public final SignInOptions zac() {
        return this.zai;
    }

    @RecentlyNullable
    public final Integer zad() {
        return this.zaj;
    }

    public final void zae(@RecentlyNonNull Integer n) {
        this.zaj = n;
    }

    @KeepForSdk
    public static final class Builder {
        @Nullable
        private Account zaa;
        private ArraySet<Scope> zab;
        private String zac;
        private String zad;
        private SignInOptions zae = SignInOptions.zaa;

        @KeepForSdk
        @RecentlyNonNull
        public Builder setRealClientPackageName(@RecentlyNonNull String string2) {
            this.zac = string2;
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public ClientSettings build() {
            ClientSettings clientSettings = new ClientSettings(this.zaa, (Set<Scope>)this.zab, null, 0, null, this.zac, this.zad, this.zae, false);
            return clientSettings;
        }

        @RecentlyNonNull
        public final Builder zaa(@Nullable Account account) {
            this.zaa = account;
            return this;
        }

        @RecentlyNonNull
        public final Builder zab(@RecentlyNonNull Collection<Scope> collection) {
            if (this.zab == null) {
                ArraySet arraySet;
                this.zab = arraySet = new ArraySet();
            }
            this.zab.addAll(collection);
            return this;
        }

        @RecentlyNonNull
        public final Builder zac(@RecentlyNonNull String string2) {
            this.zad = string2;
            return this;
        }
    }
}

