/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.images.zaa;
import com.google.android.gms.common.images.zab;
import com.google.android.gms.common.images.zae;
import com.google.android.gms.common.images.zaf;
import com.google.android.gms.common.images.zag;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.internal.base.zak;
import com.google.android.gms.internal.base.zao;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public final class ImageManager {
    private static final Object zaa;
    private static HashSet<Uri> zab;
    private static ImageManager zac;
    private final Context zad;
    private final Handler zae;
    private final ExecutorService zaf;
    private final zak zag;
    private final Map<zag, ImageReceiver> zah;
    private final Map<Uri, ImageReceiver> zai;
    private final Map<Uri, Long> zaj;

    @RecentlyNonNull
    public static ImageManager create(@RecentlyNonNull Context context) {
        if (zac == null) {
            ImageManager imageManager;
            zac = imageManager = new ImageManager(context, false);
        }
        return zac;
    }

    private ImageManager(Context object, boolean bl) {
        this.zad = object.getApplicationContext();
        super(Looper.getMainLooper());
        this.zae = object;
        this.zaf = zao.zaa().zaa(4, 2);
        super();
        this.zag = object;
        super();
        this.zah = object;
        super();
        this.zai = object;
        super();
        this.zaj = object;
    }

    public void loadImage(@RecentlyNonNull ImageView imageView, @RecentlyNonNull Uri uri) {
        zae zae2 = new zae(imageView, uri);
        this.zaa(zae2);
    }

    public void loadImage(@RecentlyNonNull ImageView imageView, int n) {
        zae zae2 = new zae(imageView, n);
        this.zaa(zae2);
    }

    public void loadImage(@RecentlyNonNull ImageView imageView, @RecentlyNonNull Uri uri, int n) {
        zae zae2 = new zae(imageView, uri);
        zae2.zab = n;
        this.zaa(zae2);
    }

    public void loadImage(@RecentlyNonNull OnImageLoadedListener onImageLoadedListener, @RecentlyNonNull Uri uri) {
        zaf zaf2 = new zaf(onImageLoadedListener, uri);
        this.zaa(zaf2);
    }

    public void loadImage(@RecentlyNonNull OnImageLoadedListener onImageLoadedListener, @RecentlyNonNull Uri uri, int n) {
        zaf zaf2 = new zaf(onImageLoadedListener, uri);
        zaf2.zab = n;
        this.zaa(zaf2);
    }

    static {
        HashSet hashSet = new HashSet();
        zaa = hashSet;
        hashSet = new HashSet();
        zab = hashSet;
    }

    public final void zaa(zag zag2) {
        Asserts.checkMainThread((String)"ImageManager.loadImage() must be called in the main thread");
        zab zab2 = new zab(this, zag2);
        zab2.run();
    }

    static /* synthetic */ Map zab(ImageManager imageManager) {
        return imageManager.zah;
    }

    static /* synthetic */ zak zad(ImageManager imageManager) {
        return imageManager.zag;
    }

    static /* synthetic */ Map zae(ImageManager imageManager) {
        return imageManager.zaj;
    }

    static /* synthetic */ Map zaf(ImageManager imageManager) {
        return imageManager.zai;
    }

    static /* synthetic */ Object zag() {
        return zaa;
    }

    static /* synthetic */ HashSet zah() {
        return zab;
    }

    static /* synthetic */ Handler zaj(ImageManager imageManager) {
        return imageManager.zae;
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri zab;
        private final ArrayList<zag> zac;

        ImageReceiver(Uri uri) {
            super(Looper.getMainLooper());
            super((Handler)ImageManager.this);
            this.zab = uri;
            super();
            this.zac = ImageManager.this;
        }

        public final void onReceiveResult(int n, Bundle object) {
            Parcelable parcelable = object.getParcelable("com.google.android.gms.extra.fileDescriptor");
            parcelable = (ParcelFileDescriptor)parcelable;
            object = ImageManager.this;
            object = ((ImageManager)object).zaf;
            zaa zaa2 = new zaa(ImageManager.this, this.zab, (ParcelFileDescriptor)parcelable);
            object.execute(zaa2);
        }

        public final void zaa(zag zag2) {
            Asserts.checkMainThread((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zac.add(zag2);
        }

        public final void zab(zag zag2) {
            Asserts.checkMainThread((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zac.remove(zag2);
        }

        public final void zac() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.setPackage("com.google.android.gms");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.zab);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.zad.sendBroadcast(intent);
        }

        static /* synthetic */ ArrayList zad(ImageReceiver imageReceiver) {
            return imageReceiver.zac;
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(@RecentlyNonNull Uri var1, @Nullable Drawable var2, boolean var3);
    }
}

