/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.AbstractDataBuffer;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@KeepForSdk
public class DataBufferSafeParcelable<T extends SafeParcelable>
extends AbstractDataBuffer<T> {
    private static final String[] zaa;
    private final Parcelable.Creator<T> zab;

    @KeepForSdk
    public DataBufferSafeParcelable(@RecentlyNonNull DataHolder dataHolder, @RecentlyNonNull Parcelable.Creator<T> creator) {
        super(dataHolder);
        this.zab = creator;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static DataHolder.Builder buildDataHolder() {
        return DataHolder.builder(zaa);
    }

    @KeepForSdk
    public static <T extends SafeParcelable> void addValue(@RecentlyNonNull DataHolder.Builder builder, @RecentlyNonNull T object) {
        Parcel parcel = Parcel.obtain();
        object.writeToParcel(parcel, 0);
        object = new Object();
        object.put("data", parcel.marshall());
        builder.withRow((ContentValues)object);
        parcel.recycle();
    }

    @Override
    @KeepForSdk
    @RecentlyNonNull
    public T get(int n) {
        DataHolder dataHolder = (DataHolder)Preconditions.checkNotNull((Object)safeParcelable.mDataHolder);
        byte[] byArray = dataHolder.getByteArray("data", n, dataHolder.getWindowIndex(n));
        dataHolder = Parcel.obtain();
        dataHolder.unmarshall(byArray, 0, byArray.length);
        dataHolder.setDataPosition(0);
        SafeParcelable safeParcelable = safeParcelable.zab;
        safeParcelable = safeParcelable.createFromParcel((Parcel)dataHolder);
        safeParcelable = safeParcelable;
        dataHolder.recycle();
        return (T)safeParcelable;
    }

    static {
        String[] stringArray = new String[]{"data"};
        zaa = stringArray;
    }
}

