/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaag;
import com.google.android.gms.common.api.internal.zaar;
import com.google.android.gms.common.api.internal.zaas;
import com.google.android.gms.common.api.internal.zaaz;
import com.google.android.gms.common.api.internal.zaba;
import com.google.android.gms.common.api.internal.zabb;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabt;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zas;
import com.google.android.gms.common.api.internal.zat;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zae;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class zabd
implements zabu,
zat {
    private final Lock zai;
    private final Condition zaj;
    private final Context zak;
    private final GoogleApiAvailabilityLight zal;
    private final zabc zam;
    final Map<Api.AnyClientKey<?>, Api.Client> zaa;
    final Map<Api.AnyClientKey<?>, ConnectionResult> zab;
    @Nullable
    final ClientSettings zac;
    final Map<Api<?>, Boolean> zad;
    @Nullable
    final Api.AbstractClientBuilder<? extends zae, SignInOptions> zae;
    @NotOnlyInitialized
    private volatile zaba zan;
    @Nullable
    private ConnectionResult zao;
    int zaf;
    final zaaz zag;
    final zabt zah;

    public zabd(Context context, zaaz zaaz2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, @Nullable ClientSettings clientSettings, Map<Api<?>, Boolean> map2, @Nullable Api.AbstractClientBuilder<? extends zae, SignInOptions> abstractClientBuilder, ArrayList<zas> arrayList, zabt zabt2) {
        Object object;
        HashMap hashMap = new HashMap();
        this.zab = hashMap;
        this.zao = null;
        this.zak = context;
        this.zai = lock;
        this.zal = googleApiAvailabilityLight;
        this.zaa = map;
        this.zac = clientSettings;
        this.zad = map2;
        this.zae = abstractClientBuilder;
        this.zag = zaaz2;
        this.zah = zabt2;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((zas)arrayList.get(i)).zaa(this);
        }
        this.zam = object = new zabc(this, looper);
        this.zaj = lock.newCondition();
        super(this);
        this.zan = object;
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T zab(@NonNull T t) {
        t.zak();
        this.zan.zab(t);
        return t;
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T zac(@NonNull T t) {
        t.zak();
        return this.zan.zac(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zae() {
        this.zan.zae();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult zaf() {
        zabd zabd2;
        zabd2.zae();
        while (zabd2.zan instanceof zaar) {
            try {
                zabd2.zaj.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (zabd2.zan instanceof zaag) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        zabd2 = zabd2.zao;
        if (zabd2 == null) return new ConnectionResult(13, null);
        return zabd2;
    }

    /*
     * Loose catch block
     */
    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult zag(long l, TimeUnit timeUnit) {
        zabd zabd2;
        zabd2.zae();
        long l2 = timeUnit.toNanos(l);
        while (zabd2.zan instanceof zaar) {
            long l3;
            if (l2 <= 0L) {
                zabd2.zah();
                zabd2 = new ConnectionResult(14, null);
                return zabd2;
            }
            l2 = l3 = zabd2.zaj.awaitNanos(l2);
        }
        if (zabd2.zan instanceof zaag) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        zabd2 = zabd2.zao;
        if (zabd2 != null) {
            return zabd2;
        }
        zabd2 = new ConnectionResult(13, null);
        return zabd2;
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            zabd2 = new ConnectionResult(15, null);
            return zabd2;
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zah() {
        if (this.zan.zad()) {
            this.zab.clear();
            return;
        }
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult zad(@NonNull Api<?> object) {
        if (this.zaa.containsKey(object = ((Api)object).zac())) {
            if (this.zaa.get(object).isConnected()) {
                return ConnectionResult.RESULT_SUCCESS;
            }
            if (this.zab.containsKey(object)) {
                return this.zab.get(object);
            }
        }
        return null;
    }

    final void zao() {
        this.zai.lock();
        try {
            zaar zaar2 = new zaar(this, this.zac, this.zad, this.zal, this.zae, this.zai, this.zak);
            this.zan = zaar2;
            this.zan.zaa();
            this.zaj.signalAll();
        }
        finally {
            this.zai.unlock();
        }
    }

    final void zap() {
        this.zai.lock();
        try {
            this.zag.zad();
            zaag zaag2 = new zaag(this);
            this.zan = zaag2;
            this.zan.zaa();
            this.zaj.signalAll();
        }
        finally {
            this.zai.unlock();
        }
    }

    final void zaq(@Nullable ConnectionResult object) {
        this.zai.lock();
        try {
            this.zao = object;
            object = new zaas(this);
            this.zan = object;
            this.zan.zaa();
            this.zaj.signalAll();
        }
        finally {
            this.zai.unlock();
        }
    }

    @Override
    public final boolean zai() {
        return this.zan instanceof zaag;
    }

    @Override
    public final boolean zaj() {
        return this.zan instanceof zaar;
    }

    @Override
    public final boolean zak(SignInConnectionListener signInConnectionListener) {
        return false;
    }

    @Override
    public final void zam() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zal() {
        if (this.zan instanceof zaag) {
            ((zaag)this.zan).zai();
            return;
        }
    }

    @Override
    public final void zaa(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zai.lock();
        try {
            this.zan.zag(connectionResult, api, bl);
        }
        finally {
            this.zai.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zai.lock();
        try {
            this.zan.zaf(bundle);
        }
        finally {
            this.zai.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zai.lock();
        try {
            this.zan.zah(n);
        }
        finally {
            this.zai.unlock();
        }
    }

    final void zar(zabb zabb2) {
        zabc zabc2 = this.zam;
        zabb2 = zabc2.obtainMessage(1, zabb2);
        this.zam.sendMessage((Message)zabb2);
    }

    final void zas(RuntimeException runtimeException) {
        zabc zabc2 = this.zam;
        runtimeException = zabc2.obtainMessage(2, runtimeException);
        this.zam.sendMessage((Message)runtimeException);
    }

    @Override
    public final void zan(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zan);
        for (Api<?> api : this.zad.keySet()) {
            printWriter.append(string2).append(api.zad()).println(":");
            ((Api.Client)Preconditions.checkNotNull((Object)this.zaa.get(api.zac()))).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zat(zabd zabd2) {
        return zabd2.zai;
    }

    static /* synthetic */ zaba zau(zabd zabd2) {
        return zabd2.zan;
    }
}

