/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.zaah;
import com.google.android.gms.common.api.internal.zaai;
import com.google.android.gms.common.api.internal.zaal;
import com.google.android.gms.common.api.internal.zaam;
import com.google.android.gms.common.api.internal.zaap;
import com.google.android.gms.common.api.internal.zaba;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zab;
import com.google.android.gms.common.internal.zav;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.zak;
import com.google.android.gms.signin.zae;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaar
implements zaba {
    private final zabd zaa;
    private final Lock zab;
    private final Context zac;
    private final GoogleApiAvailabilityLight zad;
    @Nullable
    private ConnectionResult zae;
    private int zaf;
    private int zag = 0;
    private int zah;
    private final Bundle zai;
    private final Set<Api.AnyClientKey> zaj;
    @Nullable
    private zae zak;
    private boolean zal;
    private boolean zam;
    private boolean zan;
    @Nullable
    private IAccountAccessor zao;
    private boolean zap;
    private boolean zaq;
    @Nullable
    private final ClientSettings zar;
    private final Map<Api<?>, Boolean> zas;
    @Nullable
    private final Api.AbstractClientBuilder<? extends zae, SignInOptions> zat;
    private final ArrayList<Future<?>> zau;

    public zaar(zabd zabd2, @Nullable ClientSettings clientSettings, Map<Api<?>, Boolean> map, GoogleApiAvailabilityLight googleApiAvailabilityLight, @Nullable Api.AbstractClientBuilder<? extends zae, SignInOptions> abstractClientBuilder, Lock lock, Context context) {
        Object object;
        this.zai = object = new Bundle();
        this.zaj = object;
        super();
        this.zau = object;
        this.zaa = zabd2;
        this.zar = clientSettings;
        this.zas = map;
        this.zad = googleApiAvailabilityLight;
        this.zat = abstractClientBuilder;
        this.zab = lock;
        this.zac = context;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @GuardedBy(value="mLock")
    public final void zaa() {
        Object object;
        Object object2;
        this.zaa.zab.clear();
        this.zam = false;
        this.zae = null;
        this.zag = 0;
        this.zal = true;
        this.zan = false;
        this.zap = false;
        HashMap<Api.Client, zaai> hashMap = new HashMap<Api.Client, zaai>();
        Object object3 = this.zas.keySet().iterator();
        boolean bl = false;
        while (object3.hasNext()) {
            object2 = object3.next();
            object = (Api.Client)Preconditions.checkNotNull((Object)this.zaa.zaa.get(((Api)object2).zac()));
            boolean bl2 = ((Api)object2).zaa().getPriority() == 1;
            bl |= bl2;
            bl2 = this.zas.get(object2);
            if (object.requiresSignIn()) {
                this.zam = true;
                if (bl2) {
                    this.zaj.add(((Api)object2).zac());
                } else {
                    this.zal = false;
                }
            }
            zaai zaai2 = new zaai(this, (Api<?>)object2, bl2);
            hashMap.put((Api.Client)object, zaai2);
        }
        if (bl) {
            this.zam = false;
        }
        if (this.zam) {
            Preconditions.checkNotNull((Object)this.zar);
            Preconditions.checkNotNull(this.zat);
            this.zar.zae(System.identityHashCode(this.zaa.zag));
            zaap zaap2 = new zaap(this, null);
            Api.AbstractClientBuilder<? extends zae, SignInOptions> abstractClientBuilder = this.zat;
            object3 = this.zac;
            object2 = this.zaa;
            object2 = ((zabd)object2).zag;
            object2 = ((GoogleApiClient)object2).getLooper();
            object = this.zar;
            this.zak = abstractClientBuilder.buildClient((Context)object3, (Looper)object2, (ClientSettings)object, ((ClientSettings)object).zac(), zaap2, zaap2);
        }
        this.zah = this.zaa.zaa.size();
        ArrayList<Future<?>> arrayList = this.zau;
        ExecutorService executorService = zabe.zaa();
        object3 = new zaal(this, hashMap);
        arrayList.add(executorService.submit((Runnable)object3));
    }

    @GuardedBy(value="mLock")
    private final boolean zaz() {
        int n;
        this.zah = n = this.zah + -1;
        if (n > 0) {
            return false;
        }
        if (n < 0) {
            Log.w((String)"GACConnecting", (String)this.zaa.zag.zae());
            Exception exception = new Exception();
            Log.wtf((String)"GACConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)exception);
            exception = new ConnectionResult(8, null);
            this.zaF((ConnectionResult)exception);
            return false;
        }
        ConnectionResult connectionResult = this.zae;
        if (connectionResult != null) {
            this.zaa.zaf = this.zaf;
            this.zaF(connectionResult);
            return false;
        }
        return true;
    }

    @GuardedBy(value="mLock")
    private final void zaA() {
        if (this.zah != 0) {
            return;
        }
        if (!this.zam || this.zan) {
            ArrayList<Api.Client> arrayList = new ArrayList<Api.Client>();
            this.zag = 1;
            this.zah = this.zaa.zaa.size();
            for (Api.AnyClientKey<?> anyClientKey : this.zaa.zaa.keySet()) {
                if (this.zaa.zab.containsKey(anyClientKey)) {
                    if (!this.zaz()) continue;
                    this.zaB();
                    continue;
                }
                arrayList.add(this.zaa.zaa.get(anyClientKey));
            }
            if (!arrayList.isEmpty()) {
                Api.AnyClientKey<?> anyClientKey;
                ArrayList<Future<?>> arrayList2 = this.zau;
                anyClientKey = zabe.zaa();
                zaam zaam2 = new zaam(this, arrayList);
                arrayList2.add(anyClientKey.submit(zaam2));
                return;
            }
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaf(@Nullable Bundle bundle) {
        if (!this.zaI(1)) {
            return;
        }
        if (bundle != null) {
            this.zai.putAll(bundle);
        }
        if (this.zaz()) {
            this.zaB();
            return;
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zag(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (!this.zaI(1)) {
            return;
        }
        this.zaC(connectionResult, api, bl);
        if (this.zaz()) {
            this.zaB();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @GuardedBy(value="mLock")
    private final void zaB() {
        this.zaa.zap();
        Object object = zabe.zaa();
        zaah zaah2 = new zaah(this);
        object.execute(zaah2);
        object = this.zak;
        if (object != null) {
            if (this.zap) {
                object.zab((IAccountAccessor)Preconditions.checkNotNull((Object)this.zao), this.zaq);
            }
            this.zaG(false);
        }
        object = this.zaa.zab.keySet().iterator();
        while (object.hasNext()) {
            Api.AnyClientKey<?> anyClientKey;
            Api.AnyClientKey<?> anyClientKey2 = anyClientKey = object.next();
            ((Api.Client)Preconditions.checkNotNull((Object)this.zaa.zaa.get(anyClientKey2))).disconnect();
        }
        object = this.zai.isEmpty() ? null : this.zai;
        this.zaa.zah.zaa((Bundle)object);
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T zab(T t) {
        this.zaa.zag.zaa.add(t);
        return t;
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T zac(T t) {
        Object object = new IllegalStateException("GoogleApiClient is not connected yet.");
        throw object;
    }

    @Override
    public final void zae() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final boolean zad() {
        this.zaH();
        this.zaG(true);
        this.zaa.zaq(null);
        return true;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zah(int n) {
        ConnectionResult connectionResult = new ConnectionResult(8, null);
        this.zaF(connectionResult);
    }

    /*
     * Enabled aggressive block sorting
     */
    @GuardedBy(value="mLock")
    private final void zaC(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        int n = api.zaa().getPriority();
        if (!(bl && !connectionResult.hasResolution() && this.zad.getErrorResolutionIntent(connectionResult.getErrorCode()) == null || this.zae != null && n >= this.zaf)) {
            this.zae = connectionResult;
            this.zaf = n;
        }
        this.zaa.zab.put(api.zac(), connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zaD() {
        this.zam = false;
        this.zaa.zag.zad = Collections.emptySet();
        for (Api.AnyClientKey anyClientKey : this.zaj) {
            if (this.zaa.zab.containsKey(anyClientKey)) continue;
            Object object = this.zaa;
            object = ((zabd)object).zab;
            ConnectionResult connectionResult = new ConnectionResult(17, null);
            object.put(anyClientKey, connectionResult);
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zaE(ConnectionResult connectionResult) {
        return this.zal && !connectionResult.hasResolution();
    }

    @GuardedBy(value="mLock")
    private final void zaF(ConnectionResult connectionResult) {
        this.zaH();
        this.zaG(connectionResult.hasResolution() ^ true);
        this.zaa.zaq(connectionResult);
        this.zaa.zah.zab(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zaG(boolean bl) {
        zae zae2 = this.zak;
        if (zae2 != null) {
            if (zae2.isConnected() && bl) {
                zae2.zac();
            }
            zae2.disconnect();
            ClientSettings cfr_ignored_0 = (ClientSettings)Preconditions.checkNotNull((Object)this.zar);
            this.zao = null;
            return;
        }
    }

    private final void zaH() {
        ArrayList<Future<?>> arrayList = this.zau;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((Future)arrayList.get(i)).cancel(true);
        }
        this.zau.clear();
    }

    @GuardedBy(value="mLock")
    private final boolean zaI(int n) {
        if (this.zag != n) {
            Log.w((String)"GACConnecting", (String)this.zaa.zag.zae());
            String string2 = String.valueOf(this);
            String string3 = String.valueOf(string2);
            int n2 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n2 + 23);
            stringBuilder.append("Unexpected callback in ");
            stringBuilder.append(string2);
            Log.w((String)"GACConnecting", (String)stringBuilder.toString());
            int n3 = this.zah;
            StringBuilder stringBuilder2 = new StringBuilder(33);
            stringBuilder2.append("mRemainingConnections=");
            stringBuilder2.append(n3);
            Log.w((String)"GACConnecting", (String)stringBuilder2.toString());
            Object object = zaar.zaJ(this.zag);
            String string4 = zaar.zaJ(n);
            int n4 = ((String)object).length();
            int n5 = string4.length();
            StringBuilder stringBuilder3 = new StringBuilder(n4 + 70 + n5);
            stringBuilder3.append("GoogleApiClient connecting is in step ");
            stringBuilder3.append((String)object);
            stringBuilder3.append(" but received callback for step ");
            stringBuilder3.append(string4);
            string4 = stringBuilder3.toString();
            object = new Exception();
            Log.e((String)"GACConnecting", (String)string4, (Throwable)object);
            string4 = new ConnectionResult(8, null);
            this.zaF((ConnectionResult)string4);
            return false;
        }
        return true;
    }

    static /* synthetic */ Context zai(zaar zaar2) {
        return zaar2.zac;
    }

    static /* synthetic */ GoogleApiAvailabilityLight zaj(zaar zaar2) {
        return zaar2.zad;
    }

    static /* synthetic */ Lock zak(zaar zaar2) {
        return zaar2.zab;
    }

    static /* synthetic */ zabd zal(zaar zaar2) {
        return zaar2.zaa;
    }

    static /* synthetic */ void zam(zaar zaar2, ConnectionResult connectionResult) {
        zaar2.zaF(connectionResult);
    }

    static /* synthetic */ boolean zan(zaar zaar2) {
        return zaar2.zam;
    }

    static /* synthetic */ zae zao(zaar zaar2) {
        return zaar2.zak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* synthetic */ Set zap(zaar set) {
        Object object = ((zaar)((Object)set)).zar;
        if (object == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(((ClientSettings)object).getRequiredScopes());
        object = ((zaar)((Object)set)).zar.zaa();
        Iterator iterator = object.keySet().iterator();
        while (iterator.hasNext()) {
            Api api = (Api)iterator.next();
            if (((zaar)((Object)set)).zaa.zab.containsKey(api.zac())) continue;
            hashSet.addAll(((zab)object.get((Object)api)).zaa);
        }
        return hashSet;
    }

    static /* synthetic */ IAccountAccessor zaq(zaar zaar2) {
        return zaar2.zao;
    }

    static /* synthetic */ ClientSettings zar(zaar zaar2) {
        return zaar2.zar;
    }

    static /* synthetic */ boolean zas(zaar zaar2, ConnectionResult connectionResult) {
        return zaar2.zaE(connectionResult);
    }

    static /* synthetic */ void zat(zaar zaar2) {
        zaar2.zaD();
    }

    static /* synthetic */ void zau(zaar zaar2) {
        zaar2.zaA();
    }

    static /* synthetic */ boolean zav(zaar zaar2, int n) {
        return zaar2.zaI(0);
    }

    static /* synthetic */ void zaw(zaar zaar2, ConnectionResult connectionResult, Api api, boolean bl) {
        zaar2.zaC(connectionResult, api, bl);
    }

    static /* synthetic */ boolean zax(zaar zaar2) {
        return zaar2.zaz();
    }

    static /* synthetic */ void zay(zaar zaar2, zak object) {
        if (!zaar2.zaI(0)) {
            return;
        }
        ConnectionResult connectionResult = ((zak)((Object)object)).zaa();
        if (connectionResult.isSuccess()) {
            connectionResult = ((zav)((Object)(object = (zav)((Object)Preconditions.checkNotNull((Object)((Object)((zak)((Object)object)).zab())))))).zab();
            if (!connectionResult.isSuccess()) {
                object = String.valueOf(connectionResult);
                String string2 = String.valueOf(object);
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 48);
                stringBuilder.append("Sign-in succeeded with resolve account failure: ");
                stringBuilder.append((String)object);
                object = stringBuilder.toString();
                Exception exception = new Exception();
                Log.wtf((String)"GACConnecting", (String)object, (Throwable)exception);
                zaar2.zaF(connectionResult);
                return;
            }
            zaar2.zan = true;
            zaar2.zao = (IAccountAccessor)Preconditions.checkNotNull((Object)((zav)((Object)object)).zaa());
            zaar2.zap = ((zav)((Object)object)).zac();
            zaar2.zaq = ((zav)((Object)object)).zad();
            zaar2.zaA();
            return;
        }
        if (zaar2.zaE(connectionResult)) {
            zaar2.zaD();
            zaar2.zaA();
            return;
        }
        zaar2.zaF(connectionResult);
    }

    private static final String zaJ(int n) {
        switch (n) {
            default: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
            case 0: 
        }
        return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
    }
}

