/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.view.View;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.collection.ArraySet;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@VisibleForTesting
@KeepForSdk
public final class ClientSettings {
    @Nullable
    private final Account zaa;
    private final Set<Scope> zab;
    private final Set<Scope> zac;
    private final Map<Api<?>, zaa> zad;
    private final int zae;
    private final View zaf;
    private final String zag;
    private final String zah;
    private final SignInOptions zai;
    private final boolean zaj;
    private Integer zak;

    @KeepForSdk
    @RecentlyNonNull
    public static ClientSettings createDefault(@RecentlyNonNull Context context) {
        return new GoogleApiClient.Builder(context).buildClientSettings();
    }

    @KeepForSdk
    public ClientSettings(@RecentlyNonNull Account account, @RecentlyNonNull Set<Scope> set, @RecentlyNonNull Map<Api<?>, zaa> map, int n, @RecentlyNonNull View view, @RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull SignInOptions signInOptions) {
        this(account, set, map, n, view, string2, string3, signInOptions, false);
    }

    public ClientSettings(@Nullable Account account, @RecentlyNonNull Set<Scope> set, @RecentlyNonNull Map<Api<?>, zaa> map, int n, @RecentlyNonNull View view, @RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull SignInOptions signInOptions, boolean bl) {
        this.zaa = account;
        this.zab = set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
        this.zad = map == null ? Collections.emptyMap() : map;
        this.zaf = view;
        this.zae = n;
        this.zag = string2;
        this.zah = string3;
        this.zai = signInOptions;
        this.zaj = false;
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zab);
        for (zaa zaa2 : this.zad.values()) {
            hashSet.addAll(zaa2.zaa);
        }
        this.zac = Collections.unmodifiableSet(hashSet);
    }

    @Deprecated
    @RecentlyNullable
    @KeepForSdk
    public final String getAccountName() {
        if (this.zaa != null) {
            return this.zaa.name;
        }
        return null;
    }

    @RecentlyNullable
    @KeepForSdk
    public final Account getAccount() {
        return this.zaa;
    }

    @KeepForSdk
    @RecentlyNonNull
    public final Account getAccountOrDefault() {
        if (this.zaa != null) {
            return this.zaa;
        }
        return new Account("<<default account>>", "com.google");
    }

    @KeepForSdk
    public final int getGravityForPopups() {
        return this.zae;
    }

    @KeepForSdk
    @RecentlyNonNull
    public final Set<Scope> getRequiredScopes() {
        return this.zab;
    }

    @KeepForSdk
    @RecentlyNonNull
    public final Set<Scope> getAllRequestedScopes() {
        return this.zac;
    }

    @RecentlyNonNull
    public final Map<Api<?>, zaa> zaa() {
        return this.zad;
    }

    @RecentlyNullable
    @KeepForSdk
    public final String getRealClientPackageName() {
        return this.zag;
    }

    @RecentlyNullable
    public final String zab() {
        return this.zah;
    }

    @RecentlyNullable
    @KeepForSdk
    public final View getViewForPopups() {
        return this.zaf;
    }

    @RecentlyNonNull
    public final SignInOptions zac() {
        return this.zai;
    }

    @RecentlyNullable
    public final Integer zad() {
        return this.zak;
    }

    public final void zaa(@RecentlyNonNull Integer n) {
        this.zak = n;
    }

    @KeepForSdk
    @RecentlyNonNull
    public final Set<Scope> getApplicableScopes(@RecentlyNonNull Api<?> api) {
        zaa zaa2 = this.zad.get(api);
        if (zaa2 == null || zaa2.zaa.isEmpty()) {
            return this.zab;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zab);
        hashSet.addAll(zaa2.zaa);
        return hashSet;
    }

    @KeepForSdk
    public static final class Builder {
        @Nullable
        private Account zaa;
        private ArraySet<Scope> zab;
        private int zac = 0;
        private String zad;
        private String zae;
        private SignInOptions zaf = SignInOptions.zaa;

        @RecentlyNonNull
        public final Builder zaa(@Nullable Account account) {
            this.zaa = account;
            return this;
        }

        @RecentlyNonNull
        public final Builder zaa(@RecentlyNonNull Collection<Scope> collection) {
            if (this.zab == null) {
                this.zab = new ArraySet();
            }
            this.zab.addAll(collection);
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public final Builder setRealClientPackageName(@RecentlyNonNull String string2) {
            this.zad = string2;
            return this;
        }

        @RecentlyNonNull
        public final Builder zaa(@RecentlyNonNull String string2) {
            this.zae = string2;
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public final ClientSettings build() {
            return new ClientSettings(this.zaa, (Set<Scope>)this.zab, null, 0, null, this.zad, this.zae, this.zaf, false);
        }
    }

    public static final class zaa {
        public final Set<Scope> zaa;

        public zaa(Set<Scope> set) {
            Preconditions.checkNotNull(set);
            this.zaa = Collections.unmodifiableSet(set);
        }
    }
}

