/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaaa;
import com.google.android.gms.common.api.internal.zaaf;
import com.google.android.gms.common.api.internal.zaao;
import com.google.android.gms.common.api.internal.zaar;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zaay;
import com.google.android.gms.common.api.internal.zabb;
import com.google.android.gms.common.api.internal.zabn;
import com.google.android.gms.common.api.internal.zabo;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zae;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class zaaz
implements zabo,
zap {
    private final Lock zaf;
    private final Condition zag;
    private final Context zah;
    private final GoogleApiAvailabilityLight zai;
    private final zabb zaj;
    final Map<Api.AnyClientKey<?>, Api.Client> zaa;
    final Map<Api.AnyClientKey<?>, ConnectionResult> zab = new HashMap();
    @Nullable
    private final ClientSettings zak;
    private final Map<Api<?>, Boolean> zal;
    @Nullable
    private final Api.AbstractClientBuilder<? extends zae, SignInOptions> zam;
    @NotOnlyInitialized
    private volatile zaaw zan;
    @Nullable
    private ConnectionResult zao = null;
    int zac;
    final zaar zad;
    final zabn zae;

    public zaaz(Context context, zaar zaar2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, @Nullable ClientSettings clientSettings, Map<Api<?>, Boolean> map2, @Nullable Api.AbstractClientBuilder<? extends zae, SignInOptions> abstractClientBuilder, ArrayList<zaq> arrayList, zabn zabn2) {
        this.zah = context;
        this.zaf = lock;
        this.zai = googleApiAvailabilityLight;
        this.zaa = map;
        this.zak = clientSettings;
        this.zal = map2;
        this.zam = abstractClientBuilder;
        this.zad = zaar2;
        this.zae = zabn2;
        ArrayList<zaq> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zaq zaq2 = arrayList2.get(i);
            zaq2.zaa(this);
        }
        this.zaj = new zabb(this, looper);
        this.zag = lock.newCondition();
        this.zan = new zaao(this);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T zaa(@NonNull T t) {
        t.zab();
        return this.zan.zaa(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T zab(@NonNull T t) {
        t.zab();
        return this.zan.zab(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa() {
        this.zan.zac();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult zab() {
        this.zaa();
        while (this.zae()) {
            try {
                this.zag.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.zad()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zao != null) {
            return this.zao;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult zaa(long l, TimeUnit timeUnit) {
        this.zaa();
        long l2 = timeUnit.toNanos(l);
        while (this.zae()) {
            try {
                if (l2 <= 0L) {
                    this.zac();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zag.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.zad()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zao != null) {
            return this.zao;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zac() {
        if (this.zan.zab()) {
            this.zab.clear();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult zaa(@NonNull Api<?> api) {
        Api.AnyClientKey<?> anyClientKey = api.zac();
        if (this.zaa.containsKey(anyClientKey)) {
            if (this.zaa.get(anyClientKey).isConnected()) {
                return ConnectionResult.RESULT_SUCCESS;
            }
            if (this.zab.containsKey(anyClientKey)) {
                return this.zab.get(anyClientKey);
            }
        }
        return null;
    }

    final void zah() {
        this.zaf.lock();
        try {
            this.zan = new zaaf(this, this.zak, this.zal, this.zai, this.zam, this.zaf, this.zah);
            this.zan.zaa();
            this.zag.signalAll();
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    final void zai() {
        this.zaf.lock();
        try {
            this.zad.zab();
            this.zan = new zaaa(this);
            this.zan.zaa();
            this.zag.signalAll();
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    final void zaa(@Nullable ConnectionResult connectionResult) {
        this.zaf.lock();
        try {
            this.zao = connectionResult;
            this.zan = new zaao(this);
            this.zan.zaa();
            this.zag.signalAll();
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final boolean zad() {
        return this.zan instanceof zaaa;
    }

    @Override
    public final boolean zae() {
        return this.zan instanceof zaaf;
    }

    @Override
    public final boolean zaa(SignInConnectionListener signInConnectionListener) {
        return false;
    }

    @Override
    public final void zag() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaf() {
        if (this.zad()) {
            ((zaaa)this.zan).zad();
        }
    }

    @Override
    public final void zaa(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zaf.lock();
        try {
            this.zan.zaa(connectionResult, api, bl);
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zaf.lock();
        try {
            this.zan.zaa(bundle);
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zaf.lock();
        try {
            this.zan.zaa(n);
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    final void zaa(zaay zaay2) {
        Message message = this.zaj.obtainMessage(1, zaay2);
        this.zaj.sendMessage(message);
    }

    final void zaa(RuntimeException runtimeException) {
        Message message = this.zaj.obtainMessage(2, runtimeException);
        this.zaj.sendMessage(message);
    }

    @Override
    public final void zaa(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zan);
        for (Api<?> api : this.zal.keySet()) {
            printWriter.append(string2).append(api.zad()).println(":");
            ((Api.Client)Preconditions.checkNotNull((Object)this.zaa.get(api.zac()))).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zaa(zaaz zaaz2) {
        return zaaz2.zaf;
    }

    static /* synthetic */ zaaw zab(zaaz zaaz2) {
        return zaaz2.zan;
    }
}

