/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.OptionalPendingResultImpl;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.internal.Preconditions;

public final class PendingResults {
    @KeepForSdk
    @RecentlyNonNull
    public static PendingResult<Status> immediatePendingResult(@RecentlyNonNull Status status) {
        Preconditions.checkNotNull((Object)status, (Object)"Result must not be null");
        StatusPendingResult statusPendingResult = new StatusPendingResult(Looper.getMainLooper());
        statusPendingResult.setResult(status);
        return statusPendingResult;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static PendingResult<Status> immediatePendingResult(@RecentlyNonNull Status status, @RecentlyNonNull GoogleApiClient googleApiClient) {
        Preconditions.checkNotNull((Object)status, (Object)"Result must not be null");
        StatusPendingResult statusPendingResult = new StatusPendingResult(googleApiClient);
        statusPendingResult.setResult(status);
        return statusPendingResult;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <R extends Result> PendingResult<R> immediateFailedResult(@RecentlyNonNull R r, @RecentlyNonNull GoogleApiClient googleApiClient) {
        Preconditions.checkNotNull(r, (Object)"Result must not be null");
        Preconditions.checkArgument((!r.getStatus().isSuccess() ? 1 : 0) != 0, (Object)"Status code must not be SUCCESS");
        zac<R> zac2 = new zac<R>(googleApiClient, r);
        zac2.setResult(r);
        return zac2;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(@RecentlyNonNull R r) {
        Preconditions.checkNotNull(r, (Object)"Result must not be null");
        zab<R> zab2 = new zab<R>(null);
        zab2.setResult(r);
        return new OptionalPendingResultImpl(zab2);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(@RecentlyNonNull R r, @RecentlyNonNull GoogleApiClient googleApiClient) {
        Preconditions.checkNotNull(r, (Object)"Result must not be null");
        zab<R> zab2 = new zab<R>(googleApiClient);
        zab2.setResult(r);
        return new OptionalPendingResultImpl(zab2);
    }

    @RecentlyNonNull
    public static PendingResult<Status> canceledPendingResult() {
        StatusPendingResult statusPendingResult = new StatusPendingResult(Looper.getMainLooper());
        ((PendingResult)statusPendingResult).cancel();
        return statusPendingResult;
    }

    @RecentlyNonNull
    public static <R extends Result> PendingResult<R> canceledPendingResult(@RecentlyNonNull R r) {
        Preconditions.checkNotNull(r, (Object)"Result must not be null");
        Preconditions.checkArgument((r.getStatus().getStatusCode() == 16 ? 1 : 0) != 0, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zaa<R> zaa2 = new zaa<R>(r);
        ((PendingResult)zaa2).cancel();
        return zaa2;
    }

    @KeepForSdk
    private PendingResults() {
    }

    private static final class zaa<R extends Result>
    extends BasePendingResult<R> {
        private final R zab;

        public zaa(R r) {
            super(Looper.getMainLooper());
            this.zab = r;
        }

        @Override
        protected final R createFailedResult(Status status) {
            if (status.getStatusCode() != this.zab.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zab;
        }
    }

    private static final class zac<R extends Result>
    extends BasePendingResult<R> {
        private final R zab;

        public zac(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.zab = r;
        }

        @Override
        protected final R createFailedResult(Status status) {
            return this.zab;
        }
    }

    private static final class zab<R extends Result>
    extends BasePendingResult<R> {
        public zab(@Nullable GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected final R createFailedResult(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

