/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.FragmentManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.base.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zabk;
import com.google.android.gms.common.api.internal.zabm;
import com.google.android.gms.common.api.internal.zabp;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zab;
import com.google.android.gms.common.internal.zac;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.base.zas;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class GoogleApiAvailability
extends GoogleApiAvailabilityLight {
    private static final Object zaa = new Object();
    private static final GoogleApiAvailability zab = new GoogleApiAvailability();
    @GuardedBy(value="mLock")
    private String zac;
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @NonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";

    @NonNull
    public static GoogleApiAvailability getInstance() {
        return zab;
    }

    @MainThread
    @NonNull
    public Task<Void> makeGooglePlayServicesAvailable(@RecentlyNonNull Activity activity) {
        int n = GOOGLE_PLAY_SERVICES_VERSION_CODE;
        Activity activity2 = activity;
        GoogleApiAvailability googleApiAvailability = this;
        Preconditions.checkMainThread((String)"makeGooglePlayServicesAvailable must be called from the main thread");
        int n2 = googleApiAvailability.isGooglePlayServicesAvailable((Context)activity2, n);
        if (n2 == 0) {
            return Tasks.forResult(null);
        }
        zabp zabp2 = zabp.zaa(activity2);
        zabp2.zab(new ConnectionResult(n2, null), 0);
        return zabp2.zac();
    }

    @RecentlyNullable
    public Dialog getErrorDialog(@RecentlyNonNull Activity activity, int n, int n2) {
        return this.getErrorDialog(activity, n, n2, null);
    }

    @RecentlyNullable
    public Dialog getErrorDialog(@RecentlyNonNull Fragment fragment, int n, int n2) {
        return this.getErrorDialog(fragment, n, n2, null);
    }

    @RecentlyNullable
    public Dialog getErrorDialog(@RecentlyNonNull Activity activity, int n, int n2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.getErrorResolutionIntent((Context)activity, n, "d");
        return GoogleApiAvailability.zaa((Context)activity, n, com.google.android.gms.common.internal.zab.zaa(activity, intent, n2), onCancelListener);
    }

    @RecentlyNullable
    public Dialog getErrorDialog(@RecentlyNonNull Fragment fragment, int n, int n2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.getErrorResolutionIntent(fragment.requireContext(), n, "d");
        return GoogleApiAvailability.zaa(fragment.requireContext(), n, com.google.android.gms.common.internal.zab.zaa(fragment, intent, n2), onCancelListener);
    }

    public boolean showErrorDialogFragment(@RecentlyNonNull Activity activity, int n, int n2) {
        return this.showErrorDialogFragment(activity, n, n2, null);
    }

    public final boolean zaa(@RecentlyNonNull Activity activity, @RecentlyNonNull LifecycleFragment lifecycleFragment, int n, int n2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.getErrorResolutionIntent((Context)activity, n, "d");
        Dialog dialog = GoogleApiAvailability.zaa((Context)activity, n, com.google.android.gms.common.internal.zab.zaa(lifecycleFragment, intent, 2), onCancelListener);
        if (dialog == null) {
            return false;
        }
        GoogleApiAvailability.zaa(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public boolean showErrorDialogFragment(@RecentlyNonNull Activity activity, int n, int n2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        Dialog dialog = this.getErrorDialog(activity, n, n2, onCancelListener);
        if (dialog == null) {
            return false;
        }
        GoogleApiAvailability.zaa(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public void showErrorNotification(@RecentlyNonNull Context context, int n) {
        Context context2 = context;
        GoogleApiAvailability googleApiAvailability = this;
        PendingIntent pendingIntent = googleApiAvailability.getErrorResolutionPendingIntent(context2, n, 0, "n");
        googleApiAvailability.zaa(context2, n, null, pendingIntent);
    }

    public void showErrorNotification(@RecentlyNonNull Context context, @RecentlyNonNull ConnectionResult connectionResult) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        this.zaa(context, connectionResult.getErrorCode(), null, pendingIntent);
    }

    @TargetApi(value=20)
    private final void zaa(Context context, int n, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        int n2;
        int n3 = n;
        String string3 = String.format("GMS core API Availability. ConnectionResult=%s, tag=%s", n3, null);
        Log.w((String)"GoogleApiAvailability", (String)string3, (Throwable)new IllegalArgumentException());
        if (n == 18) {
            this.zaa(context);
            return;
        }
        if (pendingIntent == null) {
            if (n == 6) {
                Log.w((String)"GoogleApiAvailability", (String)"Missing resolution for ConnectionResult.RESOLUTION_REQUIRED. Call GoogleApiAvailability#showErrorNotification(Context, ConnectionResult) instead.");
            }
            return;
        }
        String string4 = com.google.android.gms.common.internal.zac.zab(context, n);
        String string5 = com.google.android.gms.common.internal.zac.zad(context, n);
        Resources resources = context.getResources();
        NotificationManager notificationManager = (NotificationManager)Preconditions.checkNotNull((Object)context.getSystemService("notification"));
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context).setLocalOnly(true).setAutoCancel(true).setContentTitle((CharSequence)string4).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string5));
        if (DeviceProperties.isWearable((Context)context)) {
            Preconditions.checkState((boolean)PlatformVersion.isAtLeastKitKatWatch());
            builder.setSmallIcon(context.getApplicationInfo().icon).setPriority(2);
            if (DeviceProperties.isWearableWithoutPlayStore((Context)context)) {
                builder.addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            } else {
                builder.setContentIntent(pendingIntent);
            }
        } else {
            builder.setSmallIcon(17301642).setTicker((CharSequence)resources.getString(R.string.common_google_play_services_notification_ticker)).setWhen(System.currentTimeMillis()).setContentIntent(pendingIntent).setContentText((CharSequence)string5);
        }
        NotificationCompat.Builder builder2 = builder;
        string3 = notificationManager;
        Context context2 = context;
        GoogleApiAvailability googleApiAvailability = this;
        if (PlatformVersion.isAtLeastO()) {
            String string6 = string3;
            Context context3 = context2;
            GoogleApiAvailability googleApiAvailability2 = googleApiAvailability;
            Preconditions.checkState((boolean)PlatformVersion.isAtLeastO());
            String string7 = googleApiAvailability2.zaa();
            if (string7 == null) {
                string7 = "com.google.android.gms.availability";
                NotificationChannel notificationChannel = string6.getNotificationChannel(string7);
                String string8 = com.google.android.gms.common.internal.zac.zaa(context3);
                if (notificationChannel == null) {
                    string6.createNotificationChannel(new NotificationChannel(string7, (CharSequence)string8, 4));
                } else if (!string8.contentEquals(notificationChannel.getName())) {
                    notificationChannel.setName((CharSequence)string8);
                    string6.createNotificationChannel(notificationChannel);
                }
            }
            String string9 = string7;
            builder2.setChannelId(string9);
        }
        Notification notification = builder.build();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                n2 = 10436;
                GooglePlayServicesUtilLight.sCanceledAvailabilityNotification.set(false);
                break;
            }
            default: {
                n2 = 39789;
            }
        }
        notificationManager.notify(n2, notification);
    }

    public final boolean zaa(@RecentlyNonNull Context context, @RecentlyNonNull ConnectionResult connectionResult, int n) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            this.zaa(context, connectionResult.getErrorCode(), null, GoogleApiActivity.zaa(context, pendingIntent, n));
            return true;
        }
        return false;
    }

    @RecentlyNonNull
    public static Dialog zaa(@RecentlyNonNull Activity activity, @RecentlyNonNull DialogInterface.OnCancelListener onCancelListener) {
        ProgressBar progressBar = new ProgressBar((Context)activity, null, 16842874);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)progressBar);
        builder.setMessage((CharSequence)com.google.android.gms.common.internal.zac.zac((Context)activity, 18));
        builder.setPositiveButton((CharSequence)"", null);
        AlertDialog alertDialog = builder.create();
        GoogleApiAvailability.zaa(activity, (Dialog)alertDialog, "GooglePlayServicesUpdatingDialog", onCancelListener);
        return alertDialog;
    }

    @Nullable
    public final zabk zaa(Context context, zabm zabm2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        zabk zabk2 = new zabk(zabm2);
        context.registerReceiver((BroadcastReceiver)zabk2, intentFilter);
        zabk2.zaa(context);
        if (!this.isUninstalledAppPossiblyUpdating(context, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            zabm2.zaa();
            zabk2.zaa();
            return null;
        }
        return zabk2;
    }

    @NonNull
    public Task<Void> checkApiAvailability(@RecentlyNonNull HasApiKey<?> hasApiKey, HasApiKey<?> ... hasApiKeyArray) {
        return GoogleApiAvailability.zaa(hasApiKey, hasApiKeyArray).onSuccessTask(com.google.android.gms.common.zaa.zaa);
    }

    @NonNull
    public Task<Void> checkApiAvailability(@RecentlyNonNull GoogleApi<?> googleApi, GoogleApi<?> ... googleApiArray) {
        return GoogleApiAvailability.zaa(googleApi, googleApiArray).onSuccessTask(com.google.android.gms.common.zab.zaa);
    }

    @NonNull
    private static Task<Map<ApiKey<?>, String>> zaa(@NonNull HasApiKey<?> hasApiKey, HasApiKey<?> ... hasApiKeyArray) {
        Preconditions.checkNotNull(hasApiKey, (Object)"Requested API must not be null.");
        Object object = hasApiKeyArray;
        int n = hasApiKeyArray.length;
        for (int i = 0; i < n; ++i) {
            Preconditions.checkNotNull(object[i], (Object)"Requested API must not be null.");
        }
        object = new ArrayList(hasApiKeyArray.length + 1);
        object.add(hasApiKey);
        object.addAll(Arrays.asList(hasApiKeyArray));
        return GoogleApiManager.zaa().zaa((Iterable<? extends HasApiKey<?>>)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=2)
    private final String zaa() {
        Object object = zaa;
        synchronized (object) {
            return this.zac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=26)
    public void setDefaultNotificationChannelId(@RecentlyNonNull Context context, @RecentlyNonNull String string2) {
        if (PlatformVersion.isAtLeastO()) {
            Preconditions.checkNotNull((Object)((NotificationManager)Preconditions.checkNotNull((Object)context.getSystemService("notification"))).getNotificationChannel(string2));
        }
        Object object = zaa;
        synchronized (object) {
            this.zac = string2;
            return;
        }
    }

    @HideFirstParty
    public int isGooglePlayServicesAvailable(@RecentlyNonNull Context context) {
        return super.isGooglePlayServicesAvailable(context);
    }

    @ShowFirstParty
    @KeepForSdk
    public int isGooglePlayServicesAvailable(@RecentlyNonNull Context context, int n) {
        return super.isGooglePlayServicesAvailable(context, n);
    }

    public final boolean isUserResolvableError(int n) {
        return super.isUserResolvableError(n);
    }

    @RecentlyNullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(@Nullable Context context, int n, @Nullable String string2) {
        return super.getErrorResolutionIntent(context, n, string2);
    }

    @RecentlyNullable
    public PendingIntent getErrorResolutionPendingIntent(@RecentlyNonNull Context context, int n, int n2) {
        return super.getErrorResolutionPendingIntent(context, n, n2);
    }

    @RecentlyNullable
    public PendingIntent getErrorResolutionPendingIntent(@RecentlyNonNull Context context, @RecentlyNonNull ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return connectionResult.getResolution();
        }
        return this.getErrorResolutionPendingIntent(context, connectionResult.getErrorCode(), 0);
    }

    @ShowFirstParty
    @KeepForSdk
    public int getClientVersion(@RecentlyNonNull Context context) {
        return super.getClientVersion(context);
    }

    @NonNull
    public final String getErrorString(int n) {
        return super.getErrorString(n);
    }

    @Nullable
    static Dialog zaa(@NonNull Context context, int n, zab zab2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        String string3;
        if (n == 0) {
            return null;
        }
        AlertDialog.Builder builder = null;
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(16843529, typedValue, true);
        String string4 = context.getResources().getResourceEntryName(typedValue.resourceId);
        if ("Theme.Dialog.Alert".equals(string4)) {
            builder = new AlertDialog.Builder(context, 5);
        }
        if (builder == null) {
            builder = new AlertDialog.Builder(context);
        }
        builder.setMessage((CharSequence)com.google.android.gms.common.internal.zac.zac(context, n));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        if ((string3 = com.google.android.gms.common.internal.zac.zae(context, n)) != null) {
            builder.setPositiveButton((CharSequence)string3, (DialogInterface.OnClickListener)zab2);
        }
        if ((string2 = com.google.android.gms.common.internal.zac.zaa(context, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        String string5 = String.format("Creating dialog for Google Play services availability issue. ConnectionResult=%s", n);
        Log.w((String)"GoogleApiAvailability", (String)string5, (Throwable)new IllegalArgumentException());
        return builder.create();
    }

    static void zaa(Activity activity, Dialog dialog, String string2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        if (activity instanceof FragmentActivity) {
            androidx.fragment.app.FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
            return;
        }
        FragmentManager fragmentManager = activity.getFragmentManager();
        ErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
    }

    final void zaa(Context context) {
        new zaa(context).sendEmptyMessageDelayed(1, 120000L);
    }

    static final /* synthetic */ Task zaa(Map map) throws Exception {
        return Tasks.forResult(null);
    }

    static final /* synthetic */ Task zab(Map map) throws Exception {
        return Tasks.forResult(null);
    }

    @SuppressLint(value={"HandlerLeak"})
    private final class zaa
    extends zas {
        private final Context zaa;

        public zaa(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.zaa = context.getApplicationContext();
        }

        public final void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int n = GoogleApiAvailability.this.isGooglePlayServicesAvailable(this.zaa);
                    if (!GoogleApiAvailability.this.isUserResolvableError(n)) break;
                    GoogleApiAvailability.this.showErrorNotification(this.zaa, n);
                    return;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiAvailability", (String)new StringBuilder(50).append("Don't know how to handle this message: ").append(n).toString());
                }
            }
        }
    }
}

