/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.Freezable;
import java.util.ArrayList;

public final class DataBufferUtils {
    @KeepForSdk
    @RecentlyNonNull
    public static final String KEY_NEXT_PAGE_TOKEN = "next_page_token";
    @KeepForSdk
    @RecentlyNonNull
    public static final String KEY_PREV_PAGE_TOKEN = "prev_page_token";

    private DataBufferUtils() {
    }

    @RecentlyNonNull
    public static <T, E extends Freezable<T>> ArrayList<T> freezeAndClose(@RecentlyNonNull DataBuffer<E> dataBuffer) {
        ArrayList arrayList = new ArrayList(dataBuffer.getCount());
        try {
            for (Freezable freezable : dataBuffer) {
                arrayList.add(freezable.freeze());
            }
        }
        finally {
            dataBuffer.close();
        }
        return arrayList;
    }

    @RecentlyNonNull
    public static boolean hasNextPage(@RecentlyNonNull DataBuffer<?> dataBuffer) {
        Bundle bundle = dataBuffer.getMetadata();
        return bundle != null && bundle.getString(KEY_NEXT_PAGE_TOKEN) != null;
    }

    @RecentlyNonNull
    public static boolean hasPrevPage(@RecentlyNonNull DataBuffer<?> dataBuffer) {
        Bundle bundle = dataBuffer.getMetadata();
        return bundle != null && bundle.getString(KEY_PREV_PAGE_TOKEN) != null;
    }

    @RecentlyNonNull
    public static boolean hasData(@RecentlyNonNull DataBuffer<?> dataBuffer) {
        return dataBuffer != null && dataBuffer.getCount() > 0;
    }
}

