/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public class DataBufferRef {
    @KeepForSdk
    @RecentlyNonNull
    protected final DataHolder mDataHolder;
    @KeepForSdk
    @RecentlyNonNull
    protected int mDataRow;
    private int zaa;

    @KeepForSdk
    public DataBufferRef(@RecentlyNonNull DataHolder dataHolder, @RecentlyNonNull int n) {
        this.mDataHolder = (DataHolder)Preconditions.checkNotNull((Object)dataHolder);
        this.zaa(n);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected int getDataRow() {
        return this.mDataRow;
    }

    protected final void zaa(@RecentlyNonNull int n) {
        Preconditions.checkState((n >= 0 && n < this.mDataHolder.getCount() ? 1 : 0) != 0);
        this.mDataRow = n;
        this.zaa = this.mDataHolder.getWindowIndex(this.mDataRow);
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean isDataValid() {
        return !this.mDataHolder.isClosed();
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean hasColumn(@RecentlyNonNull String string2) {
        return this.mDataHolder.hasColumn(string2);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected long getLong(@RecentlyNonNull String string2) {
        return this.mDataHolder.getLong(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected int getInteger(@RecentlyNonNull String string2) {
        return this.mDataHolder.getInteger(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected boolean getBoolean(@RecentlyNonNull String string2) {
        return this.mDataHolder.getBoolean(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected String getString(@RecentlyNonNull String string2) {
        return this.mDataHolder.getString(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected float getFloat(@RecentlyNonNull String string2) {
        return this.mDataHolder.zaa(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected double getDouble(@RecentlyNonNull String string2) {
        return this.mDataHolder.zab(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected byte[] getByteArray(@RecentlyNonNull String string2) {
        return this.mDataHolder.getByteArray(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    @RecentlyNullable
    protected Uri parseUri(@RecentlyNonNull String string2) {
        int n = this.mDataRow;
        int n2 = this.zaa;
        String string3 = this.mDataHolder.getString(string2, n, n2);
        if (string3 == null) {
            return null;
        }
        return Uri.parse((String)string3);
    }

    @KeepForSdk
    protected void copyToBuffer(@RecentlyNonNull String string2, @RecentlyNonNull CharArrayBuffer charArrayBuffer) {
        this.mDataHolder.zaa(string2, this.mDataRow, this.zaa, charArrayBuffer);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected boolean hasNull(@RecentlyNonNull String string2) {
        return this.mDataHolder.hasNull(string2, this.mDataRow, this.zaa);
    }

    @RecentlyNonNull
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mDataRow, this.zaa, this.mDataHolder});
    }

    @RecentlyNonNull
    public boolean equals(@Nullable Object object) {
        if (object instanceof DataBufferRef) {
            DataBufferRef dataBufferRef = (DataBufferRef)object;
            return Objects.equal((Object)dataBufferRef.mDataRow, (Object)this.mDataRow) && Objects.equal((Object)dataBufferRef.zaa, (Object)this.zaa) && dataBufferRef.mDataHolder == this.mDataHolder;
        }
        return false;
    }
}

