/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;

@KeepForSdk
public class DataBufferIterator<T>
implements Iterator<T> {
    @RecentlyNonNull
    protected final DataBuffer<T> zaa;
    @RecentlyNonNull
    protected int zab;

    public DataBufferIterator(@RecentlyNonNull DataBuffer<T> dataBuffer) {
        this.zaa = (DataBuffer)Preconditions.checkNotNull(dataBuffer);
        this.zab = -1;
    }

    @Override
    @RecentlyNonNull
    public boolean hasNext() {
        return this.zab < this.zaa.getCount() - 1;
    }

    @Override
    @RecentlyNonNull
    public T next() {
        if (!this.hasNext()) {
            int n = this.zab;
            throw new NoSuchElementException(new StringBuilder(46).append("Cannot advance the iterator beyond ").append(n).toString());
        }
        return this.zaa.get(++this.zab);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from a DataBufferIterator");
    }
}

