/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.zab;
import com.google.android.gms.common.api.internal.zac;
import com.google.android.gms.common.api.internal.zaw;
import com.google.android.gms.tasks.TaskCompletionSource;

public final class zaf<ResultT>
extends zab {
    private final TaskApiCall<Api.AnyClient, ResultT> zab;
    private final TaskCompletionSource<ResultT> zac;
    private final StatusExceptionMapper zad;

    public zaf(int n, TaskApiCall<Api.AnyClient, ResultT> taskApiCall, TaskCompletionSource<ResultT> taskCompletionSource, StatusExceptionMapper statusExceptionMapper) {
        super(n);
        this.zac = taskCompletionSource;
        this.zab = taskApiCall;
        this.zad = statusExceptionMapper;
        if (n == 2 && taskApiCall.shouldAutoResolveMissingFeatures()) {
            throw new IllegalArgumentException("Best-effort write calls cannot pass methods that should auto-resolve missing features.");
        }
    }

    @Override
    public final void zac(GoogleApiManager.zaa<?> zaa2) throws DeadObjectException {
        try {
            this.zab.doExecute(zaa2.zab(), this.zac);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            throw deadObjectException;
        }
        catch (RemoteException remoteException) {
            ((zac)this).zaa(com.google.android.gms.common.api.internal.zac.zaa(remoteException));
            return;
        }
        catch (RuntimeException runtimeException) {
            ((zac)this).zaa(runtimeException);
            return;
        }
    }

    @Override
    public final void zaa(@NonNull Status status) {
        this.zac.trySetException(this.zad.getException(status));
    }

    @Override
    public final void zaa(@NonNull Exception exception) {
        this.zac.trySetException(exception);
    }

    @Override
    public final void zaa(@NonNull zaw zaw2, boolean bl) {
        zaw2.zaa(this.zac, bl);
    }

    @Override
    @Nullable
    public final Feature[] zaa(GoogleApiManager.zaa<?> zaa2) {
        return this.zab.zaa();
    }

    @Override
    public final boolean zab(GoogleApiManager.zaa<?> zaa2) {
        return this.zab.shouldAutoResolveMissingFeatures();
    }
}

