/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.converter.zaa;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.server.response.zaj;
import com.google.android.gms.common.server.response.zal;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.MapUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@ShowFirstParty
@KeepForSdk
public abstract class FastJsonResponse {
    @KeepForSdk
    public abstract Map<String, Field<?, ?>> getFieldMappings();

    @KeepForSdk
    @Nullable
    protected abstract Object getValueObject(String var1);

    @KeepForSdk
    protected boolean isFieldSet(Field field) {
        if (field.zac == 11) {
            if (field.zad) {
                String cfr_ignored_0 = field.zae;
                throw new UnsupportedOperationException("Concrete type arrays not supported");
            }
            String cfr_ignored_1 = field.zae;
            throw new UnsupportedOperationException("Concrete types not supported");
        }
        return this.isPrimitiveFieldSet(field.zae);
    }

    @KeepForSdk
    protected abstract boolean isPrimitiveFieldSet(String var1);

    private final <I, O> void zab(Field<I, O> field, @Nullable I i) {
        String string2 = field.zae;
        O o = field.zaa(i);
        switch (field.zac) {
            case 0: {
                if (o != null) {
                    this.setIntegerInternal(field, string2, (Integer)o);
                    return;
                }
                FastJsonResponse.zaa(string2);
                return;
            }
            case 1: {
                this.zaa(field, string2, (BigInteger)o);
                return;
            }
            case 2: {
                if (o != null) {
                    this.setLongInternal(field, string2, (Long)o);
                    return;
                }
                FastJsonResponse.zaa(string2);
                return;
            }
            case 4: {
                if (o != null) {
                    this.zaa(field, string2, (Double)o);
                    return;
                }
                FastJsonResponse.zaa(string2);
                return;
            }
            case 5: {
                this.zaa(field, string2, (BigDecimal)o);
                return;
            }
            case 6: {
                if (o != null) {
                    this.setBooleanInternal(field, string2, (Boolean)o);
                    return;
                }
                FastJsonResponse.zaa(string2);
                return;
            }
            case 7: {
                this.setStringInternal(field, string2, (String)o);
                return;
            }
            case 8: 
            case 9: {
                if (o != null) {
                    this.setDecodedBytesInternal(field, string2, (byte[])o);
                    return;
                }
                FastJsonResponse.zaa(string2);
                return;
            }
        }
        int n = field.zac;
        throw new IllegalStateException(new StringBuilder(44).append("Unsupported type for conversion: ").append(n).toString());
    }

    protected static <O, I> I zaa(Field<I, O> field, @Nullable Object object) {
        if (((Field)field).zak != null) {
            return field.zab(object);
        }
        return (I)object;
    }

    public final <O> void zaa(Field<Integer, O> field, int n) {
        if (((Field)field).zak != null) {
            this.zab(field, n);
            return;
        }
        this.setIntegerInternal(field, field.zae, n);
    }

    public final <O> void zaa(Field<ArrayList<Integer>, O> field, @Nullable ArrayList<Integer> arrayList) {
        if (((Field)field).zak != null) {
            this.zab(field, (Object)arrayList);
            return;
        }
        this.zaa(field, field.zae, arrayList);
    }

    public final <O> void zaa(Field<BigInteger, O> field, @Nullable BigInteger bigInteger) {
        if (((Field)field).zak != null) {
            this.zab(field, bigInteger);
            return;
        }
        this.zaa(field, field.zae, bigInteger);
    }

    public final <O> void zab(Field<ArrayList<BigInteger>, O> field, @Nullable ArrayList<BigInteger> arrayList) {
        if (((Field)field).zak != null) {
            this.zab((Field)field, (Object)arrayList);
            return;
        }
        this.zab(field, field.zae, arrayList);
    }

    public final <O> void zaa(Field<Long, O> field, long l) {
        if (((Field)field).zak != null) {
            this.zab(field, l);
            return;
        }
        this.setLongInternal(field, field.zae, l);
    }

    public final <O> void zac(Field<ArrayList<Long>, O> field, @Nullable ArrayList<Long> arrayList) {
        if (((Field)field).zak != null) {
            this.zab(field, (Object)arrayList);
            return;
        }
        this.zac(field, field.zae, arrayList);
    }

    public final <O> void zaa(Field<Float, O> field, float f) {
        if (((Field)field).zak != null) {
            this.zab(field, Float.valueOf(f));
            return;
        }
        this.zaa(field, field.zae, f);
    }

    public final <O> void zad(Field<ArrayList<Float>, O> field, @Nullable ArrayList<Float> arrayList) {
        if (((Field)field).zak != null) {
            this.zab(field, (Object)arrayList);
            return;
        }
        this.zad(field, field.zae, arrayList);
    }

    public final <O> void zaa(Field<Double, O> field, double d) {
        if (((Field)field).zak != null) {
            this.zab(field, d);
            return;
        }
        this.zaa(field, field.zae, d);
    }

    public final <O> void zae(Field<ArrayList<Double>, O> field, @Nullable ArrayList<Double> arrayList) {
        if (((Field)field).zak != null) {
            this.zab(field, (Object)arrayList);
            return;
        }
        this.zae(field, field.zae, arrayList);
    }

    public final <O> void zaa(Field<BigDecimal, O> field, @Nullable BigDecimal bigDecimal) {
        if (((Field)field).zak != null) {
            this.zab(field, bigDecimal);
            return;
        }
        this.zaa(field, field.zae, bigDecimal);
    }

    public final <O> void zaf(Field<ArrayList<BigDecimal>, O> field, @Nullable ArrayList<BigDecimal> arrayList) {
        if (((Field)field).zak != null) {
            this.zab(field, (Object)arrayList);
            return;
        }
        this.zaf(field, field.zae, arrayList);
    }

    public final <O> void zaa(Field<Boolean, O> field, boolean bl) {
        if (((Field)field).zak != null) {
            this.zab(field, bl);
            return;
        }
        this.setBooleanInternal(field, field.zae, bl);
    }

    public final <O> void zag(Field<ArrayList<Boolean>, O> field, @Nullable ArrayList<Boolean> arrayList) {
        if (((Field)field).zak != null) {
            this.zab(field, (Object)arrayList);
            return;
        }
        this.zag(field, field.zae, arrayList);
    }

    public final <O> void zaa(Field<String, O> field, @Nullable String string2) {
        if (((Field)field).zak != null) {
            this.zab(field, string2);
            return;
        }
        this.setStringInternal(field, field.zae, string2);
    }

    public final <O> void zah(Field<ArrayList<String>, O> field, @Nullable ArrayList<String> arrayList) {
        if (((Field)field).zak != null) {
            this.zab(field, (Object)arrayList);
            return;
        }
        this.setStringsInternal(field, field.zae, arrayList);
    }

    public final <O> void zaa(Field<byte[], O> field, @Nullable byte[] byArray) {
        if (((Field)field).zak != null) {
            this.zab(field, byArray);
            return;
        }
        this.setDecodedBytesInternal(field, field.zae, byArray);
    }

    public final <O> void zaa(Field<Map<String, String>, O> field, @Nullable Map<String, String> map) {
        if (((Field)field).zak != null) {
            this.zab(field, map);
            return;
        }
        this.setStringMapInternal(field, field.zae, map);
    }

    @KeepForSdk
    protected void setIntegerInternal(Field<?, ?> field, String string2, int n) {
        throw new UnsupportedOperationException("Integer not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, @Nullable ArrayList<Integer> arrayList) {
        throw new UnsupportedOperationException("Integer list not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, @Nullable BigInteger bigInteger) {
        throw new UnsupportedOperationException("BigInteger not supported");
    }

    protected void zab(Field<?, ?> field, String string2, @Nullable ArrayList<BigInteger> arrayList) {
        throw new UnsupportedOperationException("BigInteger list not supported");
    }

    @KeepForSdk
    protected void setLongInternal(Field<?, ?> field, String string2, long l) {
        throw new UnsupportedOperationException("Long not supported");
    }

    protected void zac(Field<?, ?> field, String string2, @Nullable ArrayList<Long> arrayList) {
        throw new UnsupportedOperationException("Long list not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, float f) {
        throw new UnsupportedOperationException("Float not supported");
    }

    protected void zad(Field<?, ?> field, String string2, @Nullable ArrayList<Float> arrayList) {
        throw new UnsupportedOperationException("Float list not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, double d) {
        throw new UnsupportedOperationException("Double not supported");
    }

    protected void zae(Field<?, ?> field, String string2, @Nullable ArrayList<Double> arrayList) {
        throw new UnsupportedOperationException("Double list not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, @Nullable BigDecimal bigDecimal) {
        throw new UnsupportedOperationException("BigDecimal not supported");
    }

    protected void zaf(Field<?, ?> field, String string2, @Nullable ArrayList<BigDecimal> arrayList) {
        throw new UnsupportedOperationException("BigDecimal list not supported");
    }

    @KeepForSdk
    protected void setBooleanInternal(Field<?, ?> field, String string2, boolean bl) {
        throw new UnsupportedOperationException("Boolean not supported");
    }

    protected void zag(Field<?, ?> field, String string2, @Nullable ArrayList<Boolean> arrayList) {
        throw new UnsupportedOperationException("Boolean list not supported");
    }

    @KeepForSdk
    protected void setStringInternal(Field<?, ?> field, String string2, @Nullable String string3) {
        throw new UnsupportedOperationException("String not supported");
    }

    @KeepForSdk
    protected void setStringsInternal(Field<?, ?> field, String string2, @Nullable ArrayList<String> arrayList) {
        throw new UnsupportedOperationException("String list not supported");
    }

    @KeepForSdk
    protected void setDecodedBytesInternal(Field<?, ?> field, String string2, @Nullable byte[] byArray) {
        throw new UnsupportedOperationException("byte[] not supported");
    }

    @KeepForSdk
    protected void setStringMapInternal(Field<?, ?> field, String string2, @Nullable Map<String, String> map) {
        throw new UnsupportedOperationException("String map not supported");
    }

    private static <O> void zaa(String string2) {
        if (Log.isLoggable((String)"FastJsonResponse", (int)6)) {
            Log.e((String)"FastJsonResponse", (String)new StringBuilder(58 + String.valueOf(string2).length()).append("Output field (").append(string2).append(") has a null value, but expected a primitive").toString());
        }
    }

    @KeepForSdk
    public <T extends FastJsonResponse> void addConcreteTypeInternal(Field<?, ?> field, String string2, T t) {
        throw new UnsupportedOperationException("Concrete type not supported");
    }

    @KeepForSdk
    public <T extends FastJsonResponse> void addConcreteTypeArrayInternal(Field<?, ?> field, String string2, @Nullable ArrayList<T> arrayList) {
        throw new UnsupportedOperationException("Concrete type array not supported");
    }

    @KeepForSdk
    public String toString() {
        Map<String, Field<?, ?>> map = this.getFieldMappings();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.isFieldSet(field)) continue;
            Object object = this.getFieldValue(field);
            Object obj = FastJsonResponse.zaa(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zac) {
                case 8: {
                    stringBuilder.append("\"").append(Base64Utils.encode((byte[])((byte[])obj))).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(Base64Utils.encodeUrlSafe((byte[])((byte[])obj))).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    MapUtils.writeStringMapToJson((StringBuilder)stringBuilder, (HashMap)hashMap);
                    continue block5;
                }
            }
            if (field.zab) {
                ArrayList arrayList = (ArrayList)obj;
                Field<?, ?> field2 = field;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.append("[");
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Object e;
                    if (i > 0) {
                        stringBuilder2.append(",");
                    }
                    if ((e = arrayList.get(i)) == null) continue;
                    FastJsonResponse.zaa(stringBuilder2, field2, e);
                }
                stringBuilder2.append("]");
                continue;
            }
            FastJsonResponse.zaa(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    @KeepForSdk
    @Nullable
    protected Object getFieldValue(Field field) {
        String string2 = field.zae;
        if (field.zag != null) {
            Preconditions.checkState((this.getValueObject(field.zae) == null ? 1 : 0) != 0, (String)"Concrete field shouldn't be value object: %s", (Object[])new Object[]{field.zae});
            boolean cfr_ignored_0 = field.zad;
            Object var3_3 = null;
            try {
                char c = Character.toUpperCase(string2.charAt(0));
                String string3 = string2.substring(1);
                String string4 = new StringBuilder(4 + String.valueOf(string3).length()).append("get").append(c).append(string3).toString();
                return this.getClass().getMethod(string4, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.getValueObject(field.zae);
    }

    private static void zaa(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zaa == 11) {
            Class<? extends FastJsonResponse> clazz = field.zag;
            Preconditions.checkNotNull(clazz);
            stringBuilder.append(clazz.cast(object).toString());
            return;
        }
        if (field.zaa == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(JsonUtils.escapeString((String)((String)object)));
            stringBuilder.append("\"");
            return;
        }
        stringBuilder.append(object);
    }

    @ShowFirstParty
    public static interface FieldConverter<I, O> {
        public int zaa();

        public int zab();

        @Nullable
        public O zab(I var1);

        public I zaa(O var1);
    }

    @VisibleForTesting
    @ShowFirstParty
    @SafeParcelable.Class(creator="FieldCreator")
    @KeepForSdk
    public static class Field<I, O>
    extends AbstractSafeParcelable {
        @SafeParcelable.VersionField(id=1, getter="getVersionCode")
        private final int zah;
        @SafeParcelable.Field(id=2, getter="getTypeIn")
        protected final int zaa;
        @SafeParcelable.Field(id=3, getter="isTypeInArray")
        protected final boolean zab;
        @SafeParcelable.Field(id=4, getter="getTypeOut")
        protected final int zac;
        @SafeParcelable.Field(id=5, getter="isTypeOutArray")
        protected final boolean zad;
        @SafeParcelable.Field(id=6, getter="getOutputFieldName")
        protected final String zae;
        @SafeParcelable.Field(id=7, getter="getSafeParcelableFieldId")
        protected final int zaf;
        @Nullable
        protected final Class<? extends FastJsonResponse> zag;
        @SafeParcelable.Field(id=8, getter="getConcreteTypeName")
        @Nullable
        private final String zai;
        private zal zaj;
        @SafeParcelable.Field(id=9, getter="getWrappedConverter", type="com.google.android.gms.common.server.converter.ConverterWrapper")
        @Nullable
        private FieldConverter<I, O> zak;
        public static final zaj CREATOR = new zaj();

        @SafeParcelable.Constructor
        Field(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) int n3, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) String string2, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) @Nullable String string3, @SafeParcelable.Param(id=9) @Nullable zaa zaa2) {
            this.zah = n;
            this.zaa = n2;
            this.zab = bl;
            this.zac = n3;
            this.zad = bl2;
            this.zae = string2;
            this.zaf = n4;
            if (string3 == null) {
                this.zag = null;
                this.zai = null;
            } else {
                this.zag = SafeParcelResponse.class;
                this.zai = string3;
            }
            if (zaa2 == null) {
                this.zak = null;
                return;
            }
            this.zak = zaa2.zaa();
        }

        private Field(int n, boolean bl, int n2, boolean bl2, String string2, int n3, @Nullable Class<? extends FastJsonResponse> clazz, @Nullable FieldConverter<I, O> fieldConverter) {
            this.zah = 1;
            this.zaa = n;
            this.zab = bl;
            this.zac = n2;
            this.zad = bl2;
            this.zae = string2;
            this.zaf = n3;
            this.zag = clazz;
            this.zai = clazz == null ? null : clazz.getCanonicalName();
            this.zak = fieldConverter;
        }

        public final Field<I, O> zaa() {
            return new Field<I, O>(this.zah, this.zaa, this.zab, this.zac, this.zad, this.zae, this.zaf, this.zai, this.zaf());
        }

        @KeepForSdk
        public int getSafeParcelableFieldId() {
            return this.zaf;
        }

        @Nullable
        private final String zae() {
            if (this.zai == null) {
                return null;
            }
            return this.zai;
        }

        public final boolean zab() {
            return this.zak != null;
        }

        public final void zaa(zal zal2) {
            this.zaj = zal2;
        }

        @Nullable
        private final zaa zaf() {
            if (this.zak == null) {
                return null;
            }
            return com.google.android.gms.common.server.converter.zaa.zaa(this.zak);
        }

        public final FastJsonResponse zac() throws InstantiationException, IllegalAccessException {
            Preconditions.checkNotNull(this.zag);
            if (this.zag == SafeParcelResponse.class) {
                Preconditions.checkNotNull((Object)this.zai);
                Preconditions.checkNotNull((Object)((Object)this.zaj), (Object)"The field mapping dictionary must be set if the concrete type is a SafeParcelResponse object.");
                return new SafeParcelResponse(this.zaj, this.zai);
            }
            return this.zag.newInstance();
        }

        public final Map<String, Field<?, ?>> zad() {
            Preconditions.checkNotNull((Object)this.zai);
            Preconditions.checkNotNull((Object)((Object)this.zaj));
            return (Map)Preconditions.checkNotNull(this.zaj.zaa(this.zai));
        }

        public final O zaa(@Nullable I i) {
            Preconditions.checkNotNull(this.zak);
            return (O)Preconditions.checkNotNull(this.zak.zab(i));
        }

        public final I zab(O o) {
            Preconditions.checkNotNull(this.zak);
            return this.zak.zaa(o);
        }

        @VisibleForTesting
        @KeepForSdk
        public static Field<Integer, Integer> forInteger(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<Long, Long> forLong(String string2, int n) {
            return new Field<Long, Long>(2, false, 2, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<Float, Float> forFloat(String string2, int n) {
            return new Field<Float, Float>(3, false, 3, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<Double, Double> forDouble(String string2, int n) {
            return new Field<Double, Double>(4, false, 4, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<Boolean, Boolean> forBoolean(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<String, String> forString(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<ArrayList<String>, ArrayList<String>> forStrings(String string2, int n) {
            return new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, n, null, null);
        }

        @VisibleForTesting
        @KeepForSdk
        public static Field<byte[], byte[]> forBase64(String string2, int n) {
            return new Field<byte[], byte[]>(8, false, 8, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<HashMap<String, String>, HashMap<String, String>> forStringMap(String string2, int n) {
            return new Field<HashMap<String, String>, HashMap<String, String>>(10, false, 10, false, string2, n, null, null);
        }

        @KeepForSdk
        public static <T extends FastJsonResponse> Field<T, T> forConcreteType(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        @KeepForSdk
        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> forConcreteTypeArray(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        @KeepForSdk
        public static Field withConverter(String string2, int n, FieldConverter<?, ?> fieldConverter, boolean bl) {
            return new Field(fieldConverter.zaa(), bl, fieldConverter.zab(), false, string2, n, null, fieldConverter);
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Field field = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)field.zah);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)field.zaa);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)field.zab);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)field.zac);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)field.zad);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)field.zae, (boolean)false);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)field.getSafeParcelableFieldId());
            SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)field.zae(), (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)field.zaf(), (int)n, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public String toString() {
            Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)((Object)this)).add("versionCode", (Object)this.zah).add("typeIn", (Object)this.zaa).add("typeInArray", (Object)this.zab).add("typeOut", (Object)this.zac).add("typeOutArray", (Object)this.zad).add("outputFieldName", (Object)this.zae).add("safeParcelFieldId", (Object)this.zaf).add("concreteTypeName", (Object)this.zae());
            Class<? extends FastJsonResponse> clazz = this.zag;
            if (clazz != null) {
                toStringHelper.add("concreteType.class", (Object)clazz.getCanonicalName());
            }
            if (this.zak != null) {
                toStringHelper.add("converterName", (Object)this.zak.getClass().getCanonicalName());
            }
            return toStringHelper.toString();
        }
    }
}

