/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.view.View;
import androidx.collection.ArraySet;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@VisibleForTesting
@KeepForSdk
public final class ClientSettings {
    @Nullable
    private final Account zaa;
    private final Set<Scope> zab;
    private final Set<Scope> zac;
    private final Map<Api<?>, zaa> zad;
    private final int zae;
    private final View zaf;
    private final String zag;
    private final String zah;
    private final SignInOptions zai;
    private final boolean zaj;
    private Integer zak;

    @KeepForSdk
    public static ClientSettings createDefault(Context context) {
        return new GoogleApiClient.Builder(context).buildClientSettings();
    }

    @KeepForSdk
    public ClientSettings(Account account, Set<Scope> set, Map<Api<?>, zaa> map, int n, View view, String string2, String string3, SignInOptions signInOptions) {
        this(account, set, map, n, view, string2, string3, signInOptions, false);
    }

    public ClientSettings(@Nullable Account account, Set<Scope> set, Map<Api<?>, zaa> map, int n, View view, String string2, String string3, SignInOptions signInOptions, boolean bl) {
        this.zaa = account;
        this.zab = set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
        this.zad = map == null ? Collections.emptyMap() : map;
        this.zaf = view;
        this.zae = n;
        this.zag = string2;
        this.zah = string3;
        this.zai = signInOptions;
        this.zaj = false;
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zab);
        for (zaa zaa2 : this.zad.values()) {
            hashSet.addAll(zaa2.zaa);
        }
        this.zac = Collections.unmodifiableSet(hashSet);
    }

    @Deprecated
    @Nullable
    @KeepForSdk
    public final String getAccountName() {
        if (this.zaa != null) {
            return this.zaa.name;
        }
        return null;
    }

    @Nullable
    @KeepForSdk
    public final Account getAccount() {
        return this.zaa;
    }

    @KeepForSdk
    public final Account getAccountOrDefault() {
        if (this.zaa != null) {
            return this.zaa;
        }
        return new Account("<<default account>>", "com.google");
    }

    @KeepForSdk
    public final int getGravityForPopups() {
        return this.zae;
    }

    @KeepForSdk
    public final Set<Scope> getRequiredScopes() {
        return this.zab;
    }

    @KeepForSdk
    public final Set<Scope> getAllRequestedScopes() {
        return this.zac;
    }

    public final Map<Api<?>, zaa> zaa() {
        return this.zad;
    }

    @Nullable
    @KeepForSdk
    public final String getRealClientPackageName() {
        return this.zag;
    }

    @Nullable
    public final String zab() {
        return this.zah;
    }

    @Nullable
    @KeepForSdk
    public final View getViewForPopups() {
        return this.zaf;
    }

    public final SignInOptions zac() {
        return this.zai;
    }

    @Nullable
    public final Integer zad() {
        return this.zak;
    }

    public final void zaa(Integer n) {
        this.zak = n;
    }

    @KeepForSdk
    public final Set<Scope> getApplicableScopes(Api<?> api) {
        zaa zaa2 = this.zad.get(api);
        if (zaa2 == null || zaa2.zaa.isEmpty()) {
            return this.zab;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zab);
        hashSet.addAll(zaa2.zaa);
        return hashSet;
    }

    public final boolean zae() {
        return this.zaj;
    }

    @KeepForSdk
    public static final class Builder {
        @Nullable
        private Account zaa;
        private ArraySet<Scope> zab;
        private int zac = 0;
        private String zad;
        private String zae;
        private SignInOptions zaf = SignInOptions.zaa;

        public final Builder zaa(@Nullable Account account) {
            this.zaa = account;
            return this;
        }

        public final Builder zaa(Collection<Scope> collection) {
            if (this.zab == null) {
                this.zab = new ArraySet();
            }
            this.zab.addAll(collection);
            return this;
        }

        @KeepForSdk
        public final Builder setRealClientPackageName(String string2) {
            this.zad = string2;
            return this;
        }

        public final Builder zaa(String string2) {
            this.zae = string2;
            return this;
        }

        @KeepForSdk
        public final ClientSettings build() {
            return new ClientSettings(this.zaa, (Set<Scope>)this.zab, null, 0, null, this.zad, this.zae, this.zaf, false);
        }
    }

    public static final class zaa {
        public final Set<Scope> zaa;

        public zaa(Set<Scope> set) {
            Preconditions.checkNotNull(set);
            this.zaa = Collections.unmodifiableSet(set);
        }
    }
}

