/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zabz;
import com.google.android.gms.common.api.internal.zack;
import com.google.android.gms.common.api.internal.zacl;
import com.google.android.gms.common.internal.Preconditions;
import java.lang.ref.WeakReference;
import javax.annotation.concurrent.GuardedBy;

public final class zaci<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    @Nullable
    private ResultTransform<? super R, ? extends Result> zaa = null;
    @Nullable
    private zaci<? extends Result> zab = null;
    @Nullable
    private volatile ResultCallbacks<? super R> zac = null;
    @Nullable
    private PendingResult<R> zad = null;
    private final Object zae = new Object();
    @Nullable
    private Status zaf = null;
    private final WeakReference<GoogleApiClient> zag;
    private final zack zah;
    private boolean zai = false;

    public zaci(WeakReference<GoogleApiClient> weakReference) {
        Preconditions.checkNotNull(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zag = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zag.get();
        this.zah = new zack(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zae;
        synchronized (object) {
            Preconditions.checkState((this.zaa == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zac == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zaa = resultTransform;
            zaci<R> zaci2 = new zaci<R>(this.zag);
            this.zab = zaci2;
            this.zab();
            return zaci2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zae;
        synchronized (object) {
            Preconditions.checkState((this.zac == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            Preconditions.checkState((this.zaa == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zac = resultCallbacks;
            this.zab();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zae;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zaa != null) {
                    zabz.zaa().submit(new zacl(this, (Result)r));
                } else if (this.zac()) {
                    ((ResultCallbacks)Preconditions.checkNotNull(this.zac)).onSuccess(r);
                }
            } else {
                this.zaa(r.getStatus());
                zaci.zaa(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(PendingResult<?> pendingResult) {
        Object object = this.zae;
        synchronized (object) {
            this.zad = pendingResult;
            this.zab();
            return;
        }
    }

    @GuardedBy(value="mSyncToken")
    private final void zab() {
        if (this.zaa == null && this.zac == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zag.get();
        if (!this.zai && this.zaa != null && googleApiClient != null) {
            googleApiClient.zaa(this);
            this.zai = true;
        }
        if (this.zaf != null) {
            this.zab(this.zaf);
            return;
        }
        if (this.zad != null) {
            this.zad.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zaa(Status status) {
        Object object = this.zae;
        synchronized (object) {
            this.zaf = status;
            this.zab(this.zaf);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zab(Status status) {
        Object object = this.zae;
        synchronized (object) {
            if (this.zaa != null) {
                Status status2 = (Status)Preconditions.checkNotNull((Object)this.zaa.onFailure(status), (Object)"onFailure must not return null");
                ((zaci)Preconditions.checkNotNull(this.zab)).zaa(status2);
            } else if (this.zac()) {
                ((ResultCallbacks)Preconditions.checkNotNull(this.zac)).onFailure(status);
            }
            return;
        }
    }

    final void zaa() {
        this.zac = null;
    }

    @GuardedBy(value="mSyncToken")
    private final boolean zac() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zag.get();
        return this.zac != null && googleApiClient != null;
    }

    private static void zaa(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zaa(zaci zaci2) {
        return zaci2.zaa;
    }

    static /* synthetic */ zack zab(zaci zaci2) {
        return zaci2.zah;
    }

    static /* synthetic */ void zaa(zaci zaci2, Result result) {
        zaci.zaa(result);
    }

    static /* synthetic */ WeakReference zac(zaci zaci2) {
        return zaci2.zag;
    }

    static /* synthetic */ Object zad(zaci zaci2) {
        return zaci2.zae;
    }

    static /* synthetic */ zaci zae(zaci zaci2) {
        return zaci2.zab;
    }

    static /* synthetic */ void zaa(zaci zaci2, Status status) {
        zaci2.zaa(status);
    }
}

