/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.api.internal.zabp;
import com.google.android.gms.common.api.internal.zabq;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zap;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;

@KeepForSdk
public final class NonGmsServiceBrokerClient
implements ServiceConnection,
Api.Client {
    private static final String zaa = NonGmsServiceBrokerClient.class.getSimpleName();
    @Nullable
    private final String zab;
    @Nullable
    private final String zac;
    @Nullable
    private final ComponentName zad;
    private final Context zae;
    private final ConnectionCallbacks zaf;
    private final Handler zag;
    private final OnConnectionFailedListener zah;
    @Nullable
    private IBinder zai;
    private boolean zaj = false;
    @Nullable
    private String zak = null;

    @KeepForSdk
    public NonGmsServiceBrokerClient(Context context, Looper looper, String string2, String string3, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, string2, string3, null, connectionCallbacks, onConnectionFailedListener);
    }

    @KeepForSdk
    public NonGmsServiceBrokerClient(Context context, Looper looper, ComponentName componentName, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, null, null, componentName, connectionCallbacks, onConnectionFailedListener);
    }

    private NonGmsServiceBrokerClient(Context context, Looper looper, @Nullable String string2, @Nullable String string3, @Nullable ComponentName componentName, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        boolean bl;
        this.zae = context;
        this.zag = new zap(looper);
        this.zaf = connectionCallbacks;
        this.zah = onConnectionFailedListener;
        boolean bl2 = string2 != null && string3 != null;
        boolean bl3 = bl = componentName != null;
        if (bl2 ? bl : !bl) {
            throw new AssertionError((Object)"Must specify either package or component, but not both");
        }
        this.zab = string2;
        this.zac = string3;
        this.zad = componentName;
    }

    @WorkerThread
    private final void zab() {
        if (Thread.currentThread() != this.zag.getLooper().getThread()) {
            throw new IllegalStateException("This method should only run on the NonGmsServiceBrokerClient's handler thread.");
        }
    }

    private final void zaa(String string2) {
        String string3 = String.valueOf(this.zai);
        boolean bl = this.zaj;
        new StringBuilder(30 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" binder: ").append(string3).append(", isConnecting: ").append(bl);
    }

    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        this.zag.post((Runnable)new zabq(this, iBinder));
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        this.zag.post((Runnable)new zabp(this));
    }

    @Override
    @WorkerThread
    public final void connect(BaseGmsClient.ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        this.zab();
        this.zaa("Connect started.");
        if (this.isConnected()) {
            try {
                this.disconnect("connect() called when already connected");
            }
            catch (Exception exception) {}
        }
        try {
            Intent intent = new Intent();
            if (this.zad != null) {
                intent.setComponent(this.zad);
            } else {
                intent.setPackage(this.zab).setAction(this.zac);
            }
            this.zaj = this.zae.bindService(intent, (ServiceConnection)this, GmsClientSupervisor.getDefaultBindFlags());
        }
        catch (SecurityException securityException) {
            this.zaj = false;
            this.zai = null;
            throw securityException;
        }
        if (!this.zaj) {
            this.zai = null;
            this.zah.onConnectionFailed(new ConnectionResult(16));
        }
        this.zaa("Finished connect.");
    }

    @Override
    @WorkerThread
    public final void disconnect(String string2) {
        this.zab();
        this.zak = string2;
        this.disconnect();
    }

    @Override
    @WorkerThread
    public final void disconnect() {
        this.zab();
        this.zaa("Disconnect called.");
        this.zae.unbindService((ServiceConnection)this);
        this.zaj = false;
        this.zai = null;
    }

    @Override
    @WorkerThread
    public final boolean isConnected() {
        this.zab();
        return this.zai != null;
    }

    @Override
    @WorkerThread
    public final boolean isConnecting() {
        this.zab();
        return this.zaj;
    }

    @Override
    public final void getRemoteService(@Nullable IAccountAccessor iAccountAccessor, @Nullable Set<Scope> set) {
    }

    @Override
    public final boolean requiresSignIn() {
        return false;
    }

    @Override
    public final void onUserSignOut(BaseGmsClient.SignOutCallbacks signOutCallbacks) {
    }

    @Override
    public final boolean requiresAccount() {
        return false;
    }

    @Override
    public final boolean requiresGooglePlayServices() {
        return false;
    }

    @Override
    public final boolean providesSignIn() {
        return false;
    }

    @Override
    public final Intent getSignInIntent() {
        return new Intent();
    }

    @Override
    public final void dump(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
    }

    @Override
    @Nullable
    public final IBinder getServiceBrokerBinder() {
        return null;
    }

    @Override
    public final Feature[] getRequiredFeatures() {
        return new Feature[0];
    }

    @Override
    public final String getEndpointPackageName() {
        if (this.zab != null) {
            return this.zab;
        }
        Preconditions.checkNotNull((Object)this.zad);
        return this.zad.getPackageName();
    }

    @Override
    public final int getMinApkVersion() {
        return 0;
    }

    @Override
    public final Feature[] getAvailableFeatures() {
        return new Feature[0];
    }

    @Override
    @NonNull
    public final Set<Scope> getScopesForConnectionlessNonSignIn() {
        return Collections.emptySet();
    }

    @Override
    @Nullable
    public final String getLastDisconnectMessage() {
        return this.zak;
    }

    @WorkerThread
    @Nullable
    @KeepForSdk
    public final IBinder getBinder() {
        this.zab();
        return this.zai;
    }

    final /* synthetic */ void zaa() {
        this.zaj = false;
        this.zai = null;
        this.zaa("Disconnected.");
        this.zaf.onConnectionSuspended(1);
    }

    final /* synthetic */ void zaa(IBinder iBinder) {
        this.zaj = false;
        this.zai = iBinder;
        this.zaa("Connected.");
        this.zaf.onConnected(new Bundle());
    }
}

