/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zaci;
import com.google.android.gms.common.api.internal.zaco;
import com.google.android.gms.common.api.internal.zao;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@KeepName
@KeepForSdk
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zaa = new zao();
    private final Object zab = new Object();
    private final CallbackHandler<R> zac;
    private final WeakReference<GoogleApiClient> zad;
    private final CountDownLatch zae = new CountDownLatch(1);
    private final ArrayList<PendingResult.StatusListener> zaf = new ArrayList();
    @Nullable
    private ResultCallback<? super R> zag;
    private final AtomicReference<zaco> zah = new AtomicReference();
    @Nullable
    private R zai;
    private Status zaj;
    @KeepName
    private zaa mResultGuardian;
    private volatile boolean zak;
    private boolean zal;
    private boolean zam;
    @Nullable
    private ICancelToken zan;
    private volatile zaci<R> zao;
    private boolean zap = false;

    @Deprecated
    BasePendingResult() {
        this.zac = new CallbackHandler(Looper.getMainLooper());
        this.zad = new WeakReference<Object>(null);
    }

    @KeepForSdk
    protected BasePendingResult(@Nullable GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zac = new CallbackHandler(looper);
        this.zad = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    @KeepForSdk
    protected BasePendingResult(Looper looper) {
        this.zac = new CallbackHandler(looper);
        this.zad = new WeakReference<Object>(null);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BasePendingResult(@NonNull CallbackHandler<R> callbackHandler) {
        this.zac = (CallbackHandler)((Object)Preconditions.checkNotNull(callbackHandler, (Object)"CallbackHandler must not be null"));
        this.zad = new WeakReference<Object>(null);
    }

    @KeepForSdk
    public final boolean isReady() {
        return this.zae.getCount() == 0L;
    }

    @Override
    public final R await() {
        Preconditions.checkNotMainThread((String)"await must not be called on the UI thread");
        Preconditions.checkState((!this.zak ? 1 : 0) != 0, (Object)"Result has already been consumed");
        Preconditions.checkState((this.zao == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zae.await();
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.zac();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        if (l > 0L) {
            Preconditions.checkNotMainThread((String)"await must not be called on the UI thread when time is greater than zero.");
        }
        Preconditions.checkState((!this.zak ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Preconditions.checkState((this.zao == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zae.await(l, timeUnit)) {
                this.forceFailureUnlessReady(Status.RESULT_TIMEOUT);
            }
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.zac();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(@Nullable ResultCallback<? super R> resultCallback) {
        Object object = this.zab;
        synchronized (object) {
            if (resultCallback == null) {
                this.zag = null;
                return;
            }
            Preconditions.checkState((!this.zak ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((this.zao == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zac.zaa(resultCallback, (R)this.zac());
            } else {
                this.zag = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zab;
        synchronized (object) {
            if (resultCallback == null) {
                this.zag = null;
                return;
            }
            Preconditions.checkState((!this.zak ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((this.zao == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zac.zaa(resultCallback, (R)this.zac());
            } else {
                this.zag = resultCallback;
                long l2 = timeUnit.toMillis(l);
                BasePendingResult basePendingResult = this;
                CallbackHandler<R> callbackHandler = this.zac;
                callbackHandler.sendMessageDelayed(callbackHandler.obtainMessage(2, basePendingResult), l2);
            }
            return;
        }
    }

    @Nullable
    private static <R extends Result> ResultCallback<R> zab(@Nullable ResultCallback<R> resultCallback) {
        return resultCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStatusListener(PendingResult.StatusListener statusListener) {
        Preconditions.checkArgument((statusListener != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zab;
        synchronized (object) {
            if (this.isReady()) {
                statusListener.onComplete(this.zaj);
            } else {
                this.zaf.add(statusListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public void cancel() {
        Object object = this.zab;
        synchronized (object) {
            if (this.zal || this.zak) {
                return;
            }
            if (this.zan != null) {
                try {
                    this.zan.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zaa(this.zai);
            this.zal = true;
            this.zab(this.createFailedResult(Status.RESULT_CANCELED));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zaa() {
        Object object = this.zab;
        synchronized (object) {
            if ((GoogleApiClient)this.zad.get() == null || !this.zap) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zab;
        synchronized (object) {
            return this.zal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        Preconditions.checkState((!this.zak ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zab;
        synchronized (object) {
            Preconditions.checkState((this.zao == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zag == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            Preconditions.checkState((!this.zal ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zap = true;
            this.zao = new zaci(this.zad);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zao).then(resultTransform);
            if (this.isReady()) {
                this.zac.zaa(this.zao, this.zac());
            } else {
                this.zag = this.zao;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void setResult(R r) {
        Object object = this.zab;
        synchronized (object) {
            if (!this.zam && !this.zal) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                BasePendingResult.zaa(r);
                return;
            }
            Preconditions.checkState((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            Preconditions.checkState((!this.zak ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zab(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @KeepForSdk
    public final void forceFailureUnlessReady(Status status) {
        Object object = this.zab;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.createFailedResult(status));
                this.zam = true;
            }
            return;
        }
    }

    @NonNull
    @KeepForSdk
    protected abstract R createFailedResult(Status var1);

    public final void zaa(@Nullable zaco zaco2) {
        this.zah.set(zaco2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    protected final void setCancelToken(ICancelToken iCancelToken) {
        Object object = this.zab;
        synchronized (object) {
            this.zan = iCancelToken;
            return;
        }
    }

    public final void zab() {
        this.zap = this.zap || zaa.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R zac() {
        R r;
        Object object = this.zab;
        synchronized (object) {
            Preconditions.checkState((!this.zak ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zai;
            this.zai = null;
            this.zag = null;
            this.zak = true;
        }
        BasePendingResult basePendingResult = this;
        zaco zaco2 = basePendingResult.zah.getAndSet(null);
        if (zaco2 != null) {
            zaco2.zaa(basePendingResult);
        }
        return (R)((Result)Preconditions.checkNotNull(r));
    }

    private final void zab(R r) {
        this.zai = r;
        this.zaj = r.getStatus();
        this.zan = null;
        this.zae.countDown();
        if (this.zal) {
            this.zag = null;
        } else {
            ResultCallback<? super R> resultCallback = this.zag;
            if (resultCallback == null) {
                if (this.zai instanceof Releasable) {
                    this.mResultGuardian = new zaa(null);
                }
            } else {
                this.zac.removeMessages(2);
                this.zac.zaa(resultCallback, (R)this.zac());
            }
        }
        ArrayList<PendingResult.StatusListener> arrayList = this.zaf;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.StatusListener statusListener = arrayList.get(i);
            statusListener.onComplete(this.zaj);
        }
        this.zaf.clear();
    }

    public static void zaa(@Nullable Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zaa {
        private zaa() {
        }

        protected final void finalize() throws Throwable {
            BasePendingResult.zaa(BasePendingResult.this.zai);
            super.finalize();
        }

        /* synthetic */ zaa(zao zao2) {
            this();
        }
    }

    @VisibleForTesting
    public static class CallbackHandler<R extends Result>
    extends zap {
        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public final void zaa(@NonNull ResultCallback<? super R> resultCallback, R r) {
            resultCallback = (ResultCallback)Preconditions.checkNotNull((Object)BasePendingResult.zab(resultCallback));
            this.sendMessage(this.obtainMessage(1, new Pair((Object)resultCallback, r)));
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    Result result = (Result)pair.second;
                    ResultCallback resultCallback = (ResultCallback)pair.first;
                    try {
                        resultCallback.onResult(result);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zaa(result);
                        throw runtimeException;
                    }
                }
                case 2: {
                    ((BasePendingResult)message.obj).forceFailureUnlessReady(Status.RESULT_TIMEOUT);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }
    }
}

