/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaaa;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zaw;
import com.google.android.gms.common.api.internal.zax;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.util.concurrent.HandlerExecutor;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zac;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zav
implements zabr {
    private final Map<Api.AnyClientKey<?>, zaw<?>> zaeu = new HashMap();
    private final Map<Api.AnyClientKey<?>, zaw<?>> zaev = new HashMap();
    private final Map<Api<?>, Boolean> zaew;
    private final GoogleApiManager zabo;
    private final zaaw zaex;
    private final Lock zaer;
    private final Looper zabl;
    private final GoogleApiAvailabilityLight zaey;
    private final Condition zaez;
    private final ClientSettings zafa;
    private final boolean zafb;
    private final boolean zafc;
    private final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zafd = new LinkedList();
    @GuardedBy(value="mLock")
    private boolean zafe;
    @GuardedBy(value="mLock")
    private Map<ApiKey<?>, ConnectionResult> zaff;
    @GuardedBy(value="mLock")
    private Map<ApiKey<?>, ConnectionResult> zafg;
    @GuardedBy(value="mLock")
    private zaaa zafh;
    @GuardedBy(value="mLock")
    private ConnectionResult zafi;

    public zav(Context context, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zac, SignInOptions> abstractClientBuilder, ArrayList<zap> arrayList, zaaw zaaw2, boolean bl) {
        this.zaer = lock;
        this.zabl = looper;
        this.zaez = lock.newCondition();
        this.zaey = googleApiAvailabilityLight;
        this.zaex = zaaw2;
        this.zaew = map2;
        this.zafa = clientSettings;
        this.zafb = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.getClientKey(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zap> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zap zap2 = arrayList2.get(i);
            zap zap3 = zap2;
            hashMap2.put(zap3.mApi, zap3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.AnyClientKey<?>, Api.Client> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.Client client = entry.getValue();
            if (client.requiresGooglePlayServices()) {
                bl4 = true;
                if (!this.zaew.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zap zap4 = (zap)hashMap2.get(api);
            zaw zaw2 = new zaw(context, api, looper, client, zap4, clientSettings, abstractClientBuilder);
            this.zaeu.put(entry.getKey(), zaw2);
            if (!client.requiresSignIn()) continue;
            this.zaev.put(entry.getKey(), zaw2);
        }
        this.zafc = bl4 && !bl3 && !bl2;
        this.zabo = GoogleApiManager.zaba();
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        if (this.zafb && this.zab(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zafd.add(t);
            return t;
        }
        this.zaex.zahj.zac(t);
        return this.zaeu.get(t.getClientKey()).doRead(t);
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        Api.AnyClientKey<A> anyClientKey = t.getClientKey();
        if (this.zafb && this.zab(t)) {
            return t;
        }
        this.zaex.zahj.zac(t);
        return this.zaeu.get(anyClientKey).doWrite(t);
    }

    private final <T extends BaseImplementation.ApiMethodImpl<? extends Result, ? extends Api.AnyClient>> boolean zab(@NonNull T t) {
        Api.AnyClientKey<? extends Api.AnyClient> anyClientKey = t.getClientKey();
        ConnectionResult connectionResult = this.zaa(anyClientKey);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.setFailedResult(new Status(4, null, this.zabo.zaa(this.zaeu.get(anyClientKey).getApiKey(), System.identityHashCode(this.zaex))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zaer.lock();
        try {
            if (this.zafe) {
                return;
            }
            this.zafe = true;
            this.zaff = null;
            this.zafg = null;
            this.zafh = null;
            this.zafi = null;
            this.zabo.zam();
            this.zabo.zaa(this.zaeu.values()).addOnCompleteListener((Executor)new HandlerExecutor(this.zabl), (OnCompleteListener)new zax(this, null));
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zaez.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zafi != null) {
            return this.zafi;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zaez.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zafi != null) {
            return this.zafi;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zaer.lock();
        try {
            this.zafe = false;
            this.zaff = null;
            this.zafg = null;
            if (this.zafh != null) {
                this.zafh.cancel();
                this.zafh = null;
            }
            this.zafi = null;
            while (!this.zafd.isEmpty()) {
                BaseImplementation.ApiMethodImpl<?, ?> apiMethodImpl = this.zafd.remove();
                apiMethodImpl.zaa(null);
                ((PendingResult)apiMethodImpl).cancel();
            }
            this.zaez.signalAll();
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zaa(api.getClientKey());
    }

    @Nullable
    private final ConnectionResult zaa(@NonNull Api.AnyClientKey<?> anyClientKey) {
        block2: {
            this.zaer.lock();
            try {
                zaw<?> zaw2 = this.zaeu.get(anyClientKey);
                if (this.zaff == null || zaw2 == null) break block2;
                ConnectionResult connectionResult = this.zaff.get(zaw2.getApiKey());
                this.zaer.unlock();
                return connectionResult;
            }
            catch (Throwable throwable) {
                this.zaer.unlock();
                throw throwable;
            }
        }
        this.zaer.unlock();
        return null;
    }

    @Override
    public final boolean isConnected() {
        this.zaer.lock();
        try {
            boolean bl = this.zaff != null && this.zafi == null;
            return bl;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zaer.lock();
        try {
            boolean bl = this.zaff == null && this.zafe;
            return bl;
        }
        finally {
            this.zaer.unlock();
        }
    }

    private final boolean zaz() {
        block4: {
            this.zaer.lock();
            if (this.zafe && this.zafb) break block4;
            this.zaer.unlock();
            return false;
        }
        try {
            for (Api.AnyClientKey<?> anyClientKey : this.zaev.keySet()) {
                ConnectionResult connectionResult = this.zaa(anyClientKey);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                this.zaer.unlock();
                return false;
            }
        }
        catch (Throwable throwable) {
            this.zaer.unlock();
            throw throwable;
        }
        this.zaer.unlock();
        return true;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        block2: {
            this.zaer.lock();
            try {
                if (!this.zafe || this.zaz()) break block2;
                this.zabo.zam();
                this.zafh = new zaaa(this, signInConnectionListener);
                this.zabo.zaa(this.zaev.values()).addOnCompleteListener((Executor)new HandlerExecutor(this.zabl), (OnCompleteListener)this.zafh);
                this.zaer.unlock();
                return true;
            }
            catch (Throwable throwable) {
                this.zaer.unlock();
                throw throwable;
            }
        }
        this.zaer.unlock();
        return false;
    }

    @Override
    public final void maybeSignOut() {
        this.zaer.lock();
        try {
            this.zabo.maybeSignOut();
            if (this.zafh != null) {
                this.zafh.cancel();
                this.zafh = null;
            }
            if (this.zafg == null) {
                this.zafg = new ArrayMap(this.zaev.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zaw<?> zaw2 : this.zaev.values()) {
                this.zafg.put(zaw2.getApiKey(), connectionResult);
            }
            if (this.zaff != null) {
                this.zaff.putAll(this.zafg);
            }
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zau() {
    }

    @GuardedBy(value="mLock")
    private final void zaaa() {
        if (this.zafa == null) {
            this.zaex.zahe = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zafa.getRequiredScopes());
        Map<Api<?>, ClientSettings.OptionalApiSettings> map = this.zafa.getOptionalApiSettings();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).mScopes);
        }
        this.zaex.zahe = hashSet;
    }

    @GuardedBy(value="mLock")
    private final void zaab() {
        while (!this.zafd.isEmpty()) {
            this.execute(this.zafd.remove());
        }
        this.zaex.zab((Bundle)null);
    }

    private final boolean zaa(zaw<?> zaw2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zaew.get(zaw2.getApi()) != false && zaw2.zaad().requiresGooglePlayServices() && this.zaey.isUserResolvableError(connectionResult.getErrorCode());
    }

    @GuardedBy(value="mLock")
    @Nullable
    private final ConnectionResult zaac() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zaw<?> zaw2 : this.zaeu.values()) {
            int n3;
            Api api = zaw2.getApi();
            ApiKey apiKey = zaw2.getApiKey();
            ConnectionResult connectionResult3 = this.zaff.get(apiKey);
            if (connectionResult3.isSuccess() || this.zaew.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zaey.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zafb) {
                n3 = api.zah().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zah().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zaa(zav zav2) {
        return zav2.zaer;
    }

    static /* synthetic */ boolean zab(zav zav2) {
        return zav2.zafe;
    }

    static /* synthetic */ Map zaa(zav zav2, Map map) {
        zav2.zaff = map;
        return zav2.zaff;
    }

    static /* synthetic */ Map zac(zav zav2) {
        return zav2.zaeu;
    }

    static /* synthetic */ Map zad(zav zav2) {
        return zav2.zaff;
    }

    static /* synthetic */ boolean zae(zav zav2) {
        return zav2.zafc;
    }

    static /* synthetic */ boolean zaa(zav zav2, zaw zaw2, ConnectionResult connectionResult) {
        return zav2.zaa(zaw2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zaa(zav zav2, ConnectionResult connectionResult) {
        zav2.zafi = connectionResult;
        return zav2.zafi;
    }

    static /* synthetic */ ConnectionResult zaf(zav zav2) {
        return zav2.zaac();
    }

    static /* synthetic */ Map zag(zav zav2) {
        return zav2.zafg;
    }

    static /* synthetic */ ConnectionResult zah(zav zav2) {
        return zav2.zafi;
    }

    static /* synthetic */ void zai(zav zav2) {
        zav2.zaaa();
    }

    static /* synthetic */ void zaj(zav zav2) {
        zav2.zaab();
    }

    static /* synthetic */ boolean zaa(zav zav2, boolean bl) {
        zav2.zafe = false;
        return false;
    }

    static /* synthetic */ zaaw zak(zav zav2) {
        return zav2.zaex;
    }

    static /* synthetic */ Condition zal(zav zav2) {
        return zav2.zaez;
    }

    static /* synthetic */ Map zab(zav zav2, Map map) {
        zav2.zafg = map;
        return zav2.zafg;
    }

    static /* synthetic */ Map zam(zav zav2) {
        return zav2.zaev;
    }
}

