/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zal;
import com.google.android.gms.common.api.internal.zam;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zar;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zak
extends LifecycleCallback
implements DialogInterface.OnCancelListener {
    protected volatile boolean zadh;
    protected final AtomicReference<zam> zadi = new AtomicReference<Object>(null);
    private final Handler zadj = new zar(Looper.getMainLooper());
    protected final GoogleApiAvailability zace;

    protected zak(LifecycleFragment lifecycleFragment) {
        this(lifecycleFragment, GoogleApiAvailability.getInstance());
    }

    @VisibleForTesting
    private zak(LifecycleFragment lifecycleFragment, GoogleApiAvailability googleApiAvailability) {
        super(lifecycleFragment);
        this.zace = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zaa(new ConnectionResult(13, null), zak.zaa(this.zadi.get()));
        this.zao();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            zam zam2;
            Bundle bundle2 = bundle;
            if (bundle2.getBoolean("resolving_error", false)) {
                ConnectionResult connectionResult = new ConnectionResult(bundle2.getInt("failed_status"), (PendingIntent)bundle2.getParcelable("failed_resolution"));
                int n = bundle2.getInt("failed_client_id", -1);
                zam2 = new zam(connectionResult, n);
            } else {
                zam2 = null;
            }
            this.zadi.set(zam2);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Bundle bundle2 = bundle;
        zam zam2 = this.zadi.get();
        if (zam2 != null) {
            bundle2.putBoolean("resolving_error", true);
            bundle2.putInt("failed_client_id", zam2.zap());
            bundle2.putInt("failed_status", zam2.getConnectionResult().getErrorCode());
            bundle2.putParcelable("failed_resolution", (Parcelable)zam2.getConnectionResult().getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.zadh = true;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        zam zam2 = this.zadi.get();
        switch (n) {
            case 2: {
                int n3 = this.zace.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (zam2 == null) {
                    return;
                }
                if (zam2.getConnectionResult().getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                zam2 = new zam(new ConnectionResult(n4, null, zam2.getConnectionResult().toString()), zak.zaa(zam2));
                this.zadi.set(zam2);
            }
        }
        if (bl) {
            this.zao();
            return;
        }
        if (zam2 != null) {
            this.zaa(zam2.getConnectionResult(), zam2.zap());
        }
    }

    public void onStop() {
        super.onStop();
        this.zadh = false;
    }

    protected abstract void zaa(ConnectionResult var1, int var2);

    protected abstract void zam();

    protected final void zao() {
        this.zadi.set(null);
        this.zam();
    }

    public final void zab(ConnectionResult connectionResult, int n) {
        zam zam2 = new zam(connectionResult, n);
        if (this.zadi.compareAndSet(null, zam2)) {
            this.zadj.post((Runnable)new zal(this, zam2));
        }
    }

    private static int zaa(@Nullable zam zam2) {
        if (zam2 == null) {
            return -1;
        }
        return zam2.zap();
    }
}

