/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.internal.Objects;

public final class ApiKey<O extends Api.ApiOptions> {
    private final boolean zacx;
    private final int zacy;
    private final Api<O> mApi;
    private final O zabj;

    private ApiKey(Api<O> api, O o) {
        this.zacx = false;
        this.mApi = api;
        this.zabj = o;
        this.zacy = Objects.hashCode((Object[])new Object[]{this.mApi, this.zabj});
    }

    private ApiKey(Api<O> api) {
        this.zacx = true;
        this.mApi = api;
        this.zabj = null;
        this.zacy = System.identityHashCode(this);
    }

    public static <O extends Api.ApiOptions> ApiKey<O> getSharedApiKey(Api<O> api, O o) {
        return new ApiKey<O>(api, o);
    }

    public static <O extends Api.ApiOptions> ApiKey<O> getUniqueApiKey(Api<O> api) {
        return new ApiKey<O>(api);
    }

    public final Api.AnyClientKey<?> getClientKey() {
        return this.mApi.getClientKey();
    }

    public final boolean isUnique() {
        return this.zacx;
    }

    public final String getApiName() {
        return this.mApi.getName();
    }

    public final int hashCode() {
        return this.zacy;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ApiKey)) {
            return false;
        }
        ApiKey apiKey = (ApiKey)object;
        return !this.zacx && !apiKey.zacx && Objects.equal(this.mApi, apiKey.mApi) && Objects.equal(this.zabj, apiKey.zabj);
    }
}

