/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.OptionalPendingResultImpl;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public final class PendingResults {
    @KeepForSdk
    public static PendingResult<Status> immediatePendingResult(Status status) {
        Preconditions.checkNotNull((Object)status, (Object)"Result must not be null");
        StatusPendingResult statusPendingResult = new StatusPendingResult(Looper.getMainLooper());
        statusPendingResult.setResult(status);
        return statusPendingResult;
    }

    @KeepForSdk
    public static PendingResult<Status> immediatePendingResult(Status status, GoogleApiClient googleApiClient) {
        Preconditions.checkNotNull((Object)status, (Object)"Result must not be null");
        StatusPendingResult statusPendingResult = new StatusPendingResult(googleApiClient);
        statusPendingResult.setResult(status);
        return statusPendingResult;
    }

    @KeepForSdk
    public static <R extends Result> PendingResult<R> immediateFailedResult(R r, GoogleApiClient googleApiClient) {
        Preconditions.checkNotNull(r, (Object)"Result must not be null");
        Preconditions.checkArgument((!r.getStatus().isSuccess() ? 1 : 0) != 0, (Object)"Status code must not be SUCCESS");
        zac<R> zac2 = new zac<R>(googleApiClient, r);
        zac2.setResult(r);
        return zac2;
    }

    @KeepForSdk
    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R r) {
        Preconditions.checkNotNull(r, (Object)"Result must not be null");
        zab<R> zab2 = new zab<R>(null);
        zab2.setResult(r);
        return new OptionalPendingResultImpl(zab2);
    }

    @KeepForSdk
    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R r, GoogleApiClient googleApiClient) {
        Preconditions.checkNotNull(r, (Object)"Result must not be null");
        zab<R> zab2 = new zab<R>(googleApiClient);
        zab2.setResult(r);
        return new OptionalPendingResultImpl(zab2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        StatusPendingResult statusPendingResult = new StatusPendingResult(Looper.getMainLooper());
        ((PendingResult)statusPendingResult).cancel();
        return statusPendingResult;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R r) {
        Preconditions.checkNotNull(r, (Object)"Result must not be null");
        Preconditions.checkArgument((r.getStatus().getStatusCode() == 16 ? 1 : 0) != 0, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zaa<R> zaa2 = new zaa<R>(r);
        ((PendingResult)zaa2).cancel();
        return zaa2;
    }

    @KeepForSdk
    private PendingResults() {
    }

    private static final class zaa<R extends Result>
    extends BasePendingResult<R> {
        private final R zack;

        public zaa(R r) {
            super(Looper.getMainLooper());
            this.zack = r;
        }

        @Override
        protected final R createFailedResult(Status status) {
            if (status.getStatusCode() != this.zack.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zack;
        }
    }

    private static final class zac<R extends Result>
    extends BasePendingResult<R> {
        private final R zacl;

        public zac(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.zacl = r;
        }

        @Override
        protected final R createFailedResult(Status status) {
            return this.zacl;
        }
    }

    private static final class zab<R extends Result>
    extends BasePendingResult<R> {
        public zab(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected final R createFailedResult(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

