/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zaad;
import com.google.android.gms.common.api.internal.zabn;
import com.google.android.gms.common.api.internal.zace;
import com.google.android.gms.common.api.zab;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collections;

@KeepForSdk
public class GoogleApi<O extends Api.ApiOptions>
implements HasApiKey<O> {
    private final Context mContext;
    private final Api<O> mApi;
    private final O zabj;
    private final ApiKey<O> zabk;
    private final Looper zabl;
    private final int mId;
    private final GoogleApiClient zabm;
    private final StatusExceptionMapper zabn;
    protected final GoogleApiManager zabo;

    @KeepForSdk
    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        Preconditions.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        Preconditions.checkNotNull(api, (Object)"Api must not be null.");
        Preconditions.checkNotNull((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.mApi = api;
        this.zabj = null;
        this.zabl = looper;
        this.zabk = ApiKey.getUniqueApiKey(api);
        this.zabm = new zabn(this);
        this.zabo = GoogleApiManager.zab(this.mContext);
        this.mId = this.zabo.zabb();
        this.zabn = new ApiExceptionMapper();
    }

    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Context context, Api<O> api, @Nullable O o, Looper looper, StatusExceptionMapper statusExceptionMapper) {
        this(context, api, o, new Settings.Builder().setLooper(looper).setMapper(statusExceptionMapper).build());
    }

    @MainThread
    @KeepForSdk
    public GoogleApi(@NonNull Activity activity, Api<O> api, @Nullable O o, Settings settings) {
        Preconditions.checkNotNull((Object)activity, (Object)"Null activity is not permitted.");
        Preconditions.checkNotNull(api, (Object)"Api must not be null.");
        Preconditions.checkNotNull((Object)settings, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.mApi = api;
        this.zabj = o;
        this.zabl = settings.zabq;
        this.zabk = ApiKey.getSharedApiKey(this.mApi, this.zabj);
        this.zabm = new zabn(this);
        this.zabo = GoogleApiManager.zab(this.mContext);
        this.mId = this.zabo.zabb();
        this.zabn = settings.zabp;
        if (!(activity instanceof GoogleApiActivity)) {
            zaad.zaa(activity, this.zabo, this.zabk);
        }
        this.zabo.zaa(this);
    }

    @KeepForSdk
    public GoogleApi(@NonNull Context context, Api<O> api, @Nullable O o, Settings settings) {
        Preconditions.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        Preconditions.checkNotNull(api, (Object)"Api must not be null.");
        Preconditions.checkNotNull((Object)settings, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.mApi = api;
        this.zabj = o;
        this.zabl = settings.zabq;
        this.zabk = ApiKey.getSharedApiKey(this.mApi, this.zabj);
        this.zabm = new zabn(this);
        this.zabo = GoogleApiManager.zab(this.mContext);
        this.mId = this.zabo.zabb();
        this.zabn = settings.zabp;
        this.zabo.zaa(this);
    }

    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Activity activity, Api<O> api, @Nullable O o, StatusExceptionMapper statusExceptionMapper) {
        this(activity, api, o, new Settings.Builder().setMapper(statusExceptionMapper).setLooper(activity.getMainLooper()).build());
    }

    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Context context, Api<O> api, @Nullable O o, StatusExceptionMapper statusExceptionMapper) {
        this(context, api, o, new Settings.Builder().setMapper(statusExceptionMapper).build());
    }

    private final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T zaa(int n, @NonNull T t) {
        t.zar();
        this.zabo.zaa(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.AnyClient> Task<TResult> zaa(int n, @NonNull TaskApiCall<A, TResult> taskApiCall) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zabo.zaa(this, n, taskApiCall, taskCompletionSource, this.zabn);
        return taskCompletionSource.getTask();
    }

    @KeepForSdk
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doRead(@NonNull T t) {
        return this.zaa(0, t);
    }

    @KeepForSdk
    public <TResult, A extends Api.AnyClient> Task<TResult> doRead(TaskApiCall<A, TResult> taskApiCall) {
        return this.zaa(0, taskApiCall);
    }

    @KeepForSdk
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doWrite(@NonNull T t) {
        return this.zaa(1, t);
    }

    @KeepForSdk
    public <TResult, A extends Api.AnyClient> Task<TResult> doWrite(TaskApiCall<A, TResult> taskApiCall) {
        return this.zaa(1, taskApiCall);
    }

    @KeepForSdk
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doBestEffortWrite(@NonNull T t) {
        return this.zaa(2, t);
    }

    @KeepForSdk
    public <TResult, A extends Api.AnyClient> Task<TResult> doBestEffortWrite(TaskApiCall<A, TResult> taskApiCall) {
        return this.zaa(2, taskApiCall);
    }

    @Deprecated
    @KeepForSdk
    public <A extends Api.AnyClient, T extends RegisterListenerMethod<A, ?>, U extends UnregisterListenerMethod<A, ?>> Task<Void> doRegisterEventListener(@NonNull T t, U u) {
        Preconditions.checkNotNull(t);
        Preconditions.checkNotNull(u);
        Preconditions.checkNotNull(t.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(u.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkArgument((boolean)t.getListenerKey().equals(u.getListenerKey()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.zabo.zaa(this, t, u);
    }

    @KeepForSdk
    public <A extends Api.AnyClient> Task<Void> doRegisterEventListener(@NonNull RegistrationMethods<A, ?> registrationMethods) {
        Preconditions.checkNotNull(registrationMethods);
        Preconditions.checkNotNull(registrationMethods.zaka.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(registrationMethods.zakb.getListenerKey(), (Object)"Listener has already been released.");
        return this.zabo.zaa(this, registrationMethods.zaka, registrationMethods.zakb);
    }

    @KeepForSdk
    public Task<Boolean> doUnregisterEventListener(@NonNull ListenerHolder.ListenerKey<?> listenerKey) {
        Preconditions.checkNotNull(listenerKey, (Object)"Listener key cannot be null.");
        return this.zabo.zaa(this, listenerKey);
    }

    @KeepForSdk
    public <L> ListenerHolder<L> registerListener(@NonNull L l, String string2) {
        return ListenerHolders.createListenerHolder(l, this.zabl, string2);
    }

    @KeepForSdk
    protected Task<Boolean> disconnectService() {
        return this.zabo.zac(this);
    }

    @WorkerThread
    public Api.Client zaa(Looper looper, GoogleApiManager.zaa<O> zaa2) {
        ClientSettings clientSettings = this.createClientSettingsBuilder().build();
        return this.mApi.zai().buildClient(this.mContext, looper, clientSettings, this.zabj, zaa2, zaa2);
    }

    public final Api<O> getApi() {
        return this.mApi;
    }

    @KeepForSdk
    public O getApiOptions() {
        return this.zabj;
    }

    @Override
    public ApiKey<O> getApiKey() {
        return this.zabk;
    }

    public final int getInstanceId() {
        return this.mId;
    }

    @KeepForSdk
    public GoogleApiClient asGoogleApiClient() {
        return this.zabm;
    }

    @KeepForSdk
    public Looper getLooper() {
        return this.zabl;
    }

    @KeepForSdk
    public Context getApplicationContext() {
        return this.mContext;
    }

    @KeepForSdk
    protected ClientSettings.Builder createClientSettingsBuilder() {
        GoogleSignInAccount googleSignInAccount;
        GoogleApi googleApi = this;
        Account account = googleApi.zabj instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zabj).getGoogleSignInAccount()) != null ? googleSignInAccount.getAccount() : (googleApi.zabj instanceof Api.ApiOptions.HasAccountOptions ? ((Api.ApiOptions.HasAccountOptions)googleApi.zabj).getAccount() : null);
        googleApi = this;
        return new ClientSettings.Builder().setAccount(account).addAllRequiredScopes(googleApi.zabj instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zabj).getGoogleSignInAccount()) != null ? googleSignInAccount.getRequestedScopes() : Collections.emptySet()).setRealClientClassName(this.mContext.getClass().getName()).setRealClientPackageName(this.mContext.getPackageName());
    }

    public zace zaa(Context context, Handler handler) {
        return new zace(context, handler, this.createClientSettingsBuilder().build());
    }

    @KeepForSdk
    public static class Settings {
        @KeepForSdk
        public static final Settings DEFAULT_SETTINGS = new Builder().build();
        public final StatusExceptionMapper zabp;
        public final Looper zabq;

        @KeepForSdk
        private Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper) {
            this.zabp = statusExceptionMapper;
            this.zabq = looper;
        }

        /* synthetic */ Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper, zab zab2) {
            this(statusExceptionMapper, null, looper);
        }

        @KeepForSdk
        public static class Builder {
            private StatusExceptionMapper zabn;
            private Looper zabl;

            @KeepForSdk
            public Builder() {
            }

            @KeepForSdk
            public Builder setMapper(StatusExceptionMapper statusExceptionMapper) {
                Preconditions.checkNotNull((Object)statusExceptionMapper, (Object)"StatusExceptionMapper must not be null.");
                this.zabn = statusExceptionMapper;
                return this;
            }

            @KeepForSdk
            public Builder setLooper(Looper looper) {
                Preconditions.checkNotNull((Object)looper, (Object)"Looper must not be null.");
                this.zabl = looper;
                return this;
            }

            @KeepForSdk
            public Settings build() {
                if (this.zabn == null) {
                    this.zabn = new ApiExceptionMapper();
                }
                if (this.zabl == null) {
                    this.zabl = Looper.getMainLooper();
                }
                return new Settings(this.zabn, null, this.zabl, null);
            }
        }
    }
}

