/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.zaa;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@ShowFirstParty
@SafeParcelable.Class(creator="BitmapTeleporterCreator")
@KeepForSdk
public class BitmapTeleporter
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @KeepForSdk
    public static final Parcelable.Creator<BitmapTeleporter> CREATOR = new zaa();
    @SafeParcelable.VersionField(id=1)
    private final int zalf;
    @SafeParcelable.Field(id=2)
    private ParcelFileDescriptor zalg;
    @SafeParcelable.Field(id=3)
    private final int mType;
    private Bitmap zalh;
    private boolean zali;
    private File zalj;

    @SafeParcelable.Constructor
    BitmapTeleporter(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) ParcelFileDescriptor parcelFileDescriptor, @SafeParcelable.Param(id=3) int n2) {
        this.zalf = n;
        this.zalg = parcelFileDescriptor;
        this.mType = n2;
        this.zalh = null;
        this.zali = false;
    }

    @KeepForSdk
    public BitmapTeleporter(Bitmap bitmap) {
        this.zalf = 1;
        this.zalg = null;
        this.mType = 0;
        this.zalh = bitmap;
        this.zali = true;
    }

    @KeepForSdk
    public Bitmap get() {
        if (!this.zali) {
            Bitmap.Config config;
            int n;
            int n2;
            byte[] byArray;
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zalg));
            try {
                byArray = new byte[dataInputStream.readInt()];
                n2 = dataInputStream.readInt();
                n = dataInputStream.readInt();
                config = Bitmap.Config.valueOf((String)dataInputStream.readUTF());
                dataInputStream.read(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                BitmapTeleporter.zaa(dataInputStream);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)config);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            this.zalh = bitmap;
            this.zali = true;
        }
        return this.zalh;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.zalg == null) {
            Bitmap bitmap = this.zalh;
            ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            byte[] byArray = byteBuffer.array();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.zabz());
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            try {
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.writeInt(bitmap.getWidth());
                dataOutputStream.writeInt(bitmap.getHeight());
                dataOutputStream.writeUTF(bitmap.getConfig().toString());
                dataOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not write into unlinked file", iOException);
            }
            finally {
                BitmapTeleporter.zaa(dataOutputStream);
            }
        }
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        BitmapTeleporter bitmapTeleporter = this;
        int n3 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)bitmapTeleporter.zalf);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)bitmapTeleporter.zalg, (int)n2, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)bitmapTeleporter.mType);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n3);
        this.zalg = null;
    }

    @KeepForSdk
    public void release() {
        if (!this.zali) {
            try {
                this.zalg.close();
                return;
            }
            catch (IOException iOException) {
                Log.w((String)"BitmapTeleporter", (String)"Could not close PFD", (Throwable)iOException);
            }
        }
    }

    @KeepForSdk
    public void setTempDir(File file) {
        if (file == null) {
            throw new NullPointerException("Cannot set null temp directory");
        }
        this.zalj = file;
    }

    private final FileOutputStream zabz() {
        FileOutputStream fileOutputStream;
        File file;
        if (this.zalj == null) {
            throw new IllegalStateException("setTempDir() must be called before writing this object to a parcel");
        }
        try {
            file = File.createTempFile("teleporter", ".tmp", this.zalj);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not create temporary file", iOException);
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            this.zalg = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Temporary file is somehow already deleted");
        }
        file.delete();
        return fileOutputStream;
    }

    private static void zaa(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)"BitmapTeleporter", (String)"Could not close stream", (Throwable)iOException);
            return;
        }
    }
}

