/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.BinderThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.zacf;
import com.google.android.gms.common.api.internal.zacg;
import com.google.android.gms.common.api.internal.zach;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.zac;
import com.google.android.gms.signin.internal.zaj;
import com.google.android.gms.signin.zaa;
import com.google.android.gms.signin.zad;
import java.util.Set;

public final class zace
extends zac
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static Api.AbstractClientBuilder<? extends zad, SignInOptions> zaki = zaa.zaph;
    private final Context mContext;
    private final Handler mHandler;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zaau;
    private Set<Scope> mScopes;
    private ClientSettings zaet;
    private zad zagb;
    private zach zakj;

    @WorkerThread
    public zace(Context context, Handler handler, @NonNull ClientSettings clientSettings) {
        this(context, handler, clientSettings, zaki);
    }

    @WorkerThread
    public zace(Context context, Handler handler, @NonNull ClientSettings clientSettings, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder) {
        this.mContext = context;
        this.mHandler = handler;
        this.zaet = (ClientSettings)Preconditions.checkNotNull((Object)clientSettings, (Object)"ClientSettings must not be null");
        this.mScopes = clientSettings.getRequiredScopes();
        this.zaau = abstractClientBuilder;
    }

    @WorkerThread
    public final void zaa(zach zach2) {
        if (this.zagb != null) {
            this.zagb.disconnect();
        }
        this.zaet.setClientSessionId(System.identityHashCode(this));
        this.zagb = this.zaau.buildClient(this.mContext, this.mHandler.getLooper(), this.zaet, this.zaet.getSignInOptions(), this, this);
        this.zakj = zach2;
        if (this.mScopes == null || this.mScopes.isEmpty()) {
            this.mHandler.post((Runnable)new zacf(this));
            return;
        }
        this.zagb.connect();
    }

    public final zad zabq() {
        return this.zagb;
    }

    public final void zabs() {
        if (this.zagb != null) {
            this.zagb.disconnect();
        }
    }

    @Override
    @WorkerThread
    public final void onConnected(@Nullable Bundle bundle) {
        this.zagb.zaa(this);
    }

    @Override
    @WorkerThread
    public final void onConnectionSuspended(int n) {
        this.zagb.disconnect();
    }

    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.zakj.zag(connectionResult);
    }

    @Override
    @BinderThread
    public final void zab(zaj zaj2) {
        this.mHandler.post((Runnable)new zacg(this, zaj2));
    }

    @WorkerThread
    private final void zac(zaj zaj2) {
        ConnectionResult connectionResult = zaj2.getConnectionResult();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = zaj2.zacx();
            ConnectionResult connectionResult2 = resolveAccountResponse.getConnectionResult();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"SignInCoordinator", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zakj.zag(connectionResult2);
                this.zagb.disconnect();
                return;
            }
            this.zakj.zaa(resolveAccountResponse.getAccountAccessor(), this.mScopes);
        } else {
            this.zakj.zag(connectionResult);
        }
        this.zagb.disconnect();
    }

    static /* synthetic */ zach zaa(zace zace2) {
        return zace2.zakj;
    }

    static /* synthetic */ void zaa(zace zace2, zaj zaj2) {
        zace2.zac(zaj2);
    }
}

